/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.web.actions;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.forum.dto.MessageDTO;
import org.lamsfoundation.lams.tool.forum.dto.SessionDTO;
import org.lamsfoundation.lams.tool.forum.dto.UserDTO;
import org.lamsfoundation.lams.tool.forum.persistence.Forum;
import org.lamsfoundation.lams.tool.forum.persistence.ForumReport;
import org.lamsfoundation.lams.tool.forum.persistence.ForumToolSession;
import org.lamsfoundation.lams.tool.forum.persistence.ForumUser;
import org.lamsfoundation.lams.tool.forum.persistence.Message;
import org.lamsfoundation.lams.tool.forum.service.IForumService;
import org.lamsfoundation.lams.tool.forum.util.ForumWebUtils;
import org.lamsfoundation.lams.tool.forum.web.forms.ForumForm;
import org.lamsfoundation.lams.tool.forum.web.forms.MarkForm;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.NumberUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.util.SessionMap;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class MonitoringAction
extends Action {
    private static Logger log = Logger.getLogger(MonitoringAction.class);
    private IForumService forumService;

    public final ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = mapping.getParameter();
        if (param.equals("init")) {
            return this.init(mapping, form, request, response);
        }
        if (param.equals("statistic")) {
            return this.statistic(mapping, form, request, response);
        }
        if (param.equals("viewAllMarks")) {
            return this.viewAllMarks(mapping, form, request, response);
        }
        if (param.equals("downloadMarks")) {
            return this.downloadMarks(mapping, form, request, response);
        }
        if (param.equals("viewUserMark")) {
            return this.viewUserMark(mapping, form, request, response);
        }
        if (param.equals("editMark")) {
            return this.editMark(mapping, form, request, response);
        }
        if (param.equals("updateMark")) {
            return this.updateMark(mapping, form, request, response);
        }
        if (param.equals("releaseMark")) {
            return this.releaseMark(mapping, form, request, response);
        }
        if (param.equals("viewTopic")) {
            return this.viewTopic(mapping, form, request, response);
        }
        if (param.equals("viewTopicTree")) {
            return this.viewTopicTree(mapping, form, request, response);
        }
        if (param.equals("viewReflection")) {
            return this.viewReflection(mapping, form, request, response);
        }
        return mapping.findForward("error");
    }

    private ActionForward init(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.doTabs(mapping, form, request, response);
        return mapping.findForward("load");
    }

    private ActionForward doTabs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        request.setAttribute("contentFolderID", (Object)contentFolderID);
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        request.setAttribute("toolContentID", (Object)toolContentID);
        request.setAttribute("initialTabId", (Object)WebUtil.readLongParam((HttpServletRequest)request, (String)"currentTab", (boolean)true));
        this.summary(mapping, form, request, response);
        this.viewInstructions(mapping, form, request, response);
        this.viewActivity(mapping, form, request, response, toolContentID);
        this.statistic(mapping, form, request, response);
        return mapping.findForward("load");
    }

    private ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        this.forumService = this.getForumService();
        List sessionsList = this.forumService.getSessionsByContentId(toolContentID);
        TreeMap<SessionDTO, TreeSet<UserDTO>> sessionUsersMap = new TreeMap<SessionDTO, TreeSet<UserDTO>>(new SessionDTOComparator());
        Iterator it = sessionsList.iterator();
        while (it.hasNext()) {
            SessionDTO sessionDto = new SessionDTO();
            ForumToolSession fts = (ForumToolSession)it.next();
            boolean hasReflection = fts.getForum().isReflectOnActivity();
            sessionDto.setSessionID(fts.getSessionId());
            sessionDto.setSessionName(fts.getSessionName());
            List userList = this.forumService.getUsersBySessionId(fts.getSessionId());
            List<MessageDTO> topicList = this.forumService.getAllTopicsFromSession(fts.getSessionId());
            Map topicsByUser = this.getTopicsSortedByAuthor(topicList);
            TreeSet<UserDTO> dtoList = new TreeSet<UserDTO>(new UserDTOComparator());
            for (ForumUser user : userList) {
                UserDTO userDTO = new UserDTO(user);
                userDTO.setHasRefection(hasReflection);
                userDTO.setAnyPostsMarked(false);
                userDTO.setNoOfPosts(0);
                List messages = (List)topicsByUser.get(user);
                if (messages != null && messages.size() > 0) {
                    userDTO.setNoOfPosts(messages.size());
                    for (MessageDTO message : messages) {
                        if (message.getMark() == null) continue;
                        userDTO.setAnyPostsMarked(true);
                        break;
                    }
                }
                dtoList.add(userDTO);
            }
            sessionUsersMap.put(sessionDto, dtoList);
        }
        request.setAttribute("sessionUserMap", sessionUsersMap);
        return mapping.findForward("success");
    }

    private ActionForward downloadMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        this.forumService = this.getForumService();
        List<MessageDTO> topicList = this.forumService.getAllTopicsFromSession(sessionID);
        ActionMessages errors = new ActionMessages();
        try {
            HSSFWorkbook wb = new HSSFWorkbook();
            HSSFSheet sheet = wb.createSheet("Marks");
            sheet.setColumnWidth((short)0, (short)5000);
            HSSFRow row = null;
            Iterator iter = this.getTopicsSortedByAuthor(topicList).values().iterator();
            boolean first = true;
            int idx = 0;
            int fileCount = 0;
            while (iter.hasNext()) {
                List list = (List)iter.next();
                Iterator dtoIter = list.iterator();
                first = true;
                while (dtoIter.hasNext()) {
                    HSSFCell cell;
                    MessageDTO dto = (MessageDTO)dtoIter.next();
                    if (first) {
                        first = false;
                        row = sheet.createRow(0);
                        cell = row.createCell((short)idx);
                        cell.setEncoding((short)1);
                        cell.setCellValue(this.getMessageService().getMessage("lable.topic.title.subject"));
                        sheet.setColumnWidth((short)idx, (short)8000);
                        cell = row.createCell((short)(++idx));
                        cell.setEncoding((short)1);
                        cell.setCellValue(this.getMessageService().getMessage("lable.topic.title.author"));
                        sheet.setColumnWidth((short)idx, (short)8000);
                        cell = row.createCell((short)(++idx));
                        cell.setEncoding((short)1);
                        cell.setCellValue(this.getMessageService().getMessage("label.download.marks.heading.date"));
                        sheet.setColumnWidth((short)idx, (short)8000);
                        cell = row.createCell((short)(++idx));
                        cell.setEncoding((short)1);
                        cell.setCellValue(this.getMessageService().getMessage("label.download.marks.heading.marks"));
                        sheet.setColumnWidth((short)idx, (short)8000);
                        cell = row.createCell((short)(++idx));
                        cell.setEncoding((short)1);
                        cell.setCellValue(this.getMessageService().getMessage("label.download.marks.heading.comments"));
                        sheet.setColumnWidth((short)idx, (short)8000);
                        ++idx;
                    }
                    idx = 0;
                    row = sheet.createRow(++fileCount);
                    cell = row.createCell((short)idx++);
                    cell.setEncoding((short)1);
                    cell.setCellValue(dto.getMessage().getSubject());
                    cell = row.createCell((short)idx++);
                    cell.setEncoding((short)1);
                    cell.setCellValue(dto.getAuthor());
                    cell = row.createCell((short)idx++);
                    cell.setEncoding((short)1);
                    cell.setCellValue(DateFormat.getInstance().format(dto.getMessage().getCreated()));
                    cell = row.createCell((short)idx++);
                    cell.setEncoding((short)1);
                    if (dto.getMessage() != null && dto.getMessage().getReport() != null && dto.getMessage().getReport().getMark() != null) {
                        cell.setCellValue(NumberUtil.formatLocalisedNumber((Number)dto.getMessage().getReport().getMark(), (Locale)request.getLocale(), (int)2));
                    } else {
                        cell.setCellValue("");
                    }
                    cell = row.createCell((short)idx++);
                    cell.setEncoding((short)1);
                    if (dto.getMessage() != null && dto.getMessage().getReport() != null) {
                        cell.setCellValue(dto.getMessage().getReport().getComment());
                        continue;
                    }
                    cell.setCellValue("");
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            wb.write((OutputStream)bos);
            String fileName = "marks" + sessionID + ".xls";
            String mineType = "application/vnd.ms-excel";
            String header = "attachment; filename=\"" + fileName + "\";";
            response.setContentType(mineType);
            response.setHeader("Content-Disposition", header);
            byte[] data = bos.toByteArray();
            response.getOutputStream().write(data, 0, data.length);
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            log.error((Object)e);
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("monitoring.download.error", (Object)e.toString()));
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            request.setAttribute("toolSessionID", (Object)sessionID);
            return mapping.getInputForward();
        }
        return null;
    }

    private ActionForward viewActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, Long toolContentID) {
        this.forumService = this.getForumService();
        Forum forum = this.forumService.getForumByContentId(toolContentID);
        if (forum == null) {
            ActionErrors errors = new ActionErrors();
            errors.add("activity.globel", new ActionMessage("error.fail.get.forum"));
            this.addErrors(request, (ActionMessages)errors);
            return mapping.getInputForward();
        }
        String title = forum.getTitle();
        String instruction = forum.getInstructions();
        boolean isForumEditable = ForumWebUtils.isForumEditable(forum);
        request.setAttribute("isPageEditable", (Object)new Boolean(isForumEditable));
        request.setAttribute("title", (Object)title);
        request.setAttribute("instruction", (Object)instruction);
        return mapping.findForward("success");
    }

    private ActionForward viewInstructions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        this.forumService = this.getForumService();
        Forum forum = this.forumService.getForumByContentId(toolContentID);
        if (forum == null) {
            ActionErrors errors = new ActionErrors();
            errors.add("instruction.globel", new ActionMessage("error.fail.get.forum"));
            this.addErrors(request, (ActionMessages)errors);
            return mapping.getInputForward();
        }
        ForumForm forumForm = new ForumForm();
        forumForm.setForum(forum);
        request.setAttribute("forumBean", (Object)forumForm);
        return mapping.findForward("success");
    }

    private ActionForward statistic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        this.forumService = this.getForumService();
        TreeMap<SessionDTO, List> sessionTopicsMap = new TreeMap<SessionDTO, List>(new SessionDTOComparator());
        HashMap<Long, Float> sessionAvaMarkMap = new HashMap<Long, Float>();
        HashMap<Long, Integer> sessionTotalMsgMap = new HashMap<Long, Integer>();
        List sessList = this.forumService.getSessionsByContentId(toolContentID);
        for (ForumToolSession session : sessList) {
            List topicList = this.forumService.getRootTopics(session.getSessionId());
            Iterator iter = topicList.iterator();
            int totalMsg = 0;
            float totalMsgMarkSum = 0.0f;
            float msgMarkSum = 0.0f;
            while (iter.hasNext()) {
                MessageDTO msgDto = (MessageDTO)iter.next();
                List topicThread = this.forumService.getTopicThread(msgDto.getMessage().getUid());
                msgMarkSum = 0.0f;
                Iterator threadIter = topicThread.iterator();
                int msgNum = 0;
                while (threadIter.hasNext()) {
                    MessageDTO dto = (MessageDTO)threadIter.next();
                    if (dto.getMark() != null) {
                        msgMarkSum += dto.getMark().floatValue();
                    }
                    ++msgNum;
                }
                totalMsgMarkSum += msgMarkSum;
                msgDto.setMark(Float.valueOf(msgMarkSum / (float)msgNum));
                totalMsg += msgNum;
            }
            float averMark = totalMsg == 0 ? 0.0f : totalMsgMarkSum / (float)totalMsg;
            SessionDTO sessionDto = new SessionDTO();
            sessionDto.setSessionID(session.getSessionId());
            sessionDto.setSessionName(session.getSessionName());
            sessionTopicsMap.put(sessionDto, topicList);
            sessionAvaMarkMap.put(session.getSessionId(), Float.valueOf(averMark));
            sessionTotalMsgMap.put(session.getSessionId(), new Integer(totalMsg));
        }
        request.setAttribute("topicList", sessionTopicsMap);
        request.setAttribute("markAverage", sessionAvaMarkMap);
        request.setAttribute("totalMessage", sessionTotalMsgMap);
        return mapping.findForward("success");
    }

    private ActionForward viewTopicTree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long rootTopicId = WebUtil.readLongParam((HttpServletRequest)request, (String)"topicID");
        this.forumService = this.getForumService();
        List msgDtoList = this.forumService.getTopicThread(rootTopicId);
        request.setAttribute("topicThread", (Object)msgDtoList);
        return mapping.findForward("success");
    }

    private ActionForward viewReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long uid = WebUtil.readLongParam((HttpServletRequest)request, (String)"userUid");
        Long sessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        ForumUser user = this.forumService.getUser(uid);
        NotebookEntry notebookEntry = this.forumService.getEntry(sessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lafrum11", user.getUserId().intValue());
        ForumToolSession session = this.forumService.getSessionBySessionId(sessionID);
        UserDTO userDTO = new UserDTO(user);
        if (notebookEntry == null) {
            userDTO.setFinishReflection(false);
            userDTO.setReflect(null);
        } else {
            userDTO.setFinishReflection(true);
            userDTO.setReflect(notebookEntry.getEntry());
        }
        userDTO.setReflectInstrctions(session.getForum().getReflectInstructions());
        request.setAttribute("userDTO", (Object)userDTO);
        return mapping.findForward("success");
    }

    private ActionForward viewTopic(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long msgUid = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"topicID"));
        this.forumService = this.getForumService();
        Message topic = this.forumService.getMessage(msgUid);
        request.setAttribute("topic", (Object)MessageDTO.getMessageDTO(topic));
        return mapping.findForward("success");
    }

    private ActionForward releaseMark(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.forumService = this.getForumService();
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        this.forumService.releaseMarksForSession(sessionID);
        try {
            PrintWriter out = response.getWriter();
            ForumToolSession session = this.forumService.getSessionBySessionId(sessionID);
            String sessionName = "";
            if (session != null) {
                sessionName = session.getSessionName();
            }
            out.write(this.getMessageService().getMessage("msg.mark.released", (Object[])new String[]{sessionName}));
            out.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    private ActionForward viewAllMarks(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long sessionID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        sessionMap.put((Object)"toolSessionID", (Object)sessionID);
        sessionMap.put((Object)"updateMode", (Object)"listAllMarks");
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        this.forumService = this.getForumService();
        List<MessageDTO> topicList = this.forumService.getAllTopicsFromSession(sessionID);
        Map topicsByUser = this.getTopicsSortedByAuthor(topicList);
        request.setAttribute("report", (Object)topicsByUser);
        return mapping.findForward("success");
    }

    private ActionForward viewUserMark(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long userUid = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"userID"));
        Long sessionId = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID"));
        SessionMap sessionMap = new SessionMap();
        request.getSession().setAttribute(sessionMap.getSessionID(), (Object)sessionMap);
        sessionMap.put((Object)"toolSessionID", (Object)sessionId);
        sessionMap.put((Object)"updateMode", (Object)"listMarks");
        request.setAttribute("sessionMapID", (Object)sessionMap.getSessionID());
        this.forumService = this.getForumService();
        List messageList = this.forumService.getMessagesByUserUid(userUid, sessionId);
        ForumUser user = this.forumService.getUser(userUid);
        TreeMap<ForumUser, List> report = new TreeMap<ForumUser, List>(new ForumUserComparator());
        report.put(user, messageList);
        request.setAttribute("report", report);
        return mapping.findForward("success");
    }

    private ActionForward editMark(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MarkForm markForm = (MarkForm)form;
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(markForm.getSessionMapID());
        String updateMode = (String)sessionMap.get((Object)"updateMode");
        if (StringUtils.isBlank((String)updateMode)) {
            sessionMap.put((Object)"updateMode", (Object)"viewForum");
            sessionMap.put((Object)"rootUid", (Object)markForm.getTopicID());
        }
        this.forumService = this.getForumService();
        Message msg = this.forumService.getMessage(markForm.getTopicID());
        ForumUser user = msg.getCreatedBy();
        if (msg.getReport() != null) {
            if (msg.getReport().getMark() != null) {
                markForm.setMark(NumberUtil.formatLocalisedNumber((Number)msg.getReport().getMark(), (Locale)request.getLocale(), (int)2));
            } else {
                markForm.setMark("");
            }
            markForm.setComment(msg.getReport().getComment());
        }
        request.setAttribute("topic", (Object)MessageDTO.getMessageDTO(msg));
        request.setAttribute("user", (Object)user);
        boolean hideReflection = WebUtil.readBooleanParam((HttpServletRequest)request, (String)"hideReflection", (boolean)false);
        sessionMap.put((Object)"hideReflection", (Object)hideReflection);
        return mapping.findForward("success");
    }

    private ActionForward updateMark(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        MarkForm markForm = (MarkForm)form;
        request.setAttribute("sessionMapID", (Object)markForm.getSessionMapID());
        String markStr = markForm.getMark();
        Float mark = null;
        ActionMessages errors = new ActionMessages();
        if (StringUtils.isBlank((String)markStr)) {
            ActionMessage error = new ActionMessage("error.valueReqd");
            errors.add("report.mark", error);
        } else {
            try {
                mark = NumberUtil.getLocalisedFloat((String)markStr, (Locale)request.getLocale());
            }
            catch (Exception e) {
                ActionMessage error = new ActionMessage("error.mark.invalid.number");
                errors.add("report.mark", error);
            }
        }
        this.forumService = this.getForumService();
        Message msg = this.forumService.getMessage(markForm.getTopicID());
        ForumUser user = msg.getCreatedBy();
        request.setAttribute("user", (Object)user);
        if (!errors.isEmpty()) {
            request.setAttribute("topic", (Object)MessageDTO.getMessageDTO(msg));
            this.saveErrors(request, errors);
            return mapping.getInputForward();
        }
        this.forumService = this.getForumService();
        ForumReport report = msg.getReport();
        if (report == null) {
            report = new ForumReport();
            msg.setReport(report);
        }
        SessionMap sessionMap = (SessionMap)request.getSession().getAttribute(markForm.getSessionMapID());
        Long sessionId = (Long)sessionMap.get((Object)"toolSessionID");
        String updateMode = (String)sessionMap.get((Object)"updateMode");
        ForumToolSession toolSession = this.forumService.getSessionBySessionId(sessionId);
        if (toolSession.isMarkReleased()) {
            report.setDateMarksReleased(new Date());
        }
        report.setMark(mark);
        report.setComment(markForm.getComment());
        this.forumService.updateTopic(msg);
        if (StringUtils.equals((String)updateMode, (String)"listAllMarks")) {
            List<MessageDTO> topicList = this.forumService.getAllTopicsFromSession(sessionId);
            Map topicsByUser = this.getTopicsSortedByAuthor(topicList);
            request.setAttribute("report", (Object)topicsByUser);
            return mapping.findForward("success");
        }
        if (StringUtils.equals((String)updateMode, (String)"listMarks")) {
            List messageList = this.forumService.getMessagesByUserUid(user.getUid(), sessionId);
            TreeMap<ForumUser, List> topicMap = new TreeMap<ForumUser, List>(new ForumUserComparator());
            topicMap.put(user, messageList);
            request.setAttribute("report", topicMap);
            return mapping.findForward("success");
        }
        return mapping.findForward("viewTopic");
    }

    private IForumService getForumService() {
        if (this.forumService == null) {
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            this.forumService = (IForumService)wac.getBean("forumService");
        }
        return this.forumService;
    }

    private Map getTopicsSortedByAuthor(List topicList) {
        TreeMap<ForumUser, ArrayList<MessageDTO>> topicsByUser = new TreeMap<ForumUser, ArrayList<MessageDTO>>(new ForumUserComparator());
        Iterator iter = topicList.iterator();
        this.forumService = this.getForumService();
        while (iter.hasNext()) {
            MessageDTO dto = (MessageDTO)iter.next();
            if (dto.getMessage().getIsAuthored()) continue;
            dto.getMessage().getReport();
            ForumUser user = (ForumUser)dto.getMessage().getCreatedBy().clone();
            ArrayList<MessageDTO> list = (ArrayList<MessageDTO>)topicsByUser.get(user);
            if (list == null) {
                list = new ArrayList<MessageDTO>();
                topicsByUser.put(user, list);
            }
            list.add(dto);
        }
        return topicsByUser;
    }

    private MessageService getMessageService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (MessageService)wac.getBean("forumMessageService");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserDTOComparator
    implements Comparator<UserDTO> {
        private UserDTOComparator() {
        }

        @Override
        public int compare(UserDTO o1, UserDTO o2) {
            if (o1 != null && o2 != null) {
                return o1.getLoginName().compareTo(o2.getLoginName());
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ForumUserComparator
    implements Comparator<ForumUser> {
        private ForumUserComparator() {
        }

        @Override
        public int compare(ForumUser o1, ForumUser o2) {
            if (o1 != null && o2 != null) {
                return o1.getLoginName().compareTo(o2.getLoginName());
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SessionDTOComparator
    implements Comparator<SessionDTO> {
        private SessionDTOComparator() {
        }

        @Override
        public int compare(SessionDTO o1, SessionDTO o2) {
            if (o1 != null && o2 != null) {
                return o1.getSessionName().compareTo(o2.getSessionName());
            }
            if (o1 != null) {
                return 1;
            }
            return -1;
        }
    }
}

