/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.web.forms;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.forum.persistence.Attachment;
import org.lamsfoundation.lams.tool.forum.persistence.Forum;

public class ForumForm
extends ActionForm {
    private static final long serialVersionUID = -6054354910960460120L;
    private static Logger logger = Logger.getLogger((String)ForumForm.class.getName());
    private Long toolContentID = new Long(0L);
    private String currentTab;
    private String sessionMapID;
    private String contentFolderID;
    private FormFile offlineFile;
    private FormFile onlineFile;
    private List onlineFileList;
    private List offlineFileList;
    private Forum forum = new Forum();

    public ForumForm() {
        this.forum.setTitle("");
        this.currentTab = "";
    }

    public void setForum(Forum forum) {
        this.forum = forum;
        if (forum != null) {
            this.toolContentID = forum.getContentId();
            this.onlineFileList = new ArrayList();
            this.offlineFileList = new ArrayList();
            Set fileSet = forum.getAttachments();
            if (fileSet != null) {
                for (Attachment file : fileSet) {
                    if (StringUtils.equalsIgnoreCase((String)file.getFileType(), (String)"OFFLINE")) {
                        this.offlineFileList.add(file);
                        continue;
                    }
                    this.onlineFileList.add(file);
                }
            }
        } else {
            logger.error((Object)"Initial ForumForm failed by null value of Forum.");
        }
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.forum.setAllowEdit(false);
        this.forum.setAllowAnonym(false);
        this.forum.setAllowRichEditor(false);
        this.forum.setLimitedInput(false);
        this.forum.setLockWhenFinished(false);
        this.forum.setAllowNewTopic(false);
        this.forum.setAllowUpload(false);
        this.forum.setReflectOnActivity(false);
    }

    public Forum getForum() {
        return this.forum;
    }

    public void setOnlineFile(FormFile onlineFile) {
        this.onlineFile = onlineFile;
    }

    public FormFile getOnlineFile() {
        return this.onlineFile;
    }

    public void setOfflineFile(FormFile offlineFile) {
        this.offlineFile = offlineFile;
    }

    public FormFile getOfflineFile() {
        return this.offlineFile;
    }

    public String getCurrentTab() {
        return this.currentTab;
    }

    public void setCurrentTab(String currentTab) {
        this.currentTab = currentTab;
    }

    public Long getToolContentID() {
        return this.toolContentID;
    }

    public void setToolContentID(Long toolContentID) {
        this.toolContentID = toolContentID;
    }

    public List getOfflineFileList() {
        return this.offlineFileList;
    }

    public void setOfflineFileList(List offlineFileList) {
        this.offlineFileList = offlineFileList;
    }

    public List getOnlineFileList() {
        return this.onlineFileList;
    }

    public void setOnlineFileList(List onlineFileList) {
        this.onlineFileList = onlineFileList;
    }

    public String getSessionMapID() {
        return this.sessionMapID;
    }

    public void setSessionMapID(String sessionMapID) {
        this.sessionMapID = sessionMapID;
    }

    public String getContentFolderID() {
        return this.contentFolderID;
    }

    public void setContentFolderID(String contentFolderID) {
        this.contentFolderID = contentFolderID;
    }
}

