/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.forum.web.forms;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.validator.ValidatorForm;
import org.lamsfoundation.lams.tool.forum.persistence.Attachment;
import org.lamsfoundation.lams.tool.forum.persistence.Message;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.FileValidatorUtil;

public class MessageForm
extends ValidatorForm {
    private static final long serialVersionUID = -9054365604649146734L;
    private static Logger logger = Logger.getLogger((String)MessageForm.class.getName());
    protected Message message = new Message();
    protected String sessionMapID;
    protected Long forumId;
    protected Long parentId;
    protected Long topicId;
    private boolean hasAttachment;
    private String attachmentName;
    private FormFile attachmentFile;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        try {
            ActionMessage error;
            if (StringUtils.isBlank((String)this.message.getSubject())) {
                error = new ActionMessage("error.subject.required");
                errors.add("message.subject", error);
            }
            if (StringUtils.isBlank((String)this.message.getBody())) {
                error = new ActionMessage("error.body.required");
                errors.add("message.body", error);
            }
            boolean largeFile = true;
            if (request.getRequestURI().indexOf("/learning/") != -1) {
                if (this.getAttachmentFile() != null && FileUtil.isExecutableFile((String)this.getAttachmentFile().getFileName())) {
                    ActionMessage error2 = new ActionMessage("error.attachment.executable");
                    errors.add("message.attachment", error2);
                }
                largeFile = false;
            }
            FileValidatorUtil.validateFileSize((FormFile)this.getAttachmentFile(), (boolean)largeFile, (String)"message.attachment", (ActionMessages)errors);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return errors;
    }

    public void setMessage(Message message) {
        this.message = message;
        if (message != null) {
            if (message.getAttachments() != null && message.getAttachments().size() > 0) {
                this.hasAttachment = true;
                this.attachmentName = ((Attachment)message.getAttachments().iterator().next()).getFileName();
            } else {
                this.hasAttachment = false;
                this.attachmentName = null;
            }
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public void setForumId(Long forumId) {
        this.forumId = forumId;
    }

    public Long getForumId() {
        return this.forumId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setTopicId(Long topicId) {
        this.topicId = topicId;
    }

    public Long getTopicId() {
        return this.topicId;
    }

    public String getAttachmentName() {
        return this.attachmentName;
    }

    public void setAttachmentName(String attachmentName) {
        this.attachmentName = attachmentName;
    }

    public FormFile getAttachmentFile() {
        return this.attachmentFile;
    }

    public void setAttachmentFile(FormFile attachmentFile) {
        this.attachmentFile = attachmentFile;
    }

    public String getSessionMapID() {
        return this.sessionMapID;
    }

    public void setSessionMapID(String sessionMapID) {
        this.sessionMapID = sessionMapID;
    }

    public boolean isHasAttachment() {
        return this.hasAttachment;
    }

    public void setHasAttachment(boolean hasAttachment) {
        this.hasAttachment = hasAttachment;
    }
}

