/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.gmap.dto;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.gmap.dto.GmapAttachmentDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapMarkerDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapSessionDTO;
import org.lamsfoundation.lams.tool.gmap.model.Gmap;
import org.lamsfoundation.lams.tool.gmap.model.GmapAttachment;
import org.lamsfoundation.lams.tool.gmap.model.GmapMarker;
import org.lamsfoundation.lams.tool.gmap.model.GmapSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmapDTO {
    private static Logger logger = Logger.getLogger(GmapDTO.class);
    public Long toolContentId;
    public String title;
    public String instructions;
    public String onlineInstructions;
    public String offlineInstructions;
    public boolean defineLater;
    public boolean contentInUse;
    public boolean lockOnFinish;
    public boolean allowEditMarkers;
    public boolean allowShowAllMarkers;
    public boolean limitMarkers;
    public int maxMarkers;
    public boolean allowZoom;
    public boolean allowTerrain;
    public boolean allowSatellite;
    public boolean allowHybrid;
    public Double mapCenterLatitude;
    public Double mapCenterLongitude;
    public int mapZoom;
    public String mapType;
    public boolean reflectOnActivity;
    public String reflectInstructions;
    String defaultGeocoderAddress;
    public Set<GmapMarkerDTO> gmapMarkers = new HashSet<GmapMarkerDTO>();
    public Set<GmapAttachmentDTO> onlineInstructionsFiles;
    public Set<GmapAttachmentDTO> offlineInstructionsFiles;
    public Set<GmapSessionDTO> sessionDTOs = new TreeSet<GmapSessionDTO>();

    public GmapDTO() {
    }

    public GmapDTO(Gmap gmap) {
        this.toolContentId = gmap.getToolContentId();
        this.title = gmap.getTitle();
        this.instructions = gmap.getInstructions();
        this.onlineInstructions = gmap.getOnlineInstructions();
        this.offlineInstructions = gmap.getOfflineInstructions();
        this.contentInUse = gmap.isContentInUse();
        this.lockOnFinish = gmap.isLockOnFinished();
        this.allowEditMarkers = gmap.isAllowEditMarkers();
        this.allowShowAllMarkers = gmap.isAllowShowAllMarkers();
        this.limitMarkers = gmap.isLimitMarkers();
        this.maxMarkers = gmap.getMaxMarkers();
        this.allowZoom = gmap.isAllowZoom();
        this.allowTerrain = gmap.isAllowTerrain();
        this.allowSatellite = gmap.isAllowSatellite();
        this.allowHybrid = gmap.isAllowHybrid();
        this.mapCenterLatitude = gmap.getMapCenterLatitude();
        this.mapCenterLongitude = gmap.getMapCenterLongitude();
        this.mapZoom = gmap.getMapZoom();
        this.mapType = gmap.getMapType();
        this.reflectOnActivity = gmap.isReflectOnActivity();
        this.reflectInstructions = gmap.getReflectInstructions();
        this.defaultGeocoderAddress = gmap.getDefaultGeocoderAddress();
        this.onlineInstructionsFiles = new TreeSet<GmapAttachmentDTO>();
        this.offlineInstructionsFiles = new TreeSet<GmapAttachmentDTO>();
        for (GmapAttachment att : gmap.getGmapAttachments()) {
            GmapAttachmentDTO attDTO;
            if (att.getFileType().equals("OFFLINE")) {
                attDTO = new GmapAttachmentDTO(att);
                this.offlineInstructionsFiles.add(attDTO);
                continue;
            }
            if (att.getFileType().equals("ONLINE")) {
                attDTO = new GmapAttachmentDTO(att);
                this.onlineInstructionsFiles.add(attDTO);
                continue;
            }
            logger.error((Object)("File with uid " + att.getFileUuid() + " contains invalid fileType: " + att.getFileType()));
        }
        for (GmapSession session : gmap.getGmapSessions()) {
            GmapSessionDTO sessionDTO = new GmapSessionDTO(session);
            this.sessionDTOs.add(sessionDTO);
        }
    }

    public Set<GmapSessionDTO> getSessionDTOs() {
        return this.sessionDTOs;
    }

    public void setSessionDTOs(Set<GmapSessionDTO> sessionDTOs) {
        this.sessionDTOs = sessionDTOs;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public Set<GmapAttachmentDTO> getOfflineInstructionsFiles() {
        return this.offlineInstructionsFiles;
    }

    public void setOfflineInstructionsFiles(Set<GmapAttachmentDTO> offlineInstructionsFiles) {
        this.offlineInstructionsFiles = offlineInstructionsFiles;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public Set<GmapAttachmentDTO> getOnlineInstructionsFiles() {
        return this.onlineInstructionsFiles;
    }

    public void setOnlineInstructionsFiles(Set<GmapAttachmentDTO> onlineInstructionsFiles) {
        this.onlineInstructionsFiles = onlineInstructionsFiles;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentID) {
        this.toolContentId = toolContentID;
    }

    public Boolean getContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(Boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isAllowEditMarkers() {
        return this.allowEditMarkers;
    }

    public void setAllowEditMarkers(boolean allowEditMarkers) {
        this.allowEditMarkers = allowEditMarkers;
    }

    public boolean isAllowShowAllMarkers() {
        return this.allowShowAllMarkers;
    }

    public void setAllowShowAllMarkers(boolean allowShowAllMarkers) {
        this.allowShowAllMarkers = allowShowAllMarkers;
    }

    public boolean isLimitMarkers() {
        return this.limitMarkers;
    }

    public void setLimitMarkers(boolean limitMarkers) {
        this.limitMarkers = limitMarkers;
    }

    public int getMaxMarkers() {
        return this.maxMarkers;
    }

    public void setMaxMarkers(int maxMarkers) {
        this.maxMarkers = maxMarkers;
    }

    public boolean isAllowZoom() {
        return this.allowZoom;
    }

    public void setAllowZoom(boolean allowZoom) {
        this.allowZoom = allowZoom;
    }

    public boolean isAllowTerrain() {
        return this.allowTerrain;
    }

    public void setAllowTerrain(boolean allowTerrain) {
        this.allowTerrain = allowTerrain;
    }

    public boolean isAllowSatellite() {
        return this.allowSatellite;
    }

    public void setAllowSatellite(boolean allowSatellite) {
        this.allowSatellite = allowSatellite;
    }

    public boolean isAllowHybrid() {
        return this.allowHybrid;
    }

    public void setAllowHybrid(boolean allowHybrid) {
        this.allowHybrid = allowHybrid;
    }

    public Double getMapCenterLatitude() {
        return this.mapCenterLatitude;
    }

    public void setMapCenterLatitude(Double mapCenterLatitude) {
        this.mapCenterLatitude = mapCenterLatitude;
    }

    public Double getMapCenterLongitude() {
        return this.mapCenterLongitude;
    }

    public void setMapCenterLongitude(Double mapCenterLongitude) {
        this.mapCenterLongitude = mapCenterLongitude;
    }

    public int getMapZoom() {
        return this.mapZoom;
    }

    public void setMapZoom(int mapZoom) {
        this.mapZoom = mapZoom;
    }

    public String getMapType() {
        return this.mapType;
    }

    public void setMapType(String mapType) {
        this.mapType = mapType;
    }

    public Set<GmapMarkerDTO> getGmapMarkers() {
        return this.gmapMarkers;
    }

    public void setGmapMarkers(List<GmapMarker> gmapMarkers) {
        for (GmapMarker marker : gmapMarkers) {
            GmapMarkerDTO markerDTO = new GmapMarkerDTO(marker);
            this.gmapMarkers.add(markerDTO);
        }
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public boolean isLockOnFinish() {
        return this.lockOnFinish;
    }

    public void setLockOnFinish(boolean lockOnFinish) {
        this.lockOnFinish = lockOnFinish;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public void setGmapMarkers(Set<GmapMarkerDTO> gmapMarkers) {
        this.gmapMarkers = gmapMarkers;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public String getDefaultGeocoderAddress() {
        return this.defaultGeocoderAddress;
    }

    public void setDefaultGeocoderAddress(String defaultGeocoderAddress) {
        this.defaultGeocoderAddress = defaultGeocoderAddress;
    }
}

