/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.gmap.dto;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.lamsfoundation.lams.tool.gmap.dto.GmapMarkerDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapUserDTO;
import org.lamsfoundation.lams.tool.gmap.model.GmapMarker;
import org.lamsfoundation.lams.tool.gmap.model.GmapSession;
import org.lamsfoundation.lams.tool.gmap.model.GmapUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmapSessionDTO
implements Comparable {
    Long sessionID;
    String sessionName;
    Set<GmapUserDTO> userDTOs = new TreeSet<GmapUserDTO>();
    int numberOfLearners;
    int numberOfFinishedLearners;
    Set<GmapMarkerDTO> markerDTOs = new HashSet<GmapMarkerDTO>();

    public GmapSessionDTO(GmapSession session) {
        this.sessionID = session.getSessionId();
        this.sessionName = session.getSessionName();
        this.numberOfFinishedLearners = 0;
        for (GmapUser user : session.getGmapUsers()) {
            GmapUserDTO userDTO = new GmapUserDTO(user);
            this.userDTOs.add(userDTO);
            if (!user.isFinishedActivity()) continue;
            ++this.numberOfFinishedLearners;
        }
        this.numberOfLearners = this.userDTOs.size();
    }

    public GmapSessionDTO() {
    }

    public Long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(Long sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public int compareTo(Object o) {
        GmapSessionDTO toSession = (GmapSessionDTO)o;
        int returnValue = this.sessionName.compareTo(toSession.sessionName);
        if (returnValue == 0) {
            returnValue = this.sessionID.compareTo(toSession.sessionID);
        }
        return returnValue;
    }

    public Set<GmapUserDTO> getUserDTOs() {
        return this.userDTOs;
    }

    public void setUserDTOs(Set<GmapUserDTO> gmapUsers) {
        this.userDTOs = gmapUsers;
    }

    public int getNumberOfLearners() {
        return this.numberOfLearners;
    }

    public void setNumberOfLearners(int numberOfLearners) {
        this.numberOfLearners = numberOfLearners;
    }

    public int getNumberOfFinishedLearners() {
        return this.numberOfFinishedLearners;
    }

    public void setNumberOfFinishedLearners(int numberOfFinishedLearners) {
        this.numberOfFinishedLearners = numberOfFinishedLearners;
    }

    public Set<GmapMarkerDTO> getMarkerDTOs() {
        return this.markerDTOs;
    }

    public void setMarkerDTOs(Set<GmapMarkerDTO> markerDTOs) {
        this.markerDTOs = markerDTOs;
    }

    public void setMarkerDTOs(List<GmapMarker> markers) {
        for (GmapMarker marker : markers) {
            GmapMarkerDTO markerDTO = new GmapMarkerDTO(marker);
            this.markerDTOs.add(markerDTO);
        }
    }
}

