/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.gmap.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.tool.gmap.model.GmapAttachment;
import org.lamsfoundation.lams.tool.gmap.model.GmapMarker;
import org.lamsfoundation.lams.tool.gmap.model.GmapSession;
import org.lamsfoundation.lams.tool.gmap.service.GmapService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gmap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 938457189932877382L;
    static Logger log = Logger.getLogger((String)GmapService.class.getName());
    private Long uid;
    private Date createDate;
    private Date updateDate;
    private Long createBy;
    private String title;
    private String instructions;
    private boolean runOffline;
    private boolean lockOnFinished;
    private boolean allowEditMarkers;
    private boolean allowShowAllMarkers;
    private boolean limitMarkers;
    private int maxMarkers;
    private boolean allowZoom;
    private boolean allowTerrain;
    private boolean allowSatellite;
    private boolean allowHybrid;
    private Double mapCenterLatitude;
    private Double mapCenterLongitude;
    private int mapZoom;
    private String mapType;
    private String onlineInstructions;
    private String offlineInstructions;
    private boolean contentInUse;
    private boolean defineLater;
    private Long toolContentId;
    boolean reflectOnActivity;
    String reflectInstructions;
    String defaultGeocoderAddress;
    private Set<GmapAttachment> gmapAttachments;
    private Set<GmapSession> gmapSessions;
    private Set<GmapMarker> gmapMarkers;
    private IToolContentHandler toolContentHandler;

    public Gmap() {
    }

    public Gmap(Date createDate, Date updateDate, Long createBy, String title, String instructions, boolean runOffline, boolean lockOnFinished, boolean filteringEnabled, String filterKeywords, String onlineInstructions, String offlineInstructions, boolean contentInUse, boolean defineLater, Long toolContentId, boolean reflectOnActivity, String reflectInstructions, String defaultGeocoderAddress, Set<GmapAttachment> gmapAttachments, Set<GmapSession> gmapSessions, Set<GmapMarker> markers) {
        this.createDate = createDate;
        this.updateDate = updateDate;
        this.createBy = createBy;
        this.title = title;
        this.instructions = instructions;
        this.runOffline = runOffline;
        this.lockOnFinished = lockOnFinished;
        this.onlineInstructions = onlineInstructions;
        this.offlineInstructions = offlineInstructions;
        this.contentInUse = contentInUse;
        this.defineLater = defineLater;
        this.toolContentId = toolContentId;
        this.gmapAttachments = gmapAttachments;
        this.gmapSessions = gmapSessions;
        this.gmapMarkers = markers;
        this.reflectOnActivity = reflectOnActivity;
        this.reflectInstructions = reflectInstructions;
        this.defaultGeocoderAddress = defaultGeocoderAddress;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Long getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public boolean isRunOffline() {
        return this.runOffline;
    }

    public void setRunOffline(boolean runOffline) {
        this.runOffline = runOffline;
    }

    public boolean isLockOnFinished() {
        return this.lockOnFinished;
    }

    public void setLockOnFinished(boolean lockOnFinished) {
        this.lockOnFinished = lockOnFinished;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public boolean isContentInUse() {
        return this.contentInUse;
    }

    public void setContentInUse(boolean contentInUse) {
        this.contentInUse = contentInUse;
    }

    public boolean isDefineLater() {
        return this.defineLater;
    }

    public void setDefineLater(boolean defineLater) {
        this.defineLater = defineLater;
    }

    public Long getToolContentId() {
        return this.toolContentId;
    }

    public void setToolContentId(Long toolContentId) {
        this.toolContentId = toolContentId;
    }

    public Set<GmapAttachment> getGmapAttachments() {
        return this.gmapAttachments;
    }

    public void setGmapAttachments(Set<GmapAttachment> gmapAttachments) {
        this.gmapAttachments = gmapAttachments;
    }

    public Set<GmapSession> getGmapSessions() {
        return this.gmapSessions;
    }

    public void setGmapSessions(Set<GmapSession> gmapSessions) {
        this.gmapSessions = gmapSessions;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName()).append("@").append(Integer.toHexString(this.hashCode())).append(" [");
        buffer.append("title").append("='").append(this.getTitle()).append("' ");
        buffer.append("instructions").append("='").append(this.getInstructions()).append("' ");
        buffer.append("toolContentId").append("='").append(this.getToolContentId()).append("' ");
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Gmap)) {
            return false;
        }
        Gmap castOther = (Gmap)other;
        return this.getUid() == castOther.getUid() || this.getUid() != null && castOther.getUid() != null && this.getUid().equals(castOther.getUid());
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getUid() == null ? 0 : this.getUid().hashCode());
        return result;
    }

    public static Gmap newInstance(Gmap fromContent, Long toContentId, IToolContentHandler gmapToolContentHandler) {
        Gmap toContent = new Gmap();
        fromContent.toolContentHandler = gmapToolContentHandler;
        toContent = (Gmap)fromContent.clone();
        toContent.setToolContentId(toContentId);
        toContent.setCreateDate(new Date());
        return toContent;
    }

    protected Object clone() {
        Gmap gmap = null;
        try {
            gmap = (Gmap)super.clone();
            gmap.setUid(null);
            HashSet<GmapAttachment> attachmentSet = new HashSet<GmapAttachment>();
            HashSet<GmapMarker> markerSet = new HashSet<GmapMarker>();
            if (this.gmapAttachments != null) {
                for (GmapAttachment originalFile : this.gmapAttachments) {
                    GmapAttachment newFile = (GmapAttachment)originalFile.clone();
                    attachmentSet.add(newFile);
                }
            }
            gmap.gmapAttachments = attachmentSet;
            if (this.gmapMarkers != null) {
                for (GmapMarker originalMarker : this.gmapMarkers) {
                    GmapMarker newMarker = (GmapMarker)originalMarker.clone();
                    markerSet.add(newMarker);
                }
            }
            gmap.gmapMarkers = markerSet;
            gmap.gmapSessions = new HashSet<GmapSession>();
        }
        catch (CloneNotSupportedException cnse) {
            log.error((Object)("Error cloning " + Gmap.class));
        }
        return gmap;
    }

    public IToolContentHandler getToolContentHandler() {
        return this.toolContentHandler;
    }

    public void setToolContentHandler(IToolContentHandler toolContentHandler) {
        this.toolContentHandler = toolContentHandler;
    }

    public Set<GmapMarker> getGmapMarkers() {
        return this.gmapMarkers;
    }

    public void setGmapMarkers(Set<GmapMarker> gmapMarkers) {
        this.gmapMarkers = gmapMarkers;
    }

    public void addMarker(GmapMarker marker) {
        this.gmapMarkers.add(marker);
    }

    public GmapMarker getMarkerByUid(Long uid) {
        Iterator<GmapMarker> it = this.gmapMarkers.iterator();
        GmapMarker ret = null;
        while (it.hasNext()) {
            GmapMarker marker = it.next();
            if (!marker.getUid().equals(uid)) continue;
            ret = marker;
            break;
        }
        return ret;
    }

    public void removeMarker(Long uid) {
        for (GmapMarker marker : this.gmapMarkers) {
            if (!marker.getUid().equals(uid)) continue;
            this.gmapMarkers.remove(marker);
            break;
        }
    }

    public boolean isAllowEditMarkers() {
        return this.allowEditMarkers;
    }

    public void setAllowEditMarkers(boolean allowEditMarkers) {
        this.allowEditMarkers = allowEditMarkers;
    }

    public boolean isAllowShowAllMarkers() {
        return this.allowShowAllMarkers;
    }

    public void setAllowShowAllMarkers(boolean allowShowAllMarkers) {
        this.allowShowAllMarkers = allowShowAllMarkers;
    }

    public boolean isLimitMarkers() {
        return this.limitMarkers;
    }

    public void setLimitMarkers(boolean limitMarkers) {
        this.limitMarkers = limitMarkers;
    }

    public int getMaxMarkers() {
        return this.maxMarkers;
    }

    public void setMaxMarkers(int maxMarkers) {
        this.maxMarkers = maxMarkers;
    }

    public boolean isAllowZoom() {
        return this.allowZoom;
    }

    public void setAllowZoom(boolean allowZoom) {
        this.allowZoom = allowZoom;
    }

    public boolean isAllowTerrain() {
        return this.allowTerrain;
    }

    public void setAllowTerrain(boolean allowTerrain) {
        this.allowTerrain = allowTerrain;
    }

    public boolean isAllowSatellite() {
        return this.allowSatellite;
    }

    public void setAllowSatellite(boolean allowSatellite) {
        this.allowSatellite = allowSatellite;
    }

    public boolean isAllowHybrid() {
        return this.allowHybrid;
    }

    public void setAllowHybrid(boolean allowHybrid) {
        this.allowHybrid = allowHybrid;
    }

    public Double getMapCenterLatitude() {
        return this.mapCenterLatitude;
    }

    public void setMapCenterLatitude(Double mapCenterLatitude) {
        this.mapCenterLatitude = mapCenterLatitude;
    }

    public Double getMapCenterLongitude() {
        return this.mapCenterLongitude;
    }

    public void setMapCenterLongitude(Double mapCenterLongitude) {
        this.mapCenterLongitude = mapCenterLongitude;
    }

    public int getMapZoom() {
        return this.mapZoom;
    }

    public void setMapZoom(int mapZoom) {
        this.mapZoom = mapZoom;
    }

    public String getMapType() {
        return this.mapType;
    }

    public void setMapType(String mapType) {
        this.mapType = mapType;
    }

    public boolean isReflectOnActivity() {
        return this.reflectOnActivity;
    }

    public void setReflectOnActivity(boolean reflectOnActivity) {
        this.reflectOnActivity = reflectOnActivity;
    }

    public String getReflectInstructions() {
        return this.reflectInstructions;
    }

    public void setReflectInstructions(String reflectInstructions) {
        this.reflectInstructions = reflectInstructions;
    }

    public String getDefaultGeocoderAddress() {
        return this.defaultGeocoderAddress;
    }

    public void setDefaultGeocoderAddress(String defaultGeocoderAddress) {
        this.defaultGeocoderAddress = defaultGeocoderAddress;
    }
}

