/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.gmap.service;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.contentrepository.AccessDeniedException;
import org.lamsfoundation.lams.contentrepository.ICredentials;
import org.lamsfoundation.lams.contentrepository.ITicket;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.LoginException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.contentrepository.WorkspaceNotFoundException;
import org.lamsfoundation.lams.contentrepository.client.IToolContentHandler;
import org.lamsfoundation.lams.contentrepository.service.IRepositoryService;
import org.lamsfoundation.lams.contentrepository.service.RepositoryProxy;
import org.lamsfoundation.lams.contentrepository.service.SimpleCredentials;
import org.lamsfoundation.lams.learning.service.ILearnerService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.learningdesign.service.ImportToolContentException;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.tool.ToolContentImport102Manager;
import org.lamsfoundation.lams.tool.ToolContentManager;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSessionExportOutputData;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.SessionDataExistsException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.gmap.dao.IGmapAttachmentDAO;
import org.lamsfoundation.lams.tool.gmap.dao.IGmapConfigItemDAO;
import org.lamsfoundation.lams.tool.gmap.dao.IGmapDAO;
import org.lamsfoundation.lams.tool.gmap.dao.IGmapMarkerDAO;
import org.lamsfoundation.lams.tool.gmap.dao.IGmapSessionDAO;
import org.lamsfoundation.lams.tool.gmap.dao.IGmapUserDAO;
import org.lamsfoundation.lams.tool.gmap.model.Gmap;
import org.lamsfoundation.lams.tool.gmap.model.GmapAttachment;
import org.lamsfoundation.lams.tool.gmap.model.GmapConfigItem;
import org.lamsfoundation.lams.tool.gmap.model.GmapMarker;
import org.lamsfoundation.lams.tool.gmap.model.GmapSession;
import org.lamsfoundation.lams.tool.gmap.model.GmapUser;
import org.lamsfoundation.lams.tool.gmap.service.IGmapService;
import org.lamsfoundation.lams.tool.gmap.util.GmapException;
import org.lamsfoundation.lams.tool.gmap.util.GmapToolContentHandler;
import org.lamsfoundation.lams.tool.service.ILamsToolService;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.util.audit.IAuditService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GmapService
implements ToolSessionManager,
ToolContentManager,
IGmapService,
ToolContentImport102Manager {
    static Logger logger = Logger.getLogger((String)GmapService.class.getName());
    private IGmapDAO gmapDAO = null;
    private IGmapMarkerDAO gmapMarkerDAO = null;
    private IGmapSessionDAO gmapSessionDAO = null;
    private IGmapUserDAO gmapUserDAO = null;
    private IGmapAttachmentDAO gmapAttachmentDAO = null;
    private ILearnerService learnerService;
    private ILamsToolService toolService;
    private IToolContentHandler gmapToolContentHandler = null;
    private IRepositoryService repositoryService = null;
    private IAuditService auditService = null;
    private IExportToolContentService exportContentService;
    private ICoreNotebookService coreNotebookService;
    private IGmapConfigItemDAO gmapConfigItemDAO;

    public void createToolSession(Long toolSessionId, String toolSessionName, Long toolContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method createToolSession: toolSessionId = " + toolSessionId + " toolSessionName = " + toolSessionName + " toolContentId = " + toolContentId));
        }
        GmapSession session = new GmapSession();
        session.setSessionId(toolSessionId);
        session.setSessionName(toolSessionName);
        Gmap gmap = this.gmapDAO.getByContentId(toolContentId);
        session.setGmap(gmap);
        this.gmapSessionDAO.saveOrUpdate(session);
        Set<GmapMarker> markers = gmap.getGmapMarkers();
        if (markers != null && markers.size() > 0) {
            for (GmapMarker marker : markers) {
                if (!marker.isAuthored() || marker.getGmapSession() != null) continue;
                GmapMarker newMarker = (GmapMarker)marker.clone();
                newMarker.setGmapSession(session);
                this.saveOrUpdateGmapMarker(newMarker);
            }
        }
    }

    public String leaveToolSession(Long toolSessionId, Long learnerId) throws DataMissingException, ToolException {
        return this.learnerService.completeToolSession(toolSessionId, learnerId);
    }

    public ToolSessionExportOutputData exportToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        return null;
    }

    public ToolSessionExportOutputData exportToolSession(List toolSessionIds) throws DataMissingException, ToolException {
        return null;
    }

    public void removeToolSession(Long toolSessionId) throws DataMissingException, ToolException {
        this.gmapSessionDAO.deleteBySessionID(toolSessionId);
    }

    public SortedMap<String, ToolOutput> getToolOutput(List<String> names, Long toolSessionId, Long learnerId) {
        return new TreeMap<String, ToolOutput>();
    }

    public ToolOutput getToolOutput(String name, Long toolSessionId, Long learnerId) {
        return null;
    }

    public void copyToolContent(Long fromContentId, Long toContentId) throws ToolException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("entering method copyToolContent: fromContentId=" + fromContentId + " toContentId=" + toContentId));
        }
        if (toContentId == null) {
            String error = "Failed to copy tool content: toContentID is null";
            throw new ToolException(error);
        }
        Gmap fromContent = null;
        if (fromContentId != null) {
            fromContent = this.gmapDAO.getByContentId(fromContentId);
        }
        if (fromContent == null) {
            fromContent = this.getDefaultContent();
        }
        Gmap toContent = Gmap.newInstance(fromContent, toContentId, this.gmapToolContentHandler);
        this.gmapDAO.saveOrUpdate(toContent);
    }

    public void setAsDefineLater(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Gmap gmap = this.gmapDAO.getByContentId(toolContentId);
        if (gmap == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        gmap.setDefineLater(value);
        this.gmapDAO.saveOrUpdate(gmap);
    }

    public void setAsRunOffline(Long toolContentId, boolean value) throws DataMissingException, ToolException {
        Gmap gmap = this.gmapDAO.getByContentId(toolContentId);
        if (gmap == null) {
            throw new ToolException("Could not find tool with toolContentID: " + toolContentId);
        }
        gmap.setRunOffline(value);
        this.gmapDAO.saveOrUpdate(gmap);
    }

    public void removeToolContent(Long toolContentId, boolean removeSessionData) throws SessionDataExistsException, ToolException {
    }

    public void exportToolContent(Long toolContentId, String rootPath) throws DataMissingException, ToolException {
        Gmap gmap = this.gmapDAO.getByContentId(toolContentId);
        if (gmap == null) {
            gmap = this.getDefaultContent();
        }
        if (gmap == null) {
            throw new DataMissingException("Unable to find default content for the gmap tool");
        }
        gmap = Gmap.newInstance(gmap, toolContentId, null);
        gmap.setToolContentHandler(null);
        gmap.setGmapSessions(null);
        gmap.setCreateBy(null);
        gmap.setToolContentHandler(null);
        Set<GmapAttachment> atts = gmap.getGmapAttachments();
        for (GmapAttachment att : atts) {
            att.setGmap(null);
        }
        Set<GmapMarker> markers = gmap.getGmapMarkers();
        HashSet<GmapMarker> authorItems = new HashSet<GmapMarker>();
        for (GmapMarker gmapMarker : markers) {
            if (!gmapMarker.isAuthored()) continue;
            gmapMarker.setCreatedBy(null);
            gmapMarker.setGmap(null);
            gmapMarker.setUpdatedBy(null);
            authorItems.add(gmapMarker);
        }
        gmap.setGmapMarkers(authorItems);
        try {
            this.exportContentService.registerFileClassForExport(GmapAttachment.class.getName(), "fileUuid", "fileVersionId");
            this.exportContentService.exportToolContent(toolContentId, (Object)gmap, this.gmapToolContentHandler, rootPath);
        }
        catch (ExportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public void importToolContent(Long toolContentId, Integer newUserUid, String toolContentPath, String fromVersion, String toVersion) throws ToolException {
        try {
            this.exportContentService.registerFileClassForImport(GmapAttachment.class.getName(), "fileUuid", "fileVersionId", "fileName", "fileType", null, null);
            Object toolPOJO = this.exportContentService.importToolContent(toolContentPath, this.gmapToolContentHandler, fromVersion, toVersion);
            if (!(toolPOJO instanceof Gmap)) {
                throw new ImportToolContentException("Import Gmap tool content failed. Deserialized object is " + toolPOJO);
            }
            Gmap gmap = (Gmap)toolPOJO;
            gmap.setToolContentId(toolContentId);
            HttpSession ss = SessionManager.getSession();
            UserDTO user = (UserDTO)ss.getAttribute("user");
            GmapUser gmapUser = new GmapUser(user, null);
            this.gmapUserDAO.saveOrUpdate(gmapUser);
            gmap.setCreateBy(gmapUser.getUid());
            this.gmapDAO.saveOrUpdate(gmap);
        }
        catch (ImportToolContentException e) {
            throw new ToolException((Throwable)e);
        }
    }

    public SortedMap<String, ToolOutputDefinition> getToolOutputDefinitions(Long toolContentId) throws ToolException {
        return new TreeMap<String, ToolOutputDefinition>();
    }

    @Override
    public Long getDefaultContentIdBySignature(String toolSignature) {
        Long toolContentId = null;
        toolContentId = new Long(this.toolService.getToolDefaultContentIdBySignature(toolSignature));
        if (toolContentId == null) {
            String error = "Could not retrieve default content id for this tool";
            logger.error((Object)error);
            throw new GmapException(error);
        }
        return toolContentId;
    }

    @Override
    public Gmap getDefaultContent() {
        Long defaultContentID = this.getDefaultContentIdBySignature("lagmap10");
        Gmap defaultContent = this.getGmapByContentId(defaultContentID);
        if (defaultContent == null) {
            String error = "Could not retrieve default content record for this tool";
            logger.error((Object)error);
            throw new GmapException(error);
        }
        return defaultContent;
    }

    @Override
    public Gmap copyDefaultContent(Long newContentID) {
        if (newContentID == null) {
            String error = "Cannot copy the Gmap tools default content: + newContentID is null";
            logger.error((Object)error);
            throw new GmapException(error);
        }
        Gmap defaultContent = this.getDefaultContent();
        Gmap newContent = new Gmap();
        newContent = Gmap.newInstance(defaultContent, newContentID, this.gmapToolContentHandler);
        this.gmapDAO.saveOrUpdate(newContent);
        return newContent;
    }

    @Override
    public Gmap getGmapByContentId(Long toolContentID) {
        Gmap gmap = this.gmapDAO.getByContentId(toolContentID);
        if (gmap == null) {
            logger.debug((Object)("Could not find the content with toolContentID:" + toolContentID));
        }
        return gmap;
    }

    @Override
    public GmapSession getSessionBySessionId(Long toolSessionId) {
        GmapSession gmapSession = this.gmapSessionDAO.getBySessionId(toolSessionId);
        if (gmapSession == null) {
            logger.debug((Object)("Could not find the gmap session with toolSessionID:" + toolSessionId));
        }
        return gmapSession;
    }

    @Override
    public GmapUser getUserByUserIdAndSessionId(Long userId, Long toolSessionId) {
        return this.gmapUserDAO.getByUserIdAndSessionId(userId, toolSessionId);
    }

    public GmapUser getUserByLoginNameAndSessionId(String loginName, Long toolSessionId) {
        return this.gmapUserDAO.getByLoginNameAndSessionId(loginName, toolSessionId);
    }

    @Override
    public GmapUser getUserByUID(Long uid) {
        return this.gmapUserDAO.getByUID(uid);
    }

    @Override
    public GmapAttachment uploadFileToContent(Long toolContentId, FormFile file, String type) {
        if (file == null || StringUtils.isEmpty((String)file.getFileName())) {
            throw new GmapException("Could not find upload file: " + file);
        }
        NodeKey nodeKey = this.processFile(file, type);
        GmapAttachment attachment = new GmapAttachment();
        attachment.setFileType(type);
        attachment.setFileUuid(nodeKey.getUuid());
        attachment.setFileVersionId(nodeKey.getVersion());
        attachment.setFileName(file.getFileName());
        return attachment;
    }

    @Override
    public void deleteFromRepository(Long uuid, Long versionID) throws GmapException {
        ITicket ticket = this.getRepositoryLoginTicket();
        try {
            this.repositoryService.deleteVersion(ticket, uuid, versionID);
        }
        catch (Exception e) {
            throw new GmapException("Exception occured while deleting files from the repository " + e.getMessage());
        }
    }

    @Override
    public void deleteInstructionFile(Long contentID, Long uuid, Long versionID, String type) {
        this.gmapDAO.deleteInstructionFile(contentID, uuid, versionID, type);
    }

    @Override
    public void saveOrUpdateGmap(Gmap gmap) {
        this.gmapDAO.saveOrUpdate(gmap);
    }

    @Override
    public void saveOrUpdateGmapMarker(GmapMarker gmapMarker) {
        this.gmapMarkerDAO.saveOrUpdate(gmapMarker);
    }

    @Override
    public List<GmapMarker> getGmapMarkersBySessionId(Long sessionId) {
        return this.gmapMarkerDAO.getByToolSessionId(sessionId);
    }

    @Override
    public void saveOrUpdateGmapSession(GmapSession gmapSession) {
        this.gmapSessionDAO.saveOrUpdate(gmapSession);
    }

    @Override
    public void saveOrUpdateGmapUser(GmapUser gmapUser) {
        this.gmapUserDAO.saveOrUpdate(gmapUser);
    }

    @Override
    public GmapUser createGmapUser(UserDTO user, GmapSession gmapSession) {
        GmapUser gmapUser = new GmapUser(user, gmapSession);
        this.saveOrUpdateGmapUser(gmapUser);
        return gmapUser;
    }

    @Override
    public GmapConfigItem getConfigItem(String key) {
        return this.gmapConfigItemDAO.getConfigItemByKey(key);
    }

    @Override
    public void saveOrUpdateGmapConfigItem(GmapConfigItem item) {
        this.gmapConfigItemDAO.saveOrUpdate(item);
    }

    public IAuditService getAuditService() {
        return this.auditService;
    }

    public void setAuditService(IAuditService auditService) {
        this.auditService = auditService;
    }

    private NodeKey processFile(FormFile file, String type) {
        NodeKey node = null;
        if (file != null && !StringUtils.isEmpty((String)file.getFileName())) {
            String fileName = file.getFileName();
            try {
                node = this.getGmapToolContentHandler().uploadFile(file.getInputStream(), fileName, file.getContentType(), type);
            }
            catch (InvalidParameterException e) {
                throw new GmapException("InvalidParameterException occured while trying to upload File" + e.getMessage());
            }
            catch (FileNotFoundException e) {
                throw new GmapException("FileNotFoundException occured while trying to upload File" + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                throw new GmapException("RepositoryCheckedException occured while trying to upload File" + e.getMessage());
            }
            catch (IOException e) {
                throw new GmapException("IOException occured while trying to upload File" + e.getMessage());
            }
        }
        return node;
    }

    @Override
    public void updateMarkerListFromXML(String markerXML, Gmap gmap, GmapUser guser, boolean isAuthored, GmapSession session) {
        if (markerXML != null && !markerXML.equals("")) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(new InputSource(new StringReader(markerXML)));
                NodeList list = document.getElementsByTagName("marker");
                for (int i = 0; i < list.getLength(); ++i) {
                    NamedNodeMap markerNode = list.item(i).getAttributes();
                    Long uid = Long.parseLong(markerNode.getNamedItem("markerUID").getNodeValue());
                    String markerTitle = markerNode.getNamedItem("title").getNodeValue();
                    String infoMessage = markerNode.getNamedItem("infoMessage").getNodeValue();
                    Double latitude = Double.parseDouble(markerNode.getNamedItem("latitude").getNodeValue());
                    Double longitude = Double.parseDouble(markerNode.getNamedItem("longitude").getNodeValue());
                    String markerState = markerNode.getNamedItem("state").getNodeValue();
                    if (markerState.equals("remove")) {
                        gmap.removeMarker(uid);
                        continue;
                    }
                    GmapMarker marker = null;
                    if (markerState.equals("save")) {
                        marker = new GmapMarker();
                        marker.setCreatedBy(guser);
                        marker.setCreated(new Date());
                        marker.setAuthored(isAuthored);
                    } else if (markerState.equals("update")) {
                        marker = gmap.getMarkerByUid(uid);
                    }
                    marker.setGmapSession(session);
                    marker.setTitle(markerTitle);
                    marker.setInfoWindowMessage(infoMessage);
                    marker.setLatitude(latitude);
                    marker.setLongitude(longitude);
                    marker.setGmap(gmap);
                    marker.setUpdated(new Date());
                    marker.setUpdatedBy(guser);
                    this.saveOrUpdateGmapMarker(marker);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not get marker xml object to update", (Throwable)e);
                throw new GmapException("Could not get marker xml object to update", e);
            }
        } else {
            logger.debug((Object)"MarkerXML string was empty");
        }
    }

    private ITicket getRepositoryLoginTicket() throws GmapException {
        this.repositoryService = RepositoryProxy.getRepositoryService();
        SimpleCredentials credentials = new SimpleCredentials(GmapToolContentHandler.repositoryUser, GmapToolContentHandler.repositoryId);
        try {
            ITicket ticket = this.repositoryService.login((ICredentials)credentials, GmapToolContentHandler.repositoryWorkspaceName);
            return ticket;
        }
        catch (AccessDeniedException ae) {
            throw new GmapException("Access Denied to repository." + ae.getMessage());
        }
        catch (WorkspaceNotFoundException we) {
            throw new GmapException("Workspace not found." + we.getMessage());
        }
        catch (LoginException e) {
            throw new GmapException("Login failed." + e.getMessage());
        }
    }

    public void import102ToolContent(Long toolContentId, UserDTO user, Hashtable importValues) {
        Date now = new Date();
        Gmap gmap = new Gmap();
        gmap.setContentInUse(Boolean.FALSE);
        gmap.setCreateBy(new Long(user.getUserID().longValue()));
        gmap.setCreateDate(now);
        gmap.setDefineLater(Boolean.FALSE);
        gmap.setInstructions(WebUtil.convertNewlines((String)((String)importValues.get("body"))));
        gmap.setLockOnFinished(Boolean.TRUE);
        gmap.setOfflineInstructions(null);
        gmap.setOnlineInstructions(null);
        gmap.setRunOffline(Boolean.FALSE);
        gmap.setTitle((String)importValues.get("title"));
        gmap.setToolContentId(toolContentId);
        gmap.setUpdateDate(now);
        this.gmapDAO.saveOrUpdate(gmap);
    }

    public void setReflectiveData(Long toolContentId, String title, String description) throws ToolException, DataMissingException {
        logger.warn((Object)"Setting the reflective field on a gmap. This doesn't make sense as the gmap is for reflection and we don't reflect on reflection!");
        Gmap gmap = this.getGmapByContentId(toolContentId);
        if (gmap == null) {
            throw new DataMissingException("Unable to set reflective data titled " + title + " on activity toolContentId " + toolContentId + " as the tool content does not exist.");
        }
        gmap.setInstructions(description);
    }

    public IGmapAttachmentDAO getGmapAttachmentDAO() {
        return this.gmapAttachmentDAO;
    }

    public void setGmapAttachmentDAO(IGmapAttachmentDAO attachmentDAO) {
        this.gmapAttachmentDAO = attachmentDAO;
    }

    public IGmapDAO getGmapDAO() {
        return this.gmapDAO;
    }

    public void setGmapDAO(IGmapDAO gmapDAO) {
        this.gmapDAO = gmapDAO;
    }

    public IToolContentHandler getGmapToolContentHandler() {
        return this.gmapToolContentHandler;
    }

    public void setGmapToolContentHandler(IToolContentHandler gmapToolContentHandler) {
        this.gmapToolContentHandler = gmapToolContentHandler;
    }

    public IGmapSessionDAO getGmapSessionDAO() {
        return this.gmapSessionDAO;
    }

    public void setGmapSessionDAO(IGmapSessionDAO sessionDAO) {
        this.gmapSessionDAO = sessionDAO;
    }

    public ILamsToolService getToolService() {
        return this.toolService;
    }

    public void setToolService(ILamsToolService toolService) {
        this.toolService = toolService;
    }

    public IGmapUserDAO getGmapUserDAO() {
        return this.gmapUserDAO;
    }

    public void setGmapUserDAO(IGmapUserDAO userDAO) {
        this.gmapUserDAO = userDAO;
    }

    public ILearnerService getLearnerService() {
        return this.learnerService;
    }

    public void setLearnerService(ILearnerService learnerService) {
        this.learnerService = learnerService;
    }

    public IExportToolContentService getExportContentService() {
        return this.exportContentService;
    }

    public void setExportContentService(IExportToolContentService exportContentService) {
        this.exportContentService = exportContentService;
    }

    public ICoreNotebookService getCoreNotebookService() {
        return this.coreNotebookService;
    }

    public void setCoreNotebookService(ICoreNotebookService coreNotebookService) {
        this.coreNotebookService = coreNotebookService;
    }

    public IGmapMarkerDAO getGmapMarkerDAO() {
        return this.gmapMarkerDAO;
    }

    public void setGmapMarkerDAO(IGmapMarkerDAO gmapMarkerDAO) {
        this.gmapMarkerDAO = gmapMarkerDAO;
    }

    public IGmapConfigItemDAO getGmapConfigItemDAO() {
        return this.gmapConfigItemDAO;
    }

    public void setGmapConfigItemDAO(IGmapConfigItemDAO gmapConfigItemDAO) {
        this.gmapConfigItemDAO = gmapConfigItemDAO;
    }

    @Override
    public Long createNotebookEntry(Long id, Integer idType, String signature, Integer userID, String entry) {
        return this.coreNotebookService.createNotebookEntry(id, idType, signature, userID, "", entry);
    }

    @Override
    public NotebookEntry getEntry(Long sessionId, Integer idType, String signature, Integer userID) {
        List list = this.coreNotebookService.getEntry(sessionId, idType, signature, userID);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (NotebookEntry)list.get(0);
    }

    @Override
    public void updateEntry(NotebookEntry notebookEntry) {
        this.coreNotebookService.updateEntry(notebookEntry);
    }
}

