/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.gmap.web.actions;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.gmap.model.Gmap;
import org.lamsfoundation.lams.tool.gmap.model.GmapAttachment;
import org.lamsfoundation.lams.tool.gmap.model.GmapConfigItem;
import org.lamsfoundation.lams.tool.gmap.model.GmapMarker;
import org.lamsfoundation.lams.tool.gmap.model.GmapUser;
import org.lamsfoundation.lams.tool.gmap.service.GmapServiceProxy;
import org.lamsfoundation.lams.tool.gmap.service.IGmapService;
import org.lamsfoundation.lams.tool.gmap.web.forms.AuthoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringAction
extends LamsDispatchAction {
    private static Logger logger = Logger.getLogger(AuthoringAction.class);
    public IGmapService gmapService;
    private static final String KEY_TOOL_CONTENT_ID = "toolContentID";
    private static final String KEY_CONTENT_FOLDER_ID = "contentFolderID";
    private static final String KEY_MODE = "mode";
    private static final String KEY_ONLINE_FILES = "onlineFiles";
    private static final String KEY_OFFLINE_FILES = "offlineFiles";
    private static final String KEY_UNSAVED_ONLINE_FILES = "unsavedOnlineFiles";
    private static final String KEY_UNSAVED_OFFLINE_FILES = "unsavedOfflineFiles";
    private static final String KEY_DELETED_FILES = "deletedFiles";

    protected ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Gmap gmap;
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)KEY_TOOL_CONTENT_ID));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)KEY_CONTENT_FOLDER_ID);
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)KEY_MODE, (boolean)true);
        if (this.gmapService == null) {
            this.gmapService = GmapServiceProxy.getGmapService(this.getServlet().getServletContext());
        }
        if ((gmap = this.gmapService.getGmapByContentId(toolContentID)) == null) {
            gmap = this.gmapService.copyDefaultContent(toolContentID);
            gmap.setCreateDate(new Date());
            this.gmapService.saveOrUpdateGmap(gmap);
        }
        if (mode != null && mode.isTeacher()) {
            gmap.setDefineLater(true);
            this.gmapService.saveOrUpdateGmap(gmap);
        }
        AuthoringForm authForm = (AuthoringForm)form;
        this.updateAuthForm(authForm, gmap);
        SessionMap<String, Object> map = this.createSessionMap(gmap, this.getAccessMode(request), contentFolderID, toolContentID);
        authForm.setSessionMapID(map.getSessionID());
        authForm.setGmap(gmap);
        request.getSession().setAttribute(map.getSessionID(), map);
        request.setAttribute("sessionMap", map);
        GmapConfigItem gmapKey = this.gmapService.getConfigItem("GmapKey");
        if (gmapKey != null && gmapKey.getConfigValue() != null) {
            request.setAttribute("gmapKey", (Object)gmapKey.getConfigValue());
        }
        return mapping.findForward("success");
    }

    public ActionForward updateContent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Set<GmapMarker> markers;
        AuthoringForm authForm = (AuthoringForm)form;
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        Long toolContentID = (Long)map.get((Object)KEY_TOOL_CONTENT_ID);
        Gmap gmap = this.gmapService.getGmapByContentId(toolContentID);
        ToolAccessMode mode = (ToolAccessMode)map.get((Object)KEY_MODE);
        String contentFolderID = (String)map.get((Object)KEY_CONTENT_FOLDER_ID);
        GmapUser gmapUser = null;
        if (gmap.getCreateBy() == null) {
            HttpSession ss = SessionManager.getSession();
            UserDTO user = (UserDTO)ss.getAttribute("user");
            gmapUser = new GmapUser(user, null);
            this.gmapService.saveOrUpdateGmapUser(gmapUser);
        } else {
            gmapUser = this.gmapService.getUserByUID(gmap.getCreateBy());
        }
        this.updateGmap(gmap, authForm, mode, gmapUser);
        Set<GmapAttachment> attachments = gmap.getGmapAttachments();
        if (attachments == null) {
            attachments = new HashSet<GmapAttachment>();
        }
        if ((markers = gmap.getGmapMarkers()) == null) {
            markers = new HashSet<GmapMarker>();
        }
        for (GmapAttachment att : this.getAttList(KEY_DELETED_FILES, map)) {
            attachments.remove(att);
        }
        attachments.addAll(this.getAttList(KEY_UNSAVED_ONLINE_FILES, map));
        attachments.addAll(this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map));
        gmap.setGmapAttachments(attachments);
        gmap.setUpdateDate(new Date());
        gmap.setDefineLater(false);
        this.gmapService.saveOrUpdateGmap(gmap);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        authForm.setSessionMapID(map.getSessionID());
        request.setAttribute("sessionMap", map);
        GmapConfigItem gmapKey = this.gmapService.getConfigItem("GmapKey");
        if (gmapKey != null && gmapKey.getConfigValue() != null) {
            request.setAttribute("gmapKey", (Object)gmapKey.getConfigValue());
        }
        return mapping.findForward("success");
    }

    public ActionForward uploadOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward uploadOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.uploadFile(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    public ActionForward deleteOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward deleteOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.deleteFile(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    public ActionForward removeUnsavedOnline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.removeUnsaved(mapping, (AuthoringForm)form, "ONLINE", request);
    }

    public ActionForward removeUnsavedOffline(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return this.removeUnsaved(mapping, (AuthoringForm)form, "OFFLINE", request);
    }

    private ActionForward uploadFile(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        List<GmapAttachment> savedFiles;
        List<GmapAttachment> unsavedFiles;
        FormFile file;
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        if (StringUtils.equals((String)"OFFLINE", (String)type)) {
            file = authForm.getOfflineFile();
            unsavedFiles = this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map);
            savedFiles = this.getAttList(KEY_OFFLINE_FILES, map);
        } else {
            file = authForm.getOnlineFile();
            unsavedFiles = this.getAttList(KEY_UNSAVED_ONLINE_FILES, map);
            savedFiles = this.getAttList(KEY_ONLINE_FILES, map);
        }
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)file, (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            request.setAttribute("sessionMap", map);
            this.saveErrors(request, errors);
            return mapping.findForward("success");
        }
        if (file.getFileName().length() != 0) {
            GmapAttachment newAtt = this.gmapService.uploadFileToContent((Long)map.get((Object)KEY_TOOL_CONTENT_ID), file, type);
            Iterator<GmapAttachment> iter = savedFiles.iterator();
            while (iter.hasNext()) {
                GmapAttachment currAtt = iter.next();
                if (!StringUtils.equals((String)currAtt.getFileName(), (String)newAtt.getFileName())) continue;
                this.getAttList(KEY_DELETED_FILES, map).add(currAtt);
                iter.remove();
                break;
            }
            unsavedFiles.add(newAtt);
            request.setAttribute("sessionMap", map);
            request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        }
        return mapping.findForward("success");
    }

    private ActionForward deleteFile(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        List<GmapAttachment> fileList = StringUtils.equals((String)"OFFLINE", (String)type) ? this.getAttList(KEY_OFFLINE_FILES, map) : this.getAttList(KEY_ONLINE_FILES, map);
        Iterator<GmapAttachment> iter = fileList.iterator();
        while (iter.hasNext()) {
            GmapAttachment att = iter.next();
            if (!att.getFileUuid().equals(authForm.getDeleteFileUuid())) continue;
            this.getAttList(KEY_DELETED_FILES, map).add(att);
            iter.remove();
            break;
        }
        request.setAttribute("sessionMap", map);
        request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        return mapping.findForward("success");
    }

    private ActionForward removeUnsaved(ActionMapping mapping, AuthoringForm authForm, String type, HttpServletRequest request) {
        SessionMap<String, Object> map = this.getSessionMap(request, authForm);
        List<GmapAttachment> unsavedFiles = StringUtils.equals((String)"OFFLINE", (String)type) ? this.getAttList(KEY_UNSAVED_OFFLINE_FILES, map) : this.getAttList(KEY_UNSAVED_ONLINE_FILES, map);
        Iterator<GmapAttachment> iter = unsavedFiles.iterator();
        while (iter.hasNext()) {
            GmapAttachment att = iter.next();
            if (!att.getFileUuid().equals(authForm.getDeleteFileUuid())) continue;
            this.gmapService.deleteFromRepository(att.getFileUuid(), att.getFileVersionId());
            iter.remove();
            break;
        }
        request.setAttribute("sessionMap", map);
        request.setAttribute("unsavedChanges", (Object)new Boolean(true));
        return mapping.findForward("success");
    }

    private void updateGmap(Gmap gmap, AuthoringForm authForm, ToolAccessMode mode, GmapUser guser) {
        gmap.setTitle(authForm.getTitle());
        gmap.setInstructions(authForm.getInstructions());
        this.gmapService.updateMarkerListFromXML(authForm.getMarkersXML(), gmap, guser, true, null);
        if (mode.isAuthor()) {
            gmap.setCreateBy(guser.getUid());
            gmap.setOfflineInstructions(authForm.getOnlineInstruction());
            gmap.setOnlineInstructions(authForm.getOfflineInstruction());
            gmap.setLockOnFinished(authForm.isLockOnFinished());
            gmap.setAllowEditMarkers(authForm.isAllowEditMarkers());
            gmap.setAllowShowAllMarkers(authForm.isAllowShowAllMarkers());
            gmap.setMaxMarkers(authForm.getMaxMarkers());
            gmap.setLimitMarkers(authForm.isLimitMarkers());
            gmap.setAllowZoom(authForm.isAllowZoom());
            gmap.setAllowTerrain(authForm.isAllowTerrain());
            gmap.setAllowSatellite(authForm.isAllowSatellite());
            gmap.setAllowHybrid(authForm.isAllowHybrid());
            gmap.setMapType(authForm.getMapType());
            gmap.setMapZoom(authForm.getMapZoom());
            gmap.setMapCenterLatitude(authForm.getMapCenterLatitude());
            gmap.setMapCenterLongitude(authForm.getMapCenterLongitude());
            gmap.setReflectOnActivity(authForm.isReflectOnActivity());
            gmap.setReflectInstructions(authForm.getReflectInstructions());
            gmap.setDefaultGeocoderAddress(authForm.getDefaultGeocoderAddress());
        }
    }

    private void updateAuthForm(AuthoringForm authForm, Gmap gmap) {
        authForm.setTitle(gmap.getTitle());
        authForm.setInstructions(gmap.getInstructions());
        authForm.setOnlineInstruction(gmap.getOnlineInstructions());
        authForm.setOfflineInstruction(gmap.getOfflineInstructions());
        authForm.setLockOnFinished(gmap.isLockOnFinished());
        authForm.setAllowEditMarkers(gmap.isAllowEditMarkers());
        authForm.setAllowShowAllMarkers(gmap.isAllowShowAllMarkers());
        authForm.setMaxMarkers(gmap.getMaxMarkers());
        authForm.setLimitMarkers(gmap.isLimitMarkers());
        authForm.setAllowZoom(gmap.isAllowZoom());
        authForm.setAllowTerrain(gmap.isAllowTerrain());
        authForm.setAllowSatellite(gmap.isAllowSatellite());
        authForm.setAllowHybrid(gmap.isAllowHybrid());
        authForm.setMapType(gmap.getMapType());
        authForm.setMapZoom(gmap.getMapZoom());
        authForm.setMapCenterLatitude(gmap.getMapCenterLatitude());
        authForm.setMapCenterLongitude(gmap.getMapCenterLongitude());
        authForm.setReflectOnActivity(gmap.isReflectOnActivity());
        authForm.setReflectInstructions(gmap.getReflectInstructions());
        authForm.setDefaultGeocoderAddress(gmap.getDefaultGeocoderAddress());
    }

    private SessionMap<String, Object> createSessionMap(Gmap gmap, ToolAccessMode mode, String contentFolderID, Long toolContentID) {
        SessionMap map = new SessionMap();
        map.put((Object)KEY_MODE, (Object)mode);
        map.put((Object)KEY_CONTENT_FOLDER_ID, (Object)contentFolderID);
        map.put((Object)KEY_TOOL_CONTENT_ID, (Object)toolContentID);
        map.put((Object)KEY_ONLINE_FILES, new LinkedList());
        map.put((Object)KEY_OFFLINE_FILES, new LinkedList());
        map.put((Object)KEY_UNSAVED_ONLINE_FILES, new LinkedList());
        map.put((Object)KEY_UNSAVED_OFFLINE_FILES, new LinkedList());
        map.put((Object)KEY_DELETED_FILES, new LinkedList());
        for (GmapAttachment attachment : gmap.getGmapAttachments()) {
            String type = attachment.getFileType();
            if (type.equals("OFFLINE")) {
                this.getAttList(KEY_OFFLINE_FILES, (SessionMap<String, Object>)map).add(attachment);
            }
            if (!type.equals("ONLINE")) continue;
            this.getAttList(KEY_ONLINE_FILES, (SessionMap<String, Object>)map).add(attachment);
        }
        return map;
    }

    private ToolAccessMode getAccessMode(HttpServletRequest request) {
        String modeStr = request.getParameter(KEY_MODE);
        ToolAccessMode mode = StringUtils.equalsIgnoreCase((String)modeStr, (String)ToolAccessMode.TEACHER.toString()) ? ToolAccessMode.TEACHER : ToolAccessMode.AUTHOR;
        return mode;
    }

    private List<GmapAttachment> getAttList(String key, SessionMap<String, Object> map) {
        List list = (List)map.get((Object)key);
        return list;
    }

    private SessionMap<String, Object> getSessionMap(HttpServletRequest request, AuthoringForm authForm) {
        return (SessionMap)request.getSession().getAttribute(authForm.getSessionMapID());
    }
}

