/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.gmap.web.actions;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.gmap.dto.GmapDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapSessionDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapUserDTO;
import org.lamsfoundation.lams.tool.gmap.model.Gmap;
import org.lamsfoundation.lams.tool.gmap.model.GmapConfigItem;
import org.lamsfoundation.lams.tool.gmap.model.GmapSession;
import org.lamsfoundation.lams.tool.gmap.model.GmapUser;
import org.lamsfoundation.lams.tool.gmap.service.GmapServiceProxy;
import org.lamsfoundation.lams.tool.gmap.service.IGmapService;
import org.lamsfoundation.lams.tool.gmap.util.GmapException;
import org.lamsfoundation.lams.tool.gmap.web.forms.LearningForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class LearningAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(LearningAction.class);
    private static final boolean MODE_OPTIONAL = false;
    private IGmapService gmapService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        NotebookEntry notebookEntry;
        GmapUser gmapUser;
        GmapSession gmapSession;
        LearningForm learningForm = (LearningForm)form;
        ToolAccessMode mode = WebUtil.readToolAccessModeParam((HttpServletRequest)request, (String)"mode", (boolean)false);
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        if (this.gmapService == null) {
            this.gmapService = GmapServiceProxy.getGmapService(this.getServlet().getServletContext());
        }
        if ((gmapSession = this.gmapService.getSessionBySessionId(toolSessionID)) == null) {
            throw new GmapException("Cannot retreive session with toolSessionID" + toolSessionID);
        }
        Gmap gmap = gmapSession.getGmap();
        if (gmap.getTitle() == null) {
            throw new GmapException("Cannot retreive gmap with toolSessionID" + toolSessionID);
        }
        if (gmap.isDefineLater()) {
            return mapping.findForward("defineLater");
        }
        request.setAttribute("mode", (Object)mode.toString());
        learningForm.setToolSessionID(toolSessionID);
        GmapDTO gmapDTO = new GmapDTO(gmap);
        request.setAttribute("gmapDTO", (Object)gmapDTO);
        if (!gmap.isContentInUse()) {
            gmap.setContentInUse(new Boolean(true));
            this.gmapService.saveOrUpdateGmap(gmap);
        }
        if (gmap.isRunOffline()) {
            return mapping.findForward("runOffline");
        }
        if (mode.equals((Object)ToolAccessMode.TEACHER)) {
            Long userID = WebUtil.readLongParam((HttpServletRequest)request, (String)"userID", (boolean)false);
            gmapUser = this.gmapService.getUserByUserIdAndSessionId(userID, toolSessionID);
        } else {
            gmapUser = this.getCurrentUser(toolSessionID);
        }
        GmapUserDTO gmapUserDTO = new GmapUserDTO(gmapUser);
        if (gmapUser.isFinishedActivity() && (notebookEntry = this.gmapService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lagmap10", gmapUser.getUserId().intValue())) != null) {
            gmapUserDTO.notebookEntry = notebookEntry.getEntry();
        }
        request.setAttribute("gmapUserDTO", (Object)gmapUserDTO);
        GmapSessionDTO gmapSessionDTO = new GmapSessionDTO(gmapSession);
        gmapSessionDTO.setMarkerDTOs(this.gmapService.getGmapMarkersBySessionId(toolSessionID));
        if (!gmapSessionDTO.getUserDTOs().contains(gmapUserDTO)) {
            gmapSessionDTO.getUserDTOs().add(gmapUserDTO);
        }
        request.setAttribute("gmapSessionDTO", (Object)gmapSessionDTO);
        GmapConfigItem gmapKey = this.gmapService.getConfigItem("GmapKey");
        if (gmapKey != null && gmapKey.getConfigValue() != null) {
            request.setAttribute("gmapKey", (Object)gmapKey.getConfigValue());
        }
        if (mode.equals((Object)ToolAccessMode.TEACHER) || gmap.isLockOnFinished() && gmapUser.isFinishedActivity()) {
            request.setAttribute("contentEditable", (Object)false);
        } else {
            request.setAttribute("contentEditable", (Object)true);
        }
        return mapping.findForward("gmap");
    }

    private GmapUser getCurrentUser(Long toolSessionId) {
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        GmapUser gmapUser = this.gmapService.getUserByUserIdAndSessionId(new Long(user.getUserID().intValue()), toolSessionId);
        if (gmapUser == null) {
            GmapSession gmapSession = this.gmapService.getSessionBySessionId(toolSessionId);
            gmapUser = this.gmapService.createGmapUser(user, gmapSession);
        }
        return gmapUser;
    }

    public ActionForward finishActivity(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        GmapUser gmapUser = this.getCurrentUser(toolSessionID);
        if (gmapUser != null) {
            LearningForm learningForm = (LearningForm)form;
            GmapSession gmapSession = this.gmapService.getSessionBySessionId(toolSessionID);
            if (gmapSession == null) {
                throw new GmapException("Cannot retreive session with toolSessionID" + toolSessionID);
            }
            Gmap gmap = gmapSession.getGmap();
            this.gmapService.updateMarkerListFromXML(learningForm.getMarkersXML(), gmap, gmapUser, false, gmapSession);
            gmapUser.setFinishedActivity(true);
            this.gmapService.saveOrUpdateGmapUser(gmapUser);
        } else {
            log.error((Object)("finishActivity(): couldn't find GmapUser with id: " + gmapUser.getUserId() + "and toolSessionID: " + toolSessionID));
        }
        ToolSessionManager sessionMgrService = GmapServiceProxy.getGmapSessionManager(this.getServlet().getServletContext());
        try {
            String nextActivityUrl = sessionMgrService.leaveToolSession(toolSessionID, gmapUser.getUserId());
            response.sendRedirect(nextActivityUrl);
        }
        catch (DataMissingException e) {
            throw new GmapException(e);
        }
        catch (ToolException e) {
            throw new GmapException(e);
        }
        catch (IOException e) {
            throw new GmapException(e);
        }
        return null;
    }

    public ActionForward saveMarkers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long toolSessionID = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID");
        GmapUser gmapUser = this.getCurrentUser(toolSessionID);
        if (gmapUser != null) {
            LearningForm learningForm = (LearningForm)form;
            GmapSession gmapSession = this.gmapService.getSessionBySessionId(toolSessionID);
            if (gmapSession == null) {
                throw new GmapException("Cannot retreive session with toolSessionID" + toolSessionID);
            }
            Gmap gmap = gmapSession.getGmap();
            this.gmapService.updateMarkerListFromXML(learningForm.getMarkersXML(), gmap, gmapUser, false, gmapSession);
        } else {
            log.error((Object)("saveMarkers(): couldn't find GmapUser with id: " + gmapUser.getUserId() + "and toolSessionID: " + toolSessionID));
        }
        return this.unspecified(mapping, form, request, response);
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        LearningForm lrnForm = (LearningForm)form;
        GmapUser gmapUser = this.getCurrentUser(lrnForm.getToolSessionID());
        GmapDTO gmapDTO = new GmapDTO(gmapUser.getGmapSession().getGmap());
        request.setAttribute("gmapDTO", (Object)gmapDTO);
        NotebookEntry notebookEntry = this.gmapService.getEntry(gmapUser.getGmapSession().getSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lagmap10", gmapUser.getUserId().intValue());
        if (notebookEntry != null) {
            lrnForm.setEntryText(notebookEntry.getEntry());
        }
        return mapping.findForward("notebook");
    }

    public ActionForward submitReflection(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Integer userID;
        LearningForm lrnForm = (LearningForm)form;
        GmapUser gmapUser = this.getCurrentUser(lrnForm.getToolSessionID());
        Long toolSessionID = gmapUser.getGmapSession().getSessionId();
        NotebookEntry entry = this.gmapService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lagmap10", userID = Integer.valueOf(gmapUser.getUserId().intValue()));
        if (entry == null) {
            this.gmapService.createNotebookEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lagmap10", userID, lrnForm.getEntryText());
        } else {
            entry.setEntry(lrnForm.getEntryText());
            entry.setLastModified(new Date());
            this.gmapService.updateEntry(entry);
        }
        return this.finishActivity(mapping, form, request, response);
    }
}

