/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.gmap.web.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.gmap.dto.GmapDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapSessionDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapUserDTO;
import org.lamsfoundation.lams.tool.gmap.model.Gmap;
import org.lamsfoundation.lams.tool.gmap.model.GmapConfigItem;
import org.lamsfoundation.lams.tool.gmap.model.GmapSession;
import org.lamsfoundation.lams.tool.gmap.model.GmapUser;
import org.lamsfoundation.lams.tool.gmap.service.GmapServiceProxy;
import org.lamsfoundation.lams.tool.gmap.service.IGmapService;
import org.lamsfoundation.lams.tool.gmap.util.GmapException;
import org.lamsfoundation.lams.tool.gmap.web.forms.MonitoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class MonitoringAction
extends LamsDispatchAction {
    private static Logger log = Logger.getLogger(MonitoringAction.class);
    public IGmapService gmapService;

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setupService();
        Long toolContentID = new Long(WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID"));
        String contentFolderID = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        Gmap gmap = this.gmapService.getGmapByContentId(toolContentID);
        if (gmap == null) {
            // empty if block
        }
        GmapDTO gmapDT0 = new GmapDTO(gmap);
        for (GmapSessionDTO sessionDTO : gmapDT0.getSessionDTOs()) {
            Long toolSessionID = sessionDTO.getSessionID();
            sessionDTO.setMarkerDTOs(this.gmapService.getGmapMarkersBySessionId(toolSessionID));
            for (GmapUserDTO userDTO : sessionDTO.getUserDTOs()) {
                NotebookEntry notebookEntry = this.gmapService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lagmap10", userDTO.getUserId().intValue());
                if (notebookEntry != null) {
                    userDTO.setFinishedReflection(true);
                } else {
                    userDTO.setFinishedReflection(false);
                }
                sessionDTO.getUserDTOs().add(userDTO);
            }
        }
        GmapConfigItem gmapKey = this.gmapService.getConfigItem("GmapKey");
        if (gmapKey != null && gmapKey.getConfigValue() != null) {
            request.setAttribute("gmapKey", (Object)gmapKey.getConfigValue());
        }
        request.setAttribute("gmapDTO", (Object)gmapDT0);
        request.setAttribute("contentFolderID", (Object)contentFolderID);
        return mapping.findForward("success");
    }

    private void setupService() {
        if (this.gmapService == null) {
            this.gmapService = GmapServiceProxy.getGmapService(this.getServlet().getServletContext());
        }
    }

    public ActionForward saveMarkers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MonitoringForm monitoringForm = (MonitoringForm)form;
        Long toolSessionID = monitoringForm.getToolSessionID();
        GmapUser gmapUser = this.getCurrentUser(toolSessionID);
        if (gmapUser != null) {
            GmapSession gmapSession = this.gmapService.getSessionBySessionId(toolSessionID);
            if (gmapSession == null) {
                throw new GmapException("Cannot retreive session with toolSessionID" + toolSessionID);
            }
            Gmap gmap = gmapSession.getGmap();
            this.gmapService.updateMarkerListFromXML(monitoringForm.getMarkersXML(), gmap, gmapUser, true, gmapSession);
        } else {
            log.error((Object)("saveMarkers(): couldn't find GmapUser with id: " + gmapUser.getUserId() + "and toolSessionID: " + toolSessionID));
        }
        return this.unspecified(mapping, form, request, response);
    }

    private GmapUser getCurrentUser(Long toolSessionId) {
        UserDTO user = (UserDTO)SessionManager.getSession().getAttribute("user");
        GmapUser gmapUser = this.gmapService.getUserByUserIdAndSessionId(new Long(user.getUserID().intValue()), toolSessionId);
        if (gmapUser == null) {
            GmapSession gmapSession = this.gmapService.getSessionBySessionId(toolSessionId);
            gmapUser = this.gmapService.createGmapUser(user, gmapSession);
        }
        return gmapUser;
    }

    public ActionForward openNotebook(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long toolSessionId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolSessionID", (boolean)false);
        Long userID = WebUtil.readLongParam((HttpServletRequest)request, (String)"userID", (boolean)false);
        GmapUser gmapUser = this.gmapService.getUserByUserIdAndSessionId(userID, toolSessionId);
        NotebookEntry notebookEntry = this.gmapService.getEntry(toolSessionId, CoreNotebookConstants.NOTEBOOK_TOOL, "lagmap10", userID.intValue());
        GmapUserDTO gmapUserDTO = new GmapUserDTO(gmapUser);
        gmapUserDTO.setNotebookEntry(notebookEntry.getEntry());
        request.setAttribute("gmapUserDTO", (Object)gmapUserDTO);
        return mapping.findForward("notebook");
    }
}

