/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.gmap.web.servlets;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.learning.export.web.action.CustomToolImageBundler;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.gmap.dto.GmapDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapSessionDTO;
import org.lamsfoundation.lams.tool.gmap.dto.GmapUserDTO;
import org.lamsfoundation.lams.tool.gmap.model.Gmap;
import org.lamsfoundation.lams.tool.gmap.model.GmapConfigItem;
import org.lamsfoundation.lams.tool.gmap.model.GmapSession;
import org.lamsfoundation.lams.tool.gmap.model.GmapUser;
import org.lamsfoundation.lams.tool.gmap.service.GmapServiceProxy;
import org.lamsfoundation.lams.tool.gmap.service.IGmapService;
import org.lamsfoundation.lams.tool.gmap.util.GmapException;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;
import org.lamsfoundation.lams.web.session.SessionManager;

public class ExportServlet
extends AbstractExportPortfolioServlet {
    private static final long serialVersionUID = -2829707715037631881L;
    private static Logger logger = Logger.getLogger(ExportServlet.class);
    static String[] GMAP_IMAGES = new String[]{"blue_Marker.png", "paleblue_Marker.png", "red_Marker.png", "yellow_Marker.png", "tree_closed.gif", "tree_open.gif"};
    private final String FILENAME = "gmap_main.html";
    private IGmapService gmapService;

    protected String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.gmapService == null) {
            this.gmapService = GmapServiceProxy.getGmapService(this.getServletContext());
        }
        try {
            if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.LEARNER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.LEARNER);
                this.doLearnerExport(request, response, directoryName, cookies);
            } else if (StringUtils.equals((String)this.mode, (String)ToolAccessMode.TEACHER.toString())) {
                request.getSession().setAttribute("mode", (Object)ToolAccessMode.TEACHER);
                this.doTeacherExport(request, response, directoryName, cookies);
            }
        }
        catch (GmapException e) {
            logger.error((Object)"Cannot perform export for gmap tool.");
        }
        GmapConfigItem gmapKey = this.gmapService.getConfigItem("GmapKey");
        if (gmapKey != null && gmapKey.getConfigValue() != null) {
            request.getSession().setAttribute("gmapKey", (Object)gmapKey.getConfigValue());
        }
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        try {
            CustomToolImageBundler imageBundler = new CustomToolImageBundler();
            imageBundler.bundle(request, cookies, directoryName, this.getImagesUrlDir(), GMAP_IMAGES);
        }
        catch (Exception e) {
            logger.error((Object)"Could not export gmap images, some images may be missing in export portfolio", (Throwable)e);
        }
        this.writeResponseToFile(basePath + "/pages/export/exportPortfolio.jsp", directoryName, "gmap_main.html", cookies);
        return "gmap_main.html";
    }

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            logger.error((Object)"Tool content Id or and session Id are null. Unable to activity title");
        } else {
            if (this.gmapService == null) {
                this.gmapService = GmapServiceProxy.getGmapService(this.getServletContext());
            }
            Gmap content = null;
            if (this.toolContentID != null) {
                content = this.gmapService.getGmapByContentId(this.toolContentID);
            } else {
                GmapSession session = this.gmapService.getSessionBySessionId(this.toolSessionID);
                if (session != null) {
                    content = session.getGmap();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    private void doLearnerExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) throws GmapException {
        logger.debug((Object)("doExportLearner: toolContentID:" + this.toolSessionID));
        if (this.toolSessionID == null) {
            String error = "Tool Session ID is missing. Unable to continue";
            logger.error((Object)error);
            throw new GmapException(error);
        }
        GmapSession gmapSession = this.gmapService.getSessionBySessionId(this.toolSessionID);
        Gmap gmap = gmapSession.getGmap();
        UserDTO lamsUserDTO = (UserDTO)SessionManager.getSession().getAttribute("user");
        GmapUser gmapUser = this.gmapService.getUserByUserIdAndSessionId(new Long(lamsUserDTO.getUserID().intValue()), this.toolSessionID);
        GmapUserDTO gmapUserDTO = new GmapUserDTO(gmapUser);
        GmapDTO gmapDTO = new GmapDTO(gmap);
        gmapDTO.setGmapMarkers(this.gmapService.getGmapMarkersBySessionId(this.toolSessionID));
        GmapSessionDTO sessionDTO = new GmapSessionDTO(gmapSession);
        if (gmap.isReflectOnActivity()) {
            NotebookEntry entry = this.gmapService.getEntry(this.toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lagmap10", gmapUser.getUserId().intValue());
            if (entry != null) {
                gmapUserDTO.finishedReflection = true;
                gmapUserDTO.notebookEntry = entry.getEntry();
            } else {
                gmapUserDTO.finishedReflection = false;
            }
            sessionDTO.getUserDTOs().add(gmapUserDTO);
        }
        request.getSession().setAttribute("gmapUserDTO", (Object)gmapUserDTO);
        request.getSession().setAttribute("sessionDTO", (Object)sessionDTO);
        gmapDTO.getSessionDTOs().add(sessionDTO);
        request.getSession().setAttribute("gmapDTO", (Object)gmapDTO);
    }

    private void doTeacherExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) throws GmapException {
        logger.debug((Object)("doExportTeacher: toolContentID:" + this.toolContentID));
        if (this.toolContentID == null) {
            String error = "Tool Content ID is missing. Unable to continue";
            logger.error((Object)error);
            throw new GmapException(error);
        }
        Gmap gmap = this.gmapService.getGmapByContentId(this.toolContentID);
        GmapDTO gmapDTO = new GmapDTO(gmap);
        for (GmapSessionDTO gmapSessionDTO : gmapDTO.getSessionDTOs()) {
            gmapSessionDTO.setMarkerDTOs(this.gmapService.getGmapMarkersBySessionId(gmapSessionDTO.getSessionID()));
            if (!gmap.isReflectOnActivity()) continue;
            for (GmapUserDTO gmapUserDTO : gmapSessionDTO.getUserDTOs()) {
                NotebookEntry entry = this.gmapService.getEntry(gmapSessionDTO.getSessionID(), CoreNotebookConstants.NOTEBOOK_TOOL, "lagmap10", gmapUserDTO.getUserId().intValue());
                if (entry != null) {
                    gmapUserDTO.finishedReflection = true;
                    gmapUserDTO.notebookEntry = entry.getEntry();
                } else {
                    gmapUserDTO.finishedReflection = false;
                }
                gmapSessionDTO.getUserDTOs().add(gmapUserDTO);
            }
        }
        request.getSession().setAttribute("gmapDTO", (Object)gmapDTO);
    }

    private String getImagesUrlDir() {
        String gmapUrlPath = Configuration.get((String)ConfigurationKeys.SERVER_URL);
        if (gmapUrlPath == null) {
            logger.error((Object)"Unable to get path to the LAMS Gmap URL from the configuration table. Gmap images export failed");
            return "";
        }
        gmapUrlPath = gmapUrlPath + "/tool/" + "lagmap10" + "/images/";
        return gmapUrlPath;
    }
}

