/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.hibernate.FlushMode;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardAttachment;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.dao.INoticeboardAttachmentDAO;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class NoticeboardAttachmentDAO
extends HibernateDaoSupport
implements INoticeboardAttachmentDAO {
    private static final String FIND_NB_ATTACHMENT_BY_UUID = "from " + NoticeboardAttachment.class.getName() + " as nb where nb.uuid=?";
    private static final String FIND_NB_ATTACHMENT_BY_FILENAME = "from " + NoticeboardAttachment.class.getName() + " as nb where nb.filename=?";
    private static final String GET_ATTACHMENT_FROM_CONTENT = "select nb.attachmentId from " + NoticeboardAttachment.class.getName() + " as nb where nb.nbContent= :nbContent";

    public NoticeboardAttachment retrieveAttachment(Long attachmentId) {
        return (NoticeboardAttachment)this.getHibernateTemplate().get(NoticeboardAttachment.class, (Serializable)attachmentId);
    }

    public NoticeboardAttachment retrieveAttachmentByUuid(Long uuid) {
        List attachments = this.getSession().createQuery(FIND_NB_ATTACHMENT_BY_UUID).setLong(0, uuid.longValue()).list();
        if (attachments != null && attachments.size() > 0) {
            NoticeboardAttachment nb = (NoticeboardAttachment)attachments.get(0);
            return nb;
        }
        return null;
    }

    public NoticeboardAttachment retrieveAttachmentByFilename(String filename) {
        List attachments = this.getSession().createQuery(FIND_NB_ATTACHMENT_BY_FILENAME).setString(0, filename).list();
        if (attachments != null && attachments.size() > 0) {
            NoticeboardAttachment nb = (NoticeboardAttachment)attachments.get(0);
            return nb;
        }
        return null;
    }

    public List getAttachmentIdsFromContent(NoticeboardContent nbContent) {
        return this.getHibernateTemplate().findByNamedParam(GET_ATTACHMENT_FROM_CONTENT, "nbContent", (Object)nbContent);
    }

    public void saveAttachment(NoticeboardAttachment attachment) {
        this.getHibernateTemplate().saveOrUpdate((Object)attachment);
    }

    public void removeAttachment(NoticeboardAttachment attachment) {
        this.removeAttachment(attachment.getUuid());
    }

    public void removeAttachment(Long uuid) {
        List attachments = this.getSession().createQuery(FIND_NB_ATTACHMENT_BY_UUID).setLong(0, uuid.longValue()).list();
        if (attachments != null && attachments.size() > 0) {
            NoticeboardAttachment nb = (NoticeboardAttachment)attachments.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            this.getHibernateTemplate().delete((Object)nb);
            this.getHibernateTemplate().flush();
        }
    }
}

