/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.dao.hibernate;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardSession;
import org.lamsfoundation.lams.tool.noticeboard.dao.INoticeboardContentDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class NoticeboardContentDAO
extends HibernateDaoSupport
implements INoticeboardContentDAO {
    private static final String FIND_NB_CONTENT = "from " + NoticeboardContent.class.getName() + " as nb where nb.nbContentId=?";
    private static final String LOAD_NB_BY_SESSION = "select nb from NoticeboardContent nb left join fetch nb.nbSessions session where session.nbSessionId=:sessionId";

    public NoticeboardContent getNbContentByUID(Long uid) {
        return (NoticeboardContent)this.getHibernateTemplate().get(NoticeboardContent.class, (Serializable)uid);
    }

    public NoticeboardContent findNbContentById(Long nbContentId) {
        String query = "from NoticeboardContent as nb where nb.nbContentId = ?";
        List content = this.getHibernateTemplate().find(query, (Object)nbContentId);
        if (content != null && content.size() == 0) {
            return null;
        }
        return (NoticeboardContent)content.get(0);
    }

    public NoticeboardContent getNbContentBySession(final Long nbSessionId) {
        return (NoticeboardContent)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(NoticeboardContentDAO.LOAD_NB_BY_SESSION).setLong("sessionId", nbSessionId.longValue()).uniqueResult();
            }
        });
    }

    public void saveNbContent(NoticeboardContent nbContent) {
        this.getHibernateTemplate().save((Object)nbContent);
    }

    public void updateNbContent(NoticeboardContent nbContent) {
        this.getHibernateTemplate().update((Object)nbContent);
    }

    public void removeNoticeboard(Long nbContentId) {
        List list;
        if (nbContentId != null && (list = this.getSession().createQuery(FIND_NB_CONTENT).setLong(0, nbContentId.longValue()).list()) != null && list.size() > 0) {
            NoticeboardContent nb = (NoticeboardContent)list.get(0);
            this.getSession().setFlushMode(FlushMode.AUTO);
            this.getHibernateTemplate().delete((Object)nb);
            this.getHibernateTemplate().flush();
        }
    }

    public void removeNoticeboard(NoticeboardContent nbContent) {
        this.removeNoticeboard(nbContent.getNbContentId());
    }

    public void removeNbSessions(NoticeboardContent nbContent) {
        this.getHibernateTemplate().deleteAll((Collection)nbContent.getNbSessions());
    }

    public void addNbSession(Long nbContentId, NoticeboardSession nbSession) {
        NoticeboardContent content = this.findNbContentById(nbContentId);
        nbSession.setNbContent(content);
        content.getNbSessions().add(nbSession);
        this.getHibernateTemplate().saveOrUpdate((Object)nbSession);
        this.getHibernateTemplate().saveOrUpdate((Object)content);
    }
}

