/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.web;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.lamsfoundation.lams.contentrepository.InvalidParameterException;
import org.lamsfoundation.lams.contentrepository.NodeKey;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.tool.noticeboard.NbApplicationException;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardAttachment;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.service.INoticeboardService;
import org.lamsfoundation.lams.tool.noticeboard.service.NoticeboardServiceProxy;
import org.lamsfoundation.lams.tool.noticeboard.util.NbWebUtil;
import org.lamsfoundation.lams.tool.noticeboard.web.NbAuthoringForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileValidatorUtil;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.web.util.SessionMap;

public class NbAuthoringAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)NbAuthoringAction.class.getName());
    public static final String FORM = "NbAuthoringForm";

    public UserDTO getUser(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null) {
            MessageResources resources = this.getResources(request);
            String error = resources.getMessage("error.missingParam", (Object)"User");
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        return user;
    }

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException {
        NbAuthoringForm nbForm = new NbAuthoringForm();
        Long contentId = WebUtil.readLongParam((HttpServletRequest)request, (String)"toolContentID");
        String contentFolderId = WebUtil.readStrParam((HttpServletRequest)request, (String)"contentFolderID");
        nbForm.setToolContentID(contentId.toString());
        nbForm.setDefineLater(request.getParameter("defineLater"));
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        List attachmentList = null;
        if (!this.contentExists(nbService, contentId)) {
            Long defaultToolContentId = nbService.getToolDefaultContentIdBySignature("lanb11");
            NoticeboardContent nb = nbService.retrieveNoticeboard(defaultToolContentId);
            if (nb == null) {
                String error = "There is data missing in the database";
                logger.error((Object)error);
                throw new NbApplicationException(error);
            }
            nbForm.setToolContentID(contentId.toString());
            nbForm.setContentFolderID(contentFolderId);
            nbForm.setTitle(nb.getTitle());
            nbForm.setContent(nb.getContent());
            nbForm.setOnlineInstructions(nb.getOnlineInstructions());
            nbForm.setOfflineInstructions(nb.getOfflineInstructions());
            attachmentList = NbWebUtil.setupAttachmentList(nbService, null);
        } else {
            NoticeboardContent nb = nbService.retrieveNoticeboard(contentId);
            nbForm.populateFormWithNbContentValues(nb);
            nbForm.setContentFolderID(contentFolderId);
            nb.setDefineLater(Boolean.parseBoolean(nbForm.getDefineLater()));
            nbService.saveNoticeboard(nb);
            attachmentList = NbWebUtil.setupAttachmentList(nbService, nb);
        }
        SessionMap map = NbWebUtil.addUploadsToSession(null, request, attachmentList, NbWebUtil.setupDeletedAttachmentList());
        nbForm.setSessionMapID(map.getSessionID());
        request.setAttribute(FORM, (Object)nbForm);
        return mapping.findForward("authoringContent");
    }

    private boolean contentExists(INoticeboardService service, Long id) {
        NoticeboardContent nb = service.retrieveNoticeboard(id);
        return nb != null;
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException {
        NbAuthoringForm nbForm = (NbAuthoringForm)form;
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        String idAsString = nbForm.getToolContentID();
        if (idAsString == null) {
            MessageResources resources = this.getResources(request);
            String error = resources.getMessage("error.missingParam", (Object)"Tool Content Id");
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        Long content_id = NbWebUtil.convertToLong(nbForm.getToolContentID());
        this.checkContentId(content_id);
        NoticeboardContent nbContent = nbService.retrieveNoticeboard(content_id);
        if (nbContent == null) {
            nbContent = new NoticeboardContent();
            nbContent.setNbContentId(content_id);
        }
        nbForm.copyValuesIntoNbContent(nbContent);
        if (nbContent.getDateCreated() == null) {
            nbContent.setDateCreated(nbContent.getDateUpdated());
        }
        UserDTO user = this.getUser(request);
        nbContent.setCreatorUserId(new Long(user.getUserID().longValue()));
        nbContent.setDefineLater(false);
        nbService.saveNoticeboard(nbContent);
        SessionMap sessionMap = this.getSessionMap(request, nbForm);
        List attachmentList = (List)sessionMap.get((Object)"attachmentList");
        List deletedAttachmentList = (List)sessionMap.get((Object)"deletedAttachmentList");
        deletedAttachmentList = this.saveAttachments(nbService, nbContent, attachmentList, deletedAttachmentList, mapping, request);
        sessionMap = NbWebUtil.addUploadsToSession(sessionMap, request, attachmentList, deletedAttachmentList);
        request.setAttribute("LAMS_AUTHORING_SUCCESS_FLAG", (Object)Boolean.TRUE);
        return mapping.findForward("authoringContent");
    }

    private List saveAttachments(INoticeboardService nbService, NoticeboardContent nbContent, List attachmentList, List deletedAttachmentList, ActionMapping mapping, HttpServletRequest request) {
        if (deletedAttachmentList != null) {
            for (NoticeboardAttachment attachment : deletedAttachmentList) {
                try {
                    if (attachment.getAttachmentId() == null) continue;
                    nbService.removeAttachment(nbContent, attachment);
                }
                catch (RepositoryCheckedException e) {
                    logger.error((Object)"Unable to delete file", (Throwable)e);
                    ActionMessages am = new ActionMessages();
                    am.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.contentrepository", (Object)attachment.getFilename()));
                    this.saveErrors(request, am);
                }
            }
            deletedAttachmentList.clear();
        }
        if (attachmentList != null) {
            for (NoticeboardAttachment attachment : attachmentList) {
                if (attachment.getAttachmentId() != null) continue;
                nbService.saveAttachment(nbContent, attachment);
            }
        }
        return deletedAttachmentList;
    }

    public ActionForward upload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws InvalidParameterException, FileNotFoundException, RepositoryCheckedException, IOException, NbApplicationException {
        NbAuthoringForm nbForm = (NbAuthoringForm)form;
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        Long content_id = NbWebUtil.convertToLong(nbForm.getToolContentID());
        this.checkContentId(content_id);
        NoticeboardContent nbContent = nbService.retrieveNoticeboard(content_id);
        ActionMessages errors = new ActionMessages();
        FileValidatorUtil.validateFileSize((FormFile)nbForm.getOnlineFile(), (boolean)true, (ActionMessages)errors);
        FileValidatorUtil.validateFileSize((FormFile)nbForm.getOfflineFile(), (boolean)true, (ActionMessages)errors);
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("authoringContent");
        }
        if (nbForm.getOnlineFile() != null && nbForm.getOnlineFile().getFileName().trim().length() != 0 || nbForm.getOfflineFile() != null && nbForm.getOfflineFile().getFileName().trim().length() != 0) {
            boolean isOnlineFile = nbForm.getOnlineFile() != null && nbForm.getOnlineFile().getFileName().trim().length() != 0;
            FormFile theFile = isOnlineFile ? nbForm.getOnlineFile() : nbForm.getOfflineFile();
            String fileType = isOnlineFile ? "ONLINE" : "OFFLINE";
            SessionMap map = this.getSessionMap(request, nbForm);
            List attachmentList = (List)map.get((Object)"attachmentList");
            List deletedAttachmentList = (List)map.get((Object)"deletedAttachmentList");
            deletedAttachmentList = this.moveToDelete(theFile.getFileName(), isOnlineFile, attachmentList, deletedAttachmentList);
            try {
                NodeKey node = nbService.uploadFile(theFile.getInputStream(), theFile.getFileName(), theFile.getContentType(), fileType);
                NoticeboardAttachment file = new NoticeboardAttachment();
                file.setFilename(theFile.getFileName());
                file.setOnlineFile(isOnlineFile);
                file.setNbContent(nbContent);
                file.setUuid(node.getUuid());
                file.setVersionId(node.getVersion());
                attachmentList.add(file);
                map = NbWebUtil.addUploadsToSession(map, request, attachmentList, deletedAttachmentList);
                nbForm.setOfflineFile(null);
                nbForm.setOnlineFile(null);
            }
            catch (FileNotFoundException e) {
                logger.error((Object)"Unable to uploadfile", (Throwable)e);
                throw new NbApplicationException("Unable to upload file, exception was " + e.getMessage());
            }
            catch (IOException e) {
                logger.error((Object)"Unable to uploadfile", (Throwable)e);
                throw new NbApplicationException("Unable to upload file, exception was " + e.getMessage());
            }
            catch (RepositoryCheckedException e) {
                logger.error((Object)"Unable to uploadfile", (Throwable)e);
                throw new NbApplicationException("Unable to upload file, exception was " + e.getMessage());
            }
        }
        nbForm.setMethod("Instructions");
        return mapping.findForward("authoringContent");
    }

    private List moveToDelete(String filename, boolean isOnline, List attachmentsList, List deletedAttachmentsList) {
        return this.moveToDelete(filename, isOnline, null, attachmentsList, deletedAttachmentsList);
    }

    private List moveToDelete(Long uuid, List attachmentsList, List deletedAttachmentsList) {
        return this.moveToDelete(null, false, uuid, attachmentsList, deletedAttachmentsList);
    }

    private List moveToDelete(String filename, boolean isOnline, Long uuid, List attachmentsList, List deletedAttachmentsList) {
        List deletedList;
        List list = deletedList = deletedAttachmentsList != null ? deletedAttachmentsList : NbWebUtil.setupDeletedAttachmentList();
        if (attachmentsList != null) {
            Iterator iter = attachmentsList.iterator();
            NoticeboardAttachment attachment = null;
            while (iter.hasNext() && attachment == null) {
                NoticeboardAttachment value = (NoticeboardAttachment)iter.next();
                if (uuid != null) {
                    if (!uuid.equals(value.getUuid())) continue;
                    attachment = value;
                    continue;
                }
                if (value.isOnlineFile() != isOnline || !value.getFilename().equals(filename)) continue;
                attachment = value;
            }
            if (attachment != null) {
                deletedList.add(attachment);
                attachmentsList.remove(attachment);
            }
        }
        return deletedList;
    }

    public ActionForward deleteAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws InvalidParameterException, RepositoryCheckedException, NbApplicationException {
        NbAuthoringForm nbForm = (NbAuthoringForm)form;
        Long uuid = nbForm.getDeleteFileUuid();
        if (uuid == null) {
            String error = "Unable to continue. The file uuid is missing.";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        SessionMap map = this.getSessionMap(request, nbForm);
        List attachmentList = (List)map.get((Object)"attachmentList");
        List deletedAttachmentList = (List)map.get((Object)"deletedAttachmentList");
        deletedAttachmentList = this.moveToDelete(uuid, attachmentList, deletedAttachmentList);
        nbForm.setMethod("Instructions");
        return mapping.findForward("authoringContent");
    }

    private void checkContentId(Long contentId) {
        if (contentId == null) {
            String error = "Unable to continue. Tool content id missing.";
            throw new NbApplicationException(error);
        }
    }

    private SessionMap getSessionMap(HttpServletRequest request, NbAuthoringForm nbForm) {
        return (SessionMap)request.getSession().getAttribute(nbForm.getSessionMapID());
    }
}

