/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.noticeboard.NbApplicationException;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardSession;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardUser;
import org.lamsfoundation.lams.tool.noticeboard.dto.ReflectionDTO;
import org.lamsfoundation.lams.tool.noticeboard.service.INoticeboardService;
import org.lamsfoundation.lams.tool.noticeboard.service.NoticeboardServiceProxy;
import org.lamsfoundation.lams.tool.noticeboard.util.NbWebUtil;
import org.lamsfoundation.lams.tool.noticeboard.web.NbExportForm;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;

public class NbExportAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)NbExportForm.class.getName());

    public ActionForward unspecified(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("exportPortfolio");
    }

    public ActionForward learner(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        NbExportForm exportForm = (NbExportForm)form;
        Long toolSessionId = NbWebUtil.convertToLong(request.getParameter("toolSessionID"));
        Long userId = NbWebUtil.convertToLong(request.getParameter("userID"));
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        if (userId == null || toolSessionId == null) {
            String error = "Tool session Id or user Id is null. Unable to continue";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        NoticeboardUser userInThisSession = nbService.retrieveNbUserBySession(userId, toolSessionId);
        if (userInThisSession == null) {
            String error = "The user with user id " + userId + " does not exist in this session or session may not exist.";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        NoticeboardContent content = nbService.retrieveNoticeboardBySessionID(toolSessionId);
        if (content == null) {
            String error = "The content for this activity has not been defined yet.";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        if (content.getReflectOnActivity()) {
            log.debug((Object)content.getReflectOnActivity());
            request.setAttribute("learner", (Object)true);
            NotebookEntry nbEntry = nbService.getEntry(userInThisSession.getNbSession().getNbSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lanb11", userId.intValue());
            log.debug((Object)nbEntry);
            if (nbEntry != null) {
                request.setAttribute("nbEntry", (Object)nbEntry.getEntry());
            }
        }
        exportForm.populateForm(content);
        return mapping.findForward("exportPortfolio");
    }

    public ActionForward teacher(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        NbExportForm exportForm = (NbExportForm)form;
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        Long toolContentId = NbWebUtil.convertToLong(request.getParameter("toolContentID"));
        if (toolContentId == null) {
            String error = "Tool Content Id is missing. Unable to continue";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        NoticeboardContent content = nbService.retrieveNoticeboard(toolContentId);
        if (content == null) {
            String error = "Data is missing from the database. Unable to Continue";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        if (content.getReflectOnActivity()) {
            Set sessions = content.getNbSessions();
            Iterator i = sessions.iterator();
            ArrayList<ReflectionDTO> reflections = new ArrayList<ReflectionDTO>();
            while (i.hasNext()) {
                NoticeboardSession session = (NoticeboardSession)i.next();
                List sessionUsers = nbService.getUsersBySession(session.getNbSessionId());
                for (int j = 0; j < sessionUsers.size(); ++j) {
                    NoticeboardUser nbUser = (NoticeboardUser)sessionUsers.get(j);
                    NotebookEntry nbEntry = nbService.getEntry(nbUser.getNbSession().getNbSessionId(), CoreNotebookConstants.NOTEBOOK_TOOL, "lanb11", nbUser.getUserId().intValue());
                    log.debug((Object)nbEntry);
                    if (nbEntry == null) continue;
                    ReflectionDTO dto = new ReflectionDTO(nbEntry);
                    dto.setFullName(nbUser.getFullname());
                    reflections.add(dto);
                }
            }
            request.setAttribute("reflections", reflections);
        }
        exportForm.populateForm(content);
        return mapping.findForward("exportPortfolio");
    }
}

