/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.web;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardSession;
import org.lamsfoundation.lams.tool.noticeboard.service.INoticeboardService;
import org.lamsfoundation.lams.tool.noticeboard.service.NoticeboardServiceProxy;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.servlet.AbstractExportPortfolioServlet;

public class NbExportServlet
extends AbstractExportPortfolioServlet {
    private final String FILENAME = "nb_main.html";
    private static Logger logger = Logger.getLogger(NbExportServlet.class);

    protected String doOfflineExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        if (this.toolContentID == null && this.toolSessionID == null) {
            String error = "Tool content Id or and session Id are null. Unable to set activity title";
            logger.error((Object)error);
        } else {
            INoticeboardService service = NoticeboardServiceProxy.getNbService(this.getServletContext());
            NoticeboardContent content = null;
            if (this.toolContentID != null) {
                content = service.retrieveNoticeboard(this.toolContentID);
            } else {
                NoticeboardSession session = service.retrieveNoticeboardSession(this.toolSessionID);
                if (session != null) {
                    content = session.getNbContent();
                }
            }
            if (content != null) {
                this.activityTitle = content.getTitle();
            }
        }
        return super.doOfflineExport(request, response, directoryName, cookies);
    }

    public String doExport(HttpServletRequest request, HttpServletResponse response, String directoryName, Cookie[] cookies) {
        String mode = WebUtil.readStrParam((HttpServletRequest)request, (String)"mode");
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath();
        String url = basePath + "/exportPortfolio.do";
        String urlWithParameters = null;
        if (mode.equals(ToolAccessMode.LEARNER.toString())) {
            urlWithParameters = this.appendParametersToLearnerExportURL(request, url);
        } else if (mode.equals(ToolAccessMode.TEACHER.toString())) {
            urlWithParameters = this.appendParametersToTeacherExportURL(request, url);
        }
        this.writeResponseToFile(urlWithParameters, directoryName, "nb_main.html", cookies);
        return "nb_main.html";
    }
}

