/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.noticeboard.web;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.CoreNotebookConstants;
import org.lamsfoundation.lams.tool.ToolAccessMode;
import org.lamsfoundation.lams.tool.ToolSessionManager;
import org.lamsfoundation.lams.tool.exception.DataMissingException;
import org.lamsfoundation.lams.tool.exception.ToolException;
import org.lamsfoundation.lams.tool.noticeboard.NbApplicationException;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardContent;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardSession;
import org.lamsfoundation.lams.tool.noticeboard.NoticeboardUser;
import org.lamsfoundation.lams.tool.noticeboard.service.INoticeboardService;
import org.lamsfoundation.lams.tool.noticeboard.service.NoticeboardServiceProxy;
import org.lamsfoundation.lams.tool.noticeboard.util.NbWebUtil;
import org.lamsfoundation.lams.tool.noticeboard.web.NbLearnerForm;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsDispatchAction;
import org.lamsfoundation.lams.web.session.SessionManager;

public class NbLearnerAction
extends LamsDispatchAction {
    static Logger logger = Logger.getLogger((String)NbLearnerAction.class.getName());

    public Long getUserID(HttpServletRequest request) {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        if (user == null) {
            MessageResources resources = this.getResources(request);
            String error = resources.getMessage("error.missingParam", (Object)"User");
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        return new Long(user.getUserID().longValue());
    }

    public ActionForward finish(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException, ToolException, DataMissingException, ServletException, IOException {
        NbLearnerForm learnerForm = (NbLearnerForm)form;
        Long userID = this.getUserID(request);
        Long toolSessionID = NbWebUtil.convertToLong(learnerForm.getToolSessionID());
        if (toolSessionID == null) {
            String error = "Unable to continue. The parameters tool session id is missing";
            logger.error((Object)error);
            throw new NbApplicationException(error);
        }
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        ToolSessionManager sessionMgrService = NoticeboardServiceProxy.getNbSessionManager(this.getServlet().getServletContext());
        ToolAccessMode mode = WebUtil.getToolAccessMode((String)learnerForm.getMode());
        if (mode == ToolAccessMode.LEARNER || mode == ToolAccessMode.AUTHOR) {
            String nextActivityUrl;
            NoticeboardSession nbSession = nbService.retrieveNoticeboardSession(toolSessionID);
            NoticeboardUser nbUser = nbService.retrieveNbUserBySession(userID, toolSessionID);
            nbUser.setUserStatus("COMPLETED");
            nbService.updateNoticeboardSession(nbSession);
            nbService.updateNoticeboardUser(nbUser);
            NoticeboardContent nbContent = nbService.retrieveNoticeboardBySessionID(toolSessionID);
            if (nbContent.getReflectOnActivity()) {
                NotebookEntry entry = nbService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lanb11", userID.intValue());
                if (entry == null) {
                    nbService.createNotebookEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lanb11", userID.intValue(), learnerForm.getReflectionText());
                } else {
                    entry.setEntry(learnerForm.getReflectionText());
                    entry.setLastModified(new Date());
                    nbService.updateEntry(entry);
                }
            }
            try {
                nextActivityUrl = sessionMgrService.leaveToolSession(toolSessionID, this.getUserID(request));
            }
            catch (DataMissingException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            catch (ToolException e) {
                log.error((Object)e);
                throw new ServletException((Throwable)e);
            }
            response.sendRedirect(nextActivityUrl);
            return null;
        }
        request.setAttribute("readOnlyMode", (Object)"true");
        return mapping.findForward("displayLearnerContent");
    }

    public ActionForward reflect(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws NbApplicationException {
        INoticeboardService nbService = NoticeboardServiceProxy.getNbService(this.getServlet().getServletContext());
        NbLearnerForm learnerForm = (NbLearnerForm)form;
        Long toolSessionID = NbWebUtil.convertToLong(learnerForm.getToolSessionID());
        NoticeboardContent nbContent = nbService.retrieveNoticeboardBySessionID(toolSessionID);
        request.setAttribute("reflectInstructions", (Object)nbContent.getReflectInstructions());
        request.setAttribute("title", (Object)nbContent.getTitle());
        NotebookEntry entry = nbService.getEntry(toolSessionID, CoreNotebookConstants.NOTEBOOK_TOOL, "lanb11", this.getUserID(request).intValue());
        if (entry != null) {
            request.setAttribute("reflectEntry", (Object)entry.getEntry());
        }
        return mapping.findForward("reflectOnActivity");
    }
}

