/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.config.Registration;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.action.LamsAction;
import org.lamsfoundation.lams.web.lamscommunity.LamsCommunityUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ImportToolContentAction
extends LamsAction {
    public static final String EXPORT_TOOLCONTENT_SERVICE_BEAN_NAME = "exportToolContentService";
    public static final String USER_SERVICE_BEAN_NAME = "userManagementService";
    public static final String MESSAGE_SERVICE_BEAN_NAME = "authoringMessageService";
    public static final String PARAM_LEARING_DESIGN_ID = "learningDesignID";
    public static final String PARAM_LEARNING_DESIGN_LOCATION = "ldLocation";
    public static final String PARAM_LEARNING_FILE_NAME = "fileName";
    public static final String ATTR_TOOLS_ERROR_MESSAGE = "toolsErrorMessages";
    public static final String ATTR_LD_ERROR_MESSAGE = "ldErrorMessages";
    public static final String ATTR_LD_ID = "learningDesignID";
    private static final String KEY_MSG_IMPORT_FILE_NOT_FOUND = "msg.import.file.not.found";
    private static final String KEY_MSG_IMPORT_FAILED_UNKNOWN_REASON = "msg.import.failed.unknown.reason";
    private Logger log = Logger.getLogger(ImportToolContentAction.class);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = request.getParameter("method");
        String customCSV = WebUtil.readStrParam((HttpServletRequest)request, (String)"customCSV", (boolean)true);
        if (StringUtils.equals((String)param, (String)"import")) {
            if (customCSV != null) {
                request.setAttribute("customCSV", (Object)customCSV);
            }
            return mapping.findForward("upload");
        }
        if (StringUtils.equals((String)param, (String)"importLC")) {
            Registration reg = Configuration.getRegistration();
            if (reg == null || !reg.isEnableLamsCommunityIntegration()) {
                request.setAttribute("registered", (Object)Boolean.FALSE);
            } else {
                request.setAttribute("registered", (Object)Boolean.TRUE);
            }
            if (customCSV != null) {
                request.setAttribute("customCSV", (Object)customCSV);
            }
            return mapping.findForward("importLC");
        }
        if (StringUtils.equals((String)param, (String)"importLCFinish")) {
            String learningDesignLocation = WebUtil.readStrParam((HttpServletRequest)request, (String)PARAM_LEARNING_DESIGN_LOCATION);
            this.importLDFromURL(request, learningDesignLocation, customCSV);
            return mapping.findForward("successLC");
        }
        this.importLD(request);
        return mapping.findForward("success");
    }

    private void importLD(HttpServletRequest request) {
        List<String> ldErrorMsgs = new ArrayList<String>();
        List toolsErrorMsgs = new ArrayList();
        Long ldId = null;
        try {
            Integer workspaceFolderUid = null;
            HttpSession ss = SessionManager.getSession();
            UserDTO userDto = (UserDTO)ss.getAttribute("user");
            User user = (User)this.getUserService().findById(User.class, (Serializable)userDto.getUserID());
            File designFile = null;
            HashMap<String, String> params = new HashMap<String, String>();
            String filename = null;
            String uploadPath = FileUtil.createTempDirectory((String)"_uploaded_learningdesign");
            DiskFileUpload fu = new DiskFileUpload();
            fu.setSizeThreshold(4096);
            List fileItems = fu.parseRequest(request);
            for (FileItem fi : fileItems) {
                if (!fi.getFieldName().equalsIgnoreCase("UPLOAD_FILE")) {
                    params.put(fi.getFieldName(), fi.getString());
                } else {
                    filename = FileUtil.getFileName((String)fi.getName());
                    designFile = new File(uploadPath + filename);
                    fi.write(designFile);
                }
                workspaceFolderUid = NumberUtils.createInteger((String)((String)params.get("WORKSPACE_FOLDER_UID")));
            }
            String customCSV = (String)params.get("customCSV");
            if (designFile == null) {
                MessageService msgService = this.getMessageService();
                this.log.error((Object)("Upload file missing. Filename was " + filename));
                String msg = msgService.getMessage(KEY_MSG_IMPORT_FILE_NOT_FOUND);
                ldErrorMsgs.add(msg != null ? msg : "Upload file missing");
            } else {
                IExportToolContentService service = this.getExportService();
                Object[] ldResults = service.importLearningDesign(designFile, user, workspaceFolderUid, toolsErrorMsgs, customCSV);
                ldId = (Long)ldResults[0];
                ldErrorMsgs = (List)ldResults[1];
                toolsErrorMsgs = (List)ldResults[2];
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occured during import", (Throwable)e);
            ldErrorMsgs.add(e.getClass().getName() + " " + e.getMessage());
        }
        request.setAttribute("learningDesignID", ldId);
        if ((ldId == null || ldId == -1L) && ldErrorMsgs.size() == 0) {
            MessageService msgService = this.getMessageService();
            ldErrorMsgs.add(msgService.getMessage(KEY_MSG_IMPORT_FAILED_UNKNOWN_REASON));
        }
        if (ldErrorMsgs.size() > 0) {
            request.setAttribute(ATTR_LD_ERROR_MESSAGE, ldErrorMsgs);
        }
        if (toolsErrorMsgs.size() > 0) {
            request.setAttribute(ATTR_TOOLS_ERROR_MESSAGE, toolsErrorMsgs);
        }
    }

    private void importLDFromURL(HttpServletRequest request, String learningDesignLocation, String customCSV) {
        List<String> ldErrorMsgs = new ArrayList<String>();
        List toolsErrorMsgs = new ArrayList();
        Long ldId = null;
        String fileExt = WebUtil.readStrParam((HttpServletRequest)request, (String)"ext");
        String fileName = FileUtil.generateUniqueContentFolderID() + "." + fileExt;
        try {
            int numRead;
            HttpSession ss = SessionManager.getSession();
            UserDTO userDto = (UserDTO)ss.getAttribute("user");
            User user = (User)this.getUserService().findById(User.class, (Serializable)userDto.getUserID());
            learningDesignLocation = LamsCommunityUtil.appendAuthInfoToURL(learningDesignLocation, user);
            Integer workspaceFolderUid = null;
            File designFile = null;
            String uploadPath = FileUtil.createTempDirectory((String)"_uploaded_learningdesign") + File.separator + FileUtil.getFileName((String)fileName);
            InputStream is = WebUtil.getResponseInputStreamFromExternalServer((String)learningDesignLocation, new HashMap());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(uploadPath));
            byte[] buffer = new byte[1024];
            long numWritten = 0L;
            while ((numRead = is.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, numRead);
                numWritten += (long)numRead;
            }
            this.log.debug((Object)("Path to ld import file: " + uploadPath));
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            is.close();
            designFile = new File(uploadPath);
            if (designFile == null) {
                MessageService msgService = this.getMessageService();
                this.log.error((Object)("Upload file missing. Filename was " + fileName));
                String msg = msgService.getMessage(KEY_MSG_IMPORT_FILE_NOT_FOUND);
                ldErrorMsgs.add(msg != null ? msg : "Upload file missing");
            } else {
                IExportToolContentService service = this.getExportService();
                Object[] ldResults = service.importLearningDesign(designFile, user, workspaceFolderUid, toolsErrorMsgs, customCSV);
                ldId = (Long)ldResults[0];
                ldErrorMsgs = (List)ldResults[1];
                toolsErrorMsgs = (List)ldResults[2];
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Error occured during import", (Throwable)e);
            ldErrorMsgs.add(e.getClass().getName() + " " + e.getMessage());
        }
        request.setAttribute("learningDesignID", ldId);
        if ((ldId == null || ldId == -1L) && ldErrorMsgs.size() == 0) {
            MessageService msgService = this.getMessageService();
            ldErrorMsgs.add(msgService.getMessage(KEY_MSG_IMPORT_FAILED_UNKNOWN_REASON));
        }
        if (ldErrorMsgs.size() > 0) {
            request.setAttribute(ATTR_LD_ERROR_MESSAGE, ldErrorMsgs);
        }
        if (toolsErrorMsgs.size() > 0) {
            request.setAttribute(ATTR_TOOLS_ERROR_MESSAGE, toolsErrorMsgs);
        }
    }

    private IUserManagementService getUserService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IUserManagementService)webContext.getBean(USER_SERVICE_BEAN_NAME);
    }

    private IExportToolContentService getExportService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IExportToolContentService)webContext.getBean(EXPORT_TOOLCONTENT_SERVICE_BEAN_NAME);
    }

    private MessageService getMessageService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (MessageService)webContext.getBean(MESSAGE_SERVICE_BEAN_NAME);
    }
}

