/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.learningdesign.LearningDesign;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InsertLDServlet
extends AbstractStoreWDDXPacketServlet {
    private static Logger log = Logger.getLogger(InsertLDServlet.class);

    private Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getUserID() : null;
    }

    public IAuthoringService getAuthoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IAuthoringService)webContext.getBean("authoringService");
    }

    protected String process(String wddxPacket, HttpServletRequest request) throws Exception {
        String returnPacket = null;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)wddxPacket);
            String customCSV = WDDXProcessor.convertToString((Hashtable)table, (String)"customCSV");
            Long originalLearningDesignID = WDDXProcessor.convertToLong((Hashtable)table, (String)"learningDesignID");
            Long designToImportID = WDDXProcessor.convertToLong((Hashtable)table, (String)"learningDesignIDToImport");
            boolean createNewLearningDesign = WDDXProcessor.convertToBoolean((Hashtable)table, (String)"createNewLearningDesign");
            Integer folderID = WDDXProcessor.convertToInteger((Hashtable)table, (String)"workspaceFolderID");
            String title = WDDXProcessor.convertToString((Hashtable)table, (String)"title");
            LearningDesign updatedLearningDesign = authoringService.insertLearningDesign(originalLearningDesignID, designToImportID, this.getUserId(), createNewLearningDesign, title, folderID, customCSV);
            return new FlashMessage(this.getMessageKey(wddxPacket, request), (Object)updatedLearningDesign.getLearningDesignId()).serializeMessage();
        }
        catch (Exception e) {
            log.error((Object)("Authoring error. input packet was " + wddxPacket), (Throwable)e);
            FlashMessage flashMessage = new FlashMessage(this.getMessageKey(wddxPacket, request), (Object)authoringService.getMessageService().getMessage("invalid.wddx.packet", new Object[]{e.getMessage()}), 1);
            returnPacket = flashMessage.serializeMessage();
            return returnPacket;
        }
    }

    protected String getMessageKey(String designDetails, HttpServletRequest request) {
        return "insertLearningDesign";
    }
}

