/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.authoring.web;

import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.authoring.dto.StoreLearningDesignResultsDTO;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.learningdesign.dto.AuthoringActivityDTO;
import org.lamsfoundation.lams.learningdesign.dto.ValidationErrorDTO;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class StoreLDServlet
extends AbstractStoreWDDXPacketServlet {
    private static final long serialVersionUID = -2298959991408815691L;
    private static Logger log = Logger.getLogger(StoreLDServlet.class);

    private String getUserLanguage() {
        HttpSession ss = SessionManager.getSession();
        UserDTO user = (UserDTO)ss.getAttribute("user");
        return user != null ? user.getLocaleLanguage() : "";
    }

    public IAuthoringService getAuthoringService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (IAuthoringService)webContext.getBean("authoringService");
    }

    protected String process(String designDetails, HttpServletRequest request) throws Exception {
        String returnPacket = null;
        IAuthoringService authoringService = this.getAuthoringService();
        try {
            Long learningDesignID = authoringService.storeLearningDesignDetails(designDetails);
            Vector<AuthoringActivityDTO> activityDTOS = authoringService.getToolActivities(learningDesignID, this.getUserLanguage());
            Vector<ValidationErrorDTO> validationDTOS = authoringService.validateLearningDesign(learningDesignID);
            FlashMessage flashMessage = null;
            flashMessage = validationDTOS != null && validationDTOS.size() > 0 ? new FlashMessage(this.getMessageKey(designDetails, request), (Object)new StoreLearningDesignResultsDTO(Boolean.FALSE, validationDTOS, activityDTOS, learningDesignID), 3) : new FlashMessage(this.getMessageKey(designDetails, request), (Object)new StoreLearningDesignResultsDTO(Boolean.TRUE, activityDTOS, learningDesignID));
            returnPacket = flashMessage.serializeMessage();
        }
        catch (Exception e) {
            log.error((Object)("Authoring error. input packet was " + designDetails), (Throwable)e);
            FlashMessage flashMessage = new FlashMessage(this.getMessageKey(designDetails, request), (Object)authoringService.getMessageService().getMessage("invalid.wddx.packet", new Object[]{e.getMessage()}), 1);
            returnPacket = flashMessage.serializeMessage();
        }
        return returnPacket;
    }

    protected String getMessageKey(String designDetails, HttpServletRequest request) {
        return "storeLearningDesignDetails";
    }
}

