/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.notebook.web;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.notebook.model.NotebookEntry;
import org.lamsfoundation.lams.notebook.service.ICoreNotebookService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.wddx.FlashMessage;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class StoreNBEntryServlet
extends AbstractStoreWDDXPacketServlet {
    private static Logger log = Logger.getLogger(StoreNBEntryServlet.class);
    public static final String STORE_NBENTRY_MESSAGE_KEY = "storeNotebookEntry";

    public ICoreNotebookService getNotebookService() {
        WebApplicationContext webContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        return (ICoreNotebookService)webContext.getBean("coreNotebookService");
    }

    public static Integer getUserId() {
        HttpSession ss = SessionManager.getSession();
        UserDTO learner = (UserDTO)ss.getAttribute("user");
        return learner != null ? learner.getUserID() : null;
    }

    protected String process(String entryDetails, HttpServletRequest request) throws Exception {
        ICoreNotebookService notebookService = this.getNotebookService();
        FlashMessage flashMessage = null;
        Hashtable table = (Hashtable)WDDXProcessor.deserialize((String)entryDetails);
        NotebookEntry notebookEntry = new NotebookEntry();
        try {
            Integer userID;
            if (this.keyExists(table, "externalID")) {
                notebookEntry.setExternalID(WDDXProcessor.convertToLong((Hashtable)table, (String)"externalID"));
            }
            if (this.keyExists(table, "externalIDType")) {
                notebookEntry.setExternalIDType(WDDXProcessor.convertToInteger((Hashtable)table, (String)"externalIDType"));
            }
            if (this.keyExists(table, "externalSignature")) {
                notebookEntry.setExternalSignature(WDDXProcessor.convertToString((Hashtable)table, (String)"externalSignature"));
            }
            if ((userID = StoreNBEntryServlet.getUserId()) != null) {
                User user = (User)notebookService.getUserManagementService().findById(User.class, (Serializable)userID);
                notebookEntry.setUser(user);
            }
            if (this.keyExists(table, "title")) {
                notebookEntry.setTitle(WDDXProcessor.convertToString((Hashtable)table, (String)"title"));
            }
            if (this.keyExists(table, "entry")) {
                notebookEntry.setEntry(WDDXProcessor.convertToString((Hashtable)table, (String)"entry"));
            }
            notebookEntry.setCreateDate(new Date());
            notebookService.saveOrUpdateNotebookEntry(notebookEntry);
        }
        catch (Exception e) {
            flashMessage = new FlashMessage(STORE_NBENTRY_MESSAGE_KEY, (Object)notebookService.getMessageService().getMessage("invalid.wddx.packet", new Object[]{e.getMessage()}), 1);
        }
        flashMessage = new FlashMessage(STORE_NBENTRY_MESSAGE_KEY, (Object)notebookEntry.getUid());
        return flashMessage.serializeMessage();
    }

    protected String getMessageKey(String designDetails, HttpServletRequest request) {
        return STORE_NBENTRY_MESSAGE_KEY;
    }

    private boolean keyExists(Hashtable table, String key) {
        return table.containsKey(key);
    }
}

