/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.CircularByteBuffer;

public class PortraitUtils {
    private static Logger log = Logger.getLogger(PortraitUtils.class);

    public static InputStream resizePicture(InputStream is, int largestDimension) {
        InputStream thumbnailInputStream = null;
        try {
            int originalImageLargestDim;
            int sizeDifference;
            double scale;
            BufferedImage inImage = ImageIO.read(is);
            if (inImage.getWidth(null) > inImage.getHeight(null)) {
                scale = (double)largestDimension / (double)inImage.getWidth(null);
                sizeDifference = inImage.getWidth(null) - largestDimension;
                originalImageLargestDim = inImage.getWidth(null);
            } else {
                scale = (double)largestDimension / (double)inImage.getHeight(null);
                sizeDifference = inImage.getHeight(null) - largestDimension;
                originalImageLargestDim = inImage.getHeight(null);
            }
            BufferedImage outImage = new BufferedImage(100, 100, 1);
            if (scale < 1.0) {
                int numSteps = sizeDifference / 200 != 0 ? sizeDifference / 200 : 1;
                int stepSize = sizeDifference / numSteps;
                int stepWeight = stepSize / 2;
                int heavierStepSize = stepSize + stepWeight;
                int lighterStepSize = stepSize - stepWeight;
                double scaledW = inImage.getWidth(null);
                double scaledH = inImage.getHeight(null);
                int centerStep = numSteps % 2 == 1 ? (int)Math.ceil((double)numSteps / 2.0) : -1;
                Integer intermediateSize = originalImageLargestDim;
                Integer previousIntermediateSize = originalImageLargestDim;
                Integer i = 0;
                while (i < numSteps) {
                    int currentStepSize = i + 1 != centerStep ? (i == numSteps - 1 ? previousIntermediateSize - largestDimension : (numSteps - i > numSteps / 2 ? heavierStepSize : lighterStepSize)) : stepSize;
                    intermediateSize = previousIntermediateSize - currentStepSize;
                    scale = (double)intermediateSize.intValue() / (double)previousIntermediateSize.intValue();
                    scaledW = (double)((int)scaledW) * scale;
                    scaledH = (double)((int)scaledH) * scale;
                    outImage = new BufferedImage((int)scaledW, (int)scaledH, 1);
                    Graphics2D g2d = outImage.createGraphics();
                    g2d.setBackground(Color.WHITE);
                    g2d.clearRect(0, 0, outImage.getWidth(), outImage.getHeight());
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    AffineTransform tx = new AffineTransform();
                    tx.scale(scale, scale);
                    g2d.drawImage(inImage, tx, null);
                    g2d.dispose();
                    inImage = outImage;
                    previousIntermediateSize = intermediateSize;
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            } else {
                outImage = new BufferedImage(inImage.getWidth(null), inImage.getHeight(null), 1);
                Graphics2D g2d = outImage.createGraphics();
                g2d.setBackground(Color.WHITE);
                g2d.clearRect(0, 0, outImage.getWidth(), outImage.getHeight());
                AffineTransform tx = new AffineTransform();
                tx.setToIdentity();
                g2d.drawImage(inImage, tx, null);
                g2d.dispose();
            }
            CircularByteBuffer cbb = new CircularByteBuffer(-1);
            ImageIO.write((RenderedImage)outImage, "JPG", cbb.getOutputStream());
            cbb.getOutputStream().close();
            thumbnailInputStream = cbb.getInputStream();
        }
        catch (IOException e) {
            log.error((Object)e.getStackTrace());
            return null;
        }
        return thumbnailInputStream;
    }
}

