/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class HomeAction
extends DispatchAction {
    private static Logger log = Logger.getLogger(HomeAction.class);
    private static IUserManagementService service;
    private static ILessonService lessonService;

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }

    private ILessonService getLessonService() {
        if (lessonService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            lessonService = (ILessonService)ctx.getBean("lessonService");
        }
        return lessonService;
    }

    private UserDTO getUser() {
        HttpSession ss = SessionManager.getSession();
        return (UserDTO)ss.getAttribute("user");
    }

    private User getRealUser(UserDTO dto) {
        return this.getService().getUserByLogin(dto.getLogin());
    }

    public ActionForward sysadmin(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"request sysadmin");
            int orgId = new Integer(req.getParameter("orgId"));
            UserDTO user = this.getUser();
            if (user == null) {
                log.error((Object)"admin: User missing from session. ");
                return mapping.findForward("error");
            }
            if (this.getService().isUserInRole(user.getUserID(), Integer.valueOf(orgId), "SYSADMIN")) {
                log.debug((Object)"user is sysadmin");
                return mapping.findForward("sysadmin");
            }
            log.error((Object)("User " + user.getLogin() + " tried to get sysadmin screen but isn't sysadmin in organisation: " + orgId));
            return this.displayMessage(mapping, req, "error.authorisation");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load sysadmin", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward learner(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Lesson lesson;
            log.debug((Object)"request learner");
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)req, (String)"lessonID");
            String mode = WebUtil.readStrParam((HttpServletRequest)req, (String)"mode", (boolean)true);
            UserDTO user = this.getUser();
            if (user == null) {
                log.error((Object)"learner: User missing from session. ");
                return mapping.findForward("error");
            }
            Lesson lesson2 = lesson = lessonId != null ? this.getLessonService().getLesson(lessonId) : null;
            if (lesson == null || !lesson.isLessonStarted()) {
                return this.displayMessage(mapping, req, "message.lesson.not.started.cannot.participate");
            }
            if (lesson.getLessonClass() == null || !lesson.getLessonClass().getLearners().contains(this.getRealUser(user))) {
                log.error((Object)("learner: User " + user.getLogin() + " is not a learner in the requested lesson. Cannot access the lesson."));
                return this.displayMessage(mapping, req, "error.authorisation");
            }
            if (mode != null) {
                req.setAttribute("mode", (Object)mode);
            }
            req.setAttribute("portfolioEnabled", (Object)(lesson.getLearnerExportAvailable() != null ? lesson.getLearnerExportAvailable() : Boolean.TRUE));
            req.setAttribute("presenceEnabledPatch", (Object)lesson.getLearnerPresenceAvailable());
            req.setAttribute("presenceImEnabled", (Object)lesson.getLearnerImAvailable());
            req.setAttribute("title", (Object)lesson.getLessonName());
            req.setAttribute("createDateTime", (Object)lesson.getCreateDateTime());
            String serverUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL);
            req.setAttribute("serverUrl", (Object)serverUrl);
            String presenceUrl = Configuration.get((String)ConfigurationKeys.XMPP_DOMAIN);
            req.setAttribute("presenceUrl", (Object)presenceUrl);
            req.setAttribute("lessonID", (Object)lessonId);
            return mapping.findForward("learner");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load learner", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward author(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            log.debug((Object)"request author");
            UserDTO user = this.getUser();
            if (user == null) {
                log.error((Object)"admin: User missing from session. ");
                return mapping.findForward("error");
            }
            Long learningDesignID = null;
            String layout = null;
            String serverUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL);
            req.setAttribute("serverUrl", (Object)serverUrl);
            String requestSrc = req.getParameter("requestSrc");
            String notifyCloseURL = req.getParameter("notifyCloseURL");
            String customCSV = req.getParameter("customCSV");
            String extLmsId = req.getParameter("extlmsid");
            if (req.getParameter("learningDesignID") != null) {
                learningDesignID = WebUtil.readLongParam((HttpServletRequest)req, (String)"learningDesignID");
            }
            if (req.getParameter("layout") != null) {
                layout = WebUtil.readStrParam((HttpServletRequest)req, (String)"layout");
            }
            if (layout != null) {
                req.setAttribute("layout", (Object)layout);
            }
            if (req.getParameter("learningDesignID") != null) {
                learningDesignID = WebUtil.readLongParam((HttpServletRequest)req, (String)"learningDesignID");
            }
            if (learningDesignID != null) {
                req.setAttribute("learningDesignID", (Object)learningDesignID);
            }
            req.setAttribute("requestSrc", (Object)requestSrc);
            req.setAttribute("notifyCloseURL", (Object)notifyCloseURL);
            req.setAttribute("customCSV", (Object)customCSV);
            req.setAttribute("extlmsid", (Object)extLmsId);
            return mapping.findForward("author");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load author", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward monitorLesson(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Lesson lesson;
            log.debug((Object)"request monitorLesson");
            Long lessonId = WebUtil.readLongParam((HttpServletRequest)req, (String)"lessonID");
            UserDTO user = this.getUser();
            if (user == null) {
                log.error((Object)"admin: User missing from session. ");
                return mapping.findForward("error");
            }
            Lesson lesson2 = lesson = lessonId != null ? this.getLessonService().getLesson(lessonId) : null;
            if (lesson == null) {
                log.error((Object)("monitorLesson: Lesson " + lessonId + " does not exist. Unable to monitor lesson"));
                return mapping.findForward("error");
            }
            if (lesson.getLessonClass() == null || !lesson.getLessonClass().isStaffMember(this.getRealUser(user))) {
                log.error((Object)("learner: User " + user.getLogin() + " is not a learner in the requested lesson. Cannot access the lesson."));
                return this.displayMessage(mapping, req, "error.authorisation");
            }
            log.debug((Object)"user is staff");
            String serverUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL);
            req.setAttribute("serverUrl", (Object)serverUrl);
            req.setAttribute("lessonID", (Object)lessonId);
            return mapping.findForward("monitorLesson");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load monitor lesson", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward addLesson(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            Integer orgId;
            log.debug((Object)"request addLesson");
            Integer courseId = WebUtil.readIntParam((HttpServletRequest)req, (String)"courseID", (boolean)false);
            Integer classId = WebUtil.readIntParam((HttpServletRequest)req, (String)"classID", (boolean)true);
            UserDTO user = this.getUser();
            if (user == null) {
                log.error((Object)"admin: User missing from session. ");
                return mapping.findForward("error");
            }
            Integer n = orgId = classId != null ? classId : courseId;
            if (this.getService().isUserInRole(user.getUserID(), orgId, "MONITOR") || this.getService().isUserInRole(user.getUserID(), orgId, "GROUP MANAGER")) {
                log.debug((Object)"user is staff");
                String orgName = ((Organisation)this.getService().findById(Organisation.class, (Serializable)orgId)).getName();
                req.setAttribute("organisationID", (Object)orgId);
                req.setAttribute("orgName", (Object)orgName);
                return mapping.findForward("addLesson");
            }
            log.error((Object)("User " + user.getLogin() + " tried to get staff screen but isn't staff in organisation: " + orgId));
            return this.displayMessage(mapping, req, "error.authorisation");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load add lesson", (Throwable)e);
            return mapping.findForward("error");
        }
    }

    public ActionForward logout(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        UserDTO userDTO = (UserDTO)SessionManager.getSession().getAttribute("user");
        if (userDTO.getLoggedIntoLamsCommunity() != null && userDTO.getLoggedIntoLamsCommunity().booleanValue()) {
            log.debug((Object)"Need to log out user from lamscoomunity");
            req.getSession().invalidate();
            SessionManager.getSession().invalidate();
            String url = "http://lamscommunity.org/register/logout?return_url=";
            url = url + URLEncoder.encode(Configuration.get((String)ConfigurationKeys.SERVER_URL), "UTF8");
            res.sendRedirect(url);
            return null;
        }
        req.getSession().invalidate();
        SessionManager.getSession().invalidate();
        return mapping.findForward("index");
    }

    private ActionForward displayMessage(ActionMapping mapping, HttpServletRequest req, String messageKey) {
        req.setAttribute("messageKey", (Object)messageKey);
        return mapping.findForward("message");
    }
}

