/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.lamsfoundation.lams.authoring.service.IAuthoringService;
import org.lamsfoundation.lams.config.Registration;
import org.lamsfoundation.lams.index.IndexLinkBean;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class IndexAction
extends Action {
    private static final String PATH_PEDAGOGICAL_PLANNER = "pedagogical_planner";
    private static final String PATH_LAMS_CENTRAL = "lams-central.war";
    private static Logger log = Logger.getLogger(IndexAction.class);
    private static IUserManagementService userManagementService;
    private static IExportToolContentService exportService;
    private static IAuthoringService authoringService;
    private static Configuration configurationService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String groups;
        this.setHeaderLinks(request);
        this.setAdminLinks(request);
        User loggedInUser = this.getUserManagementService().getUserByLogin(request.getRemoteUser());
        if (loggedInUser.getChangePassword() != null && loggedInUser.getChangePassword().booleanValue()) {
            return mapping.findForward("password");
        }
        String tab = WebUtil.readStrParam((HttpServletRequest)request, (String)"tab", (boolean)true);
        if (StringUtils.equals((String)tab, (String)"profile")) {
            List collapsedOrgDTOs = this.getUserManagementService().getArchivedCourseIdsByUser(loggedInUser.getUserId(), request.isUserInRole("SYSADMIN"));
            request.setAttribute("collapsedOrgDTOs", (Object)collapsedOrgDTOs);
            return mapping.findForward("profile");
        }
        if (StringUtils.equals((String)tab, (String)"editprofile")) {
            return mapping.findForward("editprofile");
        }
        if (StringUtils.equals((String)tab, (String)"password")) {
            return mapping.findForward("password");
        }
        if (StringUtils.equals((String)tab, (String)"passwordChanged")) {
            request.setAttribute("tab", (Object)"profile");
            return mapping.findForward("passwordChanged");
        }
        if (StringUtils.equals((String)tab, (String)"portrait")) {
            return mapping.findForward("portrait");
        }
        if (StringUtils.equals((String)tab, (String)"lessons")) {
            return mapping.findForward("lessons");
        }
        if (StringUtils.equals((String)tab, (String)"community")) {
            String comLoginUrl = Configuration.get((String)ConfigurationKeys.SERVER_URL) + "/lamsCommunityLogin.do";
            request.setAttribute("comLoginUrl", (Object)comLoginUrl);
            request.setAttribute("tab", (Object)tab);
            return mapping.findForward("community");
        }
        if (request.isUserInRole("SYSADMIN") && StringUtils.isBlank((String)(groups = WebUtil.readStrParam((HttpServletRequest)request, (String)"groups", (boolean)true)))) {
            request.setAttribute("showGroups", (Object)false);
            return mapping.findForward("main");
        }
        Registration reg = Configuration.getRegistration();
        if (reg != null) {
            request.setAttribute("lamsCommunityEnabled", (Object)reg.isEnableLamsCommunityIntegration());
        }
        List collapsedOrgDTOs = this.getUserManagementService().getActiveCourseIdsByUser(loggedInUser.getUserId(), request.isUserInRole("SYSADMIN"));
        request.setAttribute("collapsedOrgDTOs", (Object)collapsedOrgDTOs);
        return mapping.findForward("main");
    }

    private void setHeaderLinks(HttpServletRequest request) {
        ArrayList<IndexLinkBean> headerLinks = new ArrayList<IndexLinkBean>();
        if (request.isUserInRole("AUTHOR") || request.isUserInRole("AUTHOR ADMIN")) {
            if (this.isPedagogicalPlannerAvailable()) {
                headerLinks.add(new IndexLinkBean("index.planner", "javascript:openPedagogicalPlanner()"));
            }
            headerLinks.add(new IndexLinkBean("index.author", "javascript:openAuthor()"));
        }
        headerLinks.add(new IndexLinkBean("index.myprofile", "index.do?tab=profile"));
        Registration reg = Configuration.getRegistration();
        if (reg != null && (request.isUserInRole("SYSADMIN") || request.isUserInRole("GROUP ADMIN") || request.isUserInRole("GROUP MANAGER") || request.isUserInRole("AUTHOR") || request.isUserInRole("AUTHOR ADMIN") || request.isUserInRole("MONITOR"))) {
            headerLinks.add(new IndexLinkBean("index.community", "index.do?tab=community"));
        }
        String customTabText = Configuration.get((String)ConfigurationKeys.CUSTOM_TAB_TITLE);
        String customTabLink = Configuration.get((String)ConfigurationKeys.CUSTOM_TAB_LINK);
        if (customTabLink != null && customTabLink.trim().length() > 0) {
            headerLinks.add(new IndexLinkBean(customTabText, "javascript:openCustom(\"" + customTabLink + "\")"));
        }
        request.setAttribute("headerLinks", headerLinks);
    }

    private void setAdminLinks(HttpServletRequest request) {
        ArrayList<IndexLinkBean> adminLinks = new ArrayList<IndexLinkBean>();
        if (request.isUserInRole("SYSADMIN") || request.isUserInRole("GROUP ADMIN") || request.isUserInRole("GROUP MANAGER")) {
            adminLinks.add(new IndexLinkBean("index.courseman", "javascript:openOrgManagement(" + this.getUserManagementService().getRootOrganisation().getOrganisationId() + ')'));
        }
        if (request.isUserInRole("SYSADMIN") || request.isUserInRole("AUTHOR ADMIN") || this.getUserManagementService().isUserGlobalGroupAdmin()) {
            adminLinks.add(new IndexLinkBean("index.sysadmin", "javascript:openSysadmin()"));
        }
        request.setAttribute("adminLinks", adminLinks);
    }

    private IUserManagementService getUserManagementService() {
        if (userManagementService == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            userManagementService = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return userManagementService;
    }

    private boolean isPedagogicalPlannerAvailable() {
        String lamsEarPath = Configuration.get((String)ConfigurationKeys.LAMS_EAR_DIR);
        String plannerPath = lamsEarPath + File.separator + PATH_LAMS_CENTRAL + File.separator + PATH_PEDAGOGICAL_PLANNER;
        File plannerDir = new File(plannerPath);
        return plannerDir.isDirectory() && plannerDir.list().length > 0;
    }
}

