/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.util.Configuration;
import org.lamsfoundation.lams.util.ConfigurationKeys;

public class LamsStartupServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(LamsStartupServlet.class);
    private static final long serialVersionUID = 8010145709788505351L;

    public void init() throws ServletException {
        String tempDirStr = Configuration.get((String)ConfigurationKeys.LAMS_TEMP_DIR);
        File tempDir = new File(tempDirStr);
        if (tempDir != null && tempDir.canWrite()) {
            File[] files = tempDir.listFiles();
            log.info((Object)("Deleting temporary files from: " + tempDir));
            for (File file : files) {
                if (!file.getName().startsWith("lams")) continue;
                if (file.isDirectory() && file.getName().startsWith("lams")) {
                    log.debug((Object)("Deleting temporary file directory: " + file));
                    if (this.deleteDir(file)) continue;
                    log.error((Object)("Failed to delete " + file));
                    continue;
                }
                log.debug((Object)("Deleting temporary file: " + file));
                if (file.delete()) continue;
                log.error((Object)("Failed to delete " + file));
            }
        } else {
            log.error((Object)("Cannot delete temporary files, do not have permission for folder: " + tempDirStr));
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

