/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.DynaActionForm;
import org.lamsfoundation.lams.themes.Theme;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ProfileSaveAction
extends Action {
    private static Logger log = Logger.getLogger(ProfileSaveAction.class);
    private static IUserManagementService service;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isCancelled(request)) {
            return mapping.findForward("profile");
        }
        ActionMessages errors = new ActionMessages();
        User requestor = this.getService().getUserByLogin(request.getRemoteUser());
        DynaActionForm userForm = (DynaActionForm)form;
        log.debug((Object)("requestor: " + requestor.getLogin() + ", form login: " + userForm.get("login")));
        if (!requestor.getLogin().equals(userForm.get("login"))) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.authorisation"));
            this.saveErrors(request, errors);
            return mapping.getInputForward();
        }
        if (userForm.get("firstName") == null || userForm.getString("firstName").trim().length() == 0) {
            errors.add("firstName", new ActionMessage("error.firstname.required"));
        }
        if (userForm.get("lastName") == null || userForm.getString("lastName").trim().length() == 0) {
            errors.add("lastName", new ActionMessage("error.lastname.required"));
        }
        if (userForm.get("email") == null || userForm.getString("email").trim().length() == 0) {
            errors.add("email", new ActionMessage("error.email.required"));
        } else {
            Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
            Matcher m = p.matcher(userForm.getString("email"));
            if (!m.matches()) {
                errors.add("email", new ActionMessage("error.valid.email.required"));
            }
        }
        if (!errors.isEmpty()) {
            this.saveErrors(request, errors);
            return mapping.findForward("editprofile");
        }
        BeanUtils.copyProperties((Object)requestor, (Object)userForm);
        SupportedLocale locale = (SupportedLocale)this.getService().findById(SupportedLocale.class, (Serializable)((Integer)userForm.get("localeId")));
        requestor.setLocale(locale);
        Theme cssTheme = (Theme)this.getService().findById(Theme.class, (Serializable)((Long)userForm.get("userCSSTheme")));
        requestor.setHtmlTheme(cssTheme);
        Theme flashTheme = (Theme)this.getService().findById(Theme.class, (Serializable)((Long)userForm.get("userFlashTheme")));
        requestor.setFlashTheme(flashTheme);
        if (userForm.get("disableLamsCommunityUsername") != null && ((Boolean)userForm.get("disableLamsCommunityUsername")).booleanValue()) {
            requestor.setLamsCommunityToken(null);
            requestor.setLamsCommunityUsername(null);
        }
        this.getService().save((Object)requestor);
        log.debug((Object)("profile edited: " + requestor));
        HttpSession ss = SessionManager.getSession();
        ss.removeAttribute("user");
        ss.setAttribute("user", (Object)requestor.getUserDTO());
        return mapping.findForward("profile");
    }

    private IUserManagementService getService() {
        if (service == null) {
            WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
            service = (IUserManagementService)ctx.getBean("userManagementService");
        }
        return service;
    }
}

