/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.usermanagement.dto.UserDTO;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.wddx.WDDXProcessor;
import org.lamsfoundation.lams.web.servlet.AbstractStoreWDDXPacketServlet;
import org.lamsfoundation.lams.web.session.SessionManager;

public class ReportWddxStructureServlet
extends AbstractStoreWDDXPacketServlet {
    private static final long serialVersionUID = 1993150655543872349L;
    private static Logger log = Logger.getLogger(ReportWddxStructureServlet.class);

    protected String process(String wddxPacket, HttpServletRequest request) throws Exception {
        UserDTO user;
        HttpSession ss = SessionManager.getSession();
        UserDTO userDTO = user = ss != null ? (UserDTO)ss.getAttribute("user") : null;
        if (user == null) {
            String error = "ReportWddxStructureServlet: Attempt to dump file by someone not logged in.";
            log.error((Object)error);
            throw new Exception(error);
        }
        String id = "DUMP" + user.getLogin();
        String filename = null;
        try {
            Object packet = WDDXProcessor.deserialize((String)wddxPacket);
            byte[] dump = this.convertJavaToDump(packet);
            filename = FileUtil.createDumpFile((byte[])dump, (String)id, (String)"txt");
        }
        catch (Exception e) {
            String error = "ReportWddxStructureServlet: Unable to serialise packet.";
            log.error((Object)error, (Throwable)e);
            throw e;
        }
        return "<HTML><BODY><P>Dump file is " + filename + "</P></BODY></HTML>";
    }

    private byte[] convertJavaToDump(Object packet) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.output(packet, out, "");
        return out.toByteArray();
    }

    private void output(Object obj, OutputStream out, String indent) throws IOException {
        if (obj != null) {
            if (obj instanceof Map) {
                this.outputMap((Map)obj, out, indent);
            } else if (obj instanceof Vector) {
                this.outputVector((Vector)obj, out, indent);
            } else {
                out.write(obj.toString().getBytes());
            }
        }
    }

    private void outputMap(Map map, OutputStream out, String indent) throws IOException {
        byte[] indentBytes = indent.getBytes();
        out.write(indentBytes);
        out.write("Map{\n".getBytes());
        String newIndent = indent + "    ";
        byte[] newIndentBytes = newIndent.getBytes();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            out.write(newIndentBytes);
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            out.write("[".getBytes());
            out.write(key.getBytes());
            out.write("=".getBytes());
            this.output(entry.getValue(), out, newIndent);
            out.write("]\n".getBytes());
        }
        out.write(indentBytes);
        out.write("}\n".getBytes());
    }

    private void outputVector(Vector vector, OutputStream out, String indent) throws IOException {
        byte[] indentBytes = indent.getBytes();
        out.write("Vector{\n".getBytes());
        String newIndent = indent + "    ";
        Iterator iter = vector.iterator();
        while (iter.hasNext()) {
            this.output(iter.next(), out, newIndent);
            out.write("\n".getBytes());
        }
        out.write(indentBytes);
        out.write("}".getBytes());
    }

    protected String getMessageKey(String packet, HttpServletRequest request) {
        return "ReportWddxStructureServlet";
    }
}

