/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.planner;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.LearnerChoiceGrouping;
import org.lamsfoundation.lams.learningdesign.RandomGrouping;
import org.lamsfoundation.lams.web.planner.PedagogicalPlannerActivityForm;

public class PedagogicalPlannerGroupingForm
extends PedagogicalPlannerActivityForm {
    private Integer groupingTypeId;
    private String numberOfGroups;
    private String learnersPerGroup;
    private Boolean equalGroupSizes;
    private Boolean viewStudentsBeforeSelection;

    public Integer getGroupingTypeId() {
        return this.groupingTypeId;
    }

    public void setGroupingTypeId(Integer groupingTypeId) {
        this.groupingTypeId = groupingTypeId;
    }

    public String getNumberOfGroups() {
        return this.numberOfGroups;
    }

    public void setNumberOfGroups(String numberOfGroups) {
        this.numberOfGroups = numberOfGroups;
    }

    public void fillForm(Grouping grouping) {
        if (grouping != null) {
            this.setGroupingTypeId(grouping.getGroupingTypeId());
            if (grouping.isRandomGrouping()) {
                RandomGrouping randomGrouping = (RandomGrouping)grouping;
                String number = randomGrouping.getNumberOfGroups() == null ? null : String.valueOf(randomGrouping.getNumberOfGroups());
                this.setNumberOfGroups(number);
                number = randomGrouping.getLearnersPerGroup() == null ? null : String.valueOf(randomGrouping.getLearnersPerGroup());
                this.setLearnersPerGroup(number);
            } else if (grouping.isLearnerChoiceGrouping()) {
                LearnerChoiceGrouping learnerChoiceGrouping = (LearnerChoiceGrouping)grouping;
                String number = learnerChoiceGrouping.getNumberOfGroups() == null ? null : String.valueOf(learnerChoiceGrouping.getNumberOfGroups());
                this.setNumberOfGroups(number);
                number = learnerChoiceGrouping.getLearnersPerGroup() == null ? null : String.valueOf(learnerChoiceGrouping.getLearnersPerGroup());
                this.setLearnersPerGroup(number);
                this.setEqualGroupSizes(learnerChoiceGrouping.getEqualNumberOfLearnersPerGroup());
                this.setViewStudentsBeforeSelection(learnerChoiceGrouping.getViewStudentsBeforeSelection());
            } else {
                String numberOfGroups = grouping.getMaxNumberOfGroups() == null ? null : String.valueOf(grouping.getMaxNumberOfGroups());
                this.setNumberOfGroups(numberOfGroups);
            }
        }
    }

    public ActionMessages validate() {
        ActionMessages errors = new ActionMessages();
        boolean valid = true;
        boolean numberValid = true;
        String numberToParse = StringUtils.isEmpty((String)this.getNumberOfGroups()) ? this.getLearnersPerGroup() : this.getNumberOfGroups();
        try {
            int number = Integer.parseInt(numberToParse);
            if (number < 0) {
                numberValid = false;
            }
        }
        catch (Exception e) {
            numberValid = false;
        }
        if (!numberValid) {
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage("error.planner.grouping.number.integer"));
            valid = false;
        }
        this.setValid(valid);
        return errors;
    }

    public String getLearnersPerGroup() {
        return this.learnersPerGroup;
    }

    public void setLearnersPerGroup(String numberOfLearners) {
        this.learnersPerGroup = numberOfLearners;
    }

    public Boolean getEqualGroupSizes() {
        return this.equalGroupSizes;
    }

    public void setEqualGroupSizes(Boolean equalGroupsSizes) {
        this.equalGroupSizes = equalGroupsSizes;
    }

    public Boolean getViewStudentsBeforeSelection() {
        return this.viewStudentsBeforeSelection;
    }

    public void setViewStudentsBeforeSelection(Boolean viewStudentsBeforeSelection) {
        this.viewStudentsBeforeSelection = viewStudentsBeforeSelection;
    }
}

