/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.web.tag;

import java.util.Random;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;
import org.lamsfoundation.lams.web.session.SessionManager;

public class GenerateIDTag
extends TagSupport {
    private static final long serialVersionUID = -2801719186682639858L;
    private static final Logger log = Logger.getLogger(GenerateIDTag.class);
    private int number = -1;
    private Integer lessonID;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public int doStartTag() throws JspException {
        HttpSession ss = SessionManager.getSession();
        JspWriter writer = this.pageContext.getOut();
        try {
            if (ss != null) {
                String uniqueID;
                if (this.getId() != null && this.getId().startsWith("$")) {
                    ExpressionEvaluatorManager.evaluate((String)"id", (String)this.getId(), String.class, (Tag)this, (PageContext)this.pageContext);
                }
                if ((uniqueID = (String)ss.getAttribute("uniqueID")) != null) {
                    if (this.getId() != null) {
                        writer.print(uniqueID + "_" + this.getId());
                    } else {
                        writer.print(uniqueID);
                    }
                } else {
                    long seed = System.currentTimeMillis();
                    Random rand = new Random(seed);
                    this.number = rand.nextInt();
                    int pos = Math.abs(this.number);
                    if (this.number != -1) {
                        ss.setAttribute("uniqueID", (Object)Integer.toString(pos));
                        if (this.getId() != null) {
                            writer.print(ss.getAttribute("uniqueID") + "_" + this.getId());
                        } else {
                            writer.print(ss.getAttribute("uniqueID"));
                        }
                    } else {
                        log.warn((Object)"GenerateIDTag could not write out random number because no new integer value was assigned.");
                    }
                }
            } else {
                log.warn((Object)"GenerateTag unable to access shared session as it is missing");
            }
        }
        catch (Exception e) {
            log.error((Object)"GenerateIDTag unable to write out random number due to Exception.");
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }
}

