/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IIntegrationService;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.OrganisationState;
import org.lamsfoundation.lams.usermanagement.OrganisationType;
import org.lamsfoundation.lams.usermanagement.Role;
import org.lamsfoundation.lams.usermanagement.SupportedLocale;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.UserOrganisation;
import org.lamsfoundation.lams.usermanagement.UserOrganisationRole;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.LanguageUtil;
import org.lamsfoundation.lams.webservice.Register;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RegisterServiceSoapBindingImpl
implements Register {
    Logger log = Logger.getLogger(RegisterServiceSoapBindingImpl.class);
    private static MessageContext context = MessageContext.getCurrentContext();
    private static IUserManagementService service = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("userManagementService");
    private static ILessonService lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("lessonService");
    private static IIntegrationService integrationService = (IIntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)((HttpServlet)context.getProperty(HTTPConstants.MC_HTTP_SERVLET)).getServletContext()).getBean("integrationService");

    public boolean createUser(String username, String password, String firstName, String lastName, String email, String serverId, String datetime, String hash) throws RemoteException {
        try {
            ExtServerOrgMap extServer = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)extServer, (String)datetime, (String)hash);
            if (service.getUserByLogin(username) != null) {
                return false;
            }
            ExtUserUseridMap userMap = integrationService.getImplicitExtUserUseridMap(extServer, username, password, firstName, lastName, email);
            return true;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public int createOrganisation(String name, String code, String description, String owner, String serverId, String datetime, String hash) throws RemoteException {
        try {
            Organisation org = new Organisation();
            org.setName(name);
            org.setCode(code);
            org.setDescription(description);
            org.setParentOrganisation(service.getRootOrganisation());
            org.setOrganisationType((OrganisationType)service.findById(OrganisationType.class, (Serializable)OrganisationType.COURSE_TYPE));
            org.setOrganisationState((OrganisationState)service.findById(OrganisationState.class, (Serializable)OrganisationState.ACTIVE));
            SupportedLocale locale = LanguageUtil.getDefaultLocale();
            org.setLocale(locale);
            User user = service.getUserByLogin(owner);
            service.saveOrganisation(org, user.getUserId());
            return org.getOrganisationId();
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToOrganisation(String login, Integer organisationId, Boolean asStaff, String serverId, String datetime, String hash) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)hash);
            User user = service.getUserByLogin(login);
            Organisation org = (Organisation)service.findById(Organisation.class, (Serializable)organisationId);
            if (user == null || org == null) {
                return false;
            }
            UserOrganisation uo = service.getUserOrganisation(user.getUserId(), org.getOrganisationId());
            if (uo == null) {
                uo = new UserOrganisation(user, org);
                service.save((Object)uo);
                Integer[] roles = asStaff != false ? new Integer[]{Role.ROLE_AUTHOR, Role.ROLE_MONITOR, Role.ROLE_LEARNER} : new Integer[]{Role.ROLE_LEARNER};
                for (Integer roleId : roles) {
                    UserOrganisationRole uor = new UserOrganisationRole(uo, (Role)service.findById(Role.class, (Serializable)roleId));
                    service.save((Object)uor);
                    uo.addUserOrganisationRole(uor);
                }
                user.addUserOrganisation(uo);
                service.save((Object)user);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToGroup(String username, String serverId, String datetime, String hash, String courseId, String courseName, String countryIsoCode, String langIsoCode, Boolean isTeacher) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)hash);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, courseName, countryIsoCode, langIsoCode, service.getRootOrganisation().getOrganisationId().toString(), isTeacher, Boolean.valueOf(false));
            return true;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToSubgroup(String username, String serverId, String datetime, String hash, String courseId, String courseName, String countryIsoCode, String langIsoCode, String subgroupId, String subgroupName, Boolean isTeacher) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)hash);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, courseName, countryIsoCode, langIsoCode, service.getRootOrganisation().getOrganisationId().toString(), isTeacher, Boolean.valueOf(false));
            Organisation group = orgMap.getOrganisation();
            ExtCourseClassMap subOrgMap = integrationService.getExtCourseClassMap(serverMap, userMap, subgroupId, subgroupName, countryIsoCode, langIsoCode, group.getOrganisationId().toString(), isTeacher, Boolean.valueOf(false));
            return true;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToGroupLessons(String username, String serverId, String datetime, String hash, String courseId, String courseName, String countryIsoCode, String langIsoCode, Boolean asStaff) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)hash);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, courseName, countryIsoCode, langIsoCode, service.getRootOrganisation().getOrganisationId().toString(), asStaff, Boolean.valueOf(false));
            Organisation org = orgMap.getOrganisation();
            User user = service.getUserByLogin(username);
            this.addUserToLessons(user, org, asStaff);
            return true;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean addUserToSubgroupLessons(String username, String serverId, String datetime, String hash, String courseId, String courseName, String countryIsoCode, String langIsoCode, String subgroupId, String subgroupName, Boolean asStaff) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)hash);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, courseName, countryIsoCode, langIsoCode, service.getRootOrganisation().getOrganisationId().toString(), asStaff, Boolean.valueOf(false));
            Organisation group = orgMap.getOrganisation();
            ExtCourseClassMap subOrgMap = integrationService.getExtCourseClassMap(serverMap, userMap, subgroupId, subgroupName, countryIsoCode, langIsoCode, group.getOrganisationId().toString(), asStaff, Boolean.valueOf(false));
            Organisation subgroup = subOrgMap.getOrganisation();
            if (subgroup != null) {
                User user = service.getUserByLogin(username);
                this.addUserToLessons(user, subgroup, asStaff);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    private void addUserToLessons(User user, Organisation org, Boolean asStaff) {
        if (org.getLessons() != null) {
            for (Lesson lesson : org.getLessons()) {
                lessonService.addLearner(lesson.getLessonId(), user.getUserId());
                if (asStaff.booleanValue()) {
                    lessonService.addStaffMember(lesson.getLessonId(), user.getUserId());
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Added " + user.getLogin() + " to " + lesson.getLessonName() + (asStaff != false ? " as staff, and" : " as learner")));
            }
        }
    }
}

