/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class WhiteboardToJpgServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(WhiteboardToJpgServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        PrintWriter out = null;
        String ext = "jpg";
        String dir = System.getProperty("java.io.tmpdir");
        try {
            out = response.getWriter();
            String d = request.getParameter("data");
            String w = request.getParameter("width");
            String h = request.getParameter("height");
            log.debug((Object)("got parameters data=" + d + ", width=" + w + ", height=" + h));
            out.write("got parameters data=" + d + ", width=" + w + ", height=" + h);
            String[] darray = d.split(",");
            int[] pixels = new int[darray.length];
            for (int i = 0; i < darray.length; ++i) {
                pixels[i] = new Integer(darray[i]);
            }
            int width = new Integer(w);
            int height = new Integer(h);
            BufferedImage buffer = new BufferedImage(width, height, 1);
            buffer.setRGB(0, 0, width, height, pixels, 0, width);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)buffer, ext, os);
                byte[] imagebytes = os.toByteArray();
                FileOutputStream fileos = new FileOutputStream(new File(dir + "/new." + ext));
                fileos.write(imagebytes);
                fileos.close();
            }
            catch (IOException e) {
                log.error((Object)("file output stream threw exception, " + e));
            }
            catch (Exception e) {
                log.error((Object)e);
                out.write("\n" + e);
            }
        }
        catch (IOException e) {
            log.error((Object)("print writer threw exception, " + e));
        }
        catch (Exception e) {
            log.error((Object)e);
            out.write("\n" + e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

