/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.contentrepository.RepositoryCheckedException;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.learningdesign.service.ExportToolContentException;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.usermanagement.exception.UserAccessDeniedException;
import org.lamsfoundation.lams.util.FileUtil;
import org.lamsfoundation.lams.util.MessageService;
import org.lamsfoundation.lams.util.WebUtil;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.lamsfoundation.lams.workspace.web.WorkspaceAction;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LearningDesignRepositoryServlet
extends HttpServlet {
    private static final long serialVersionUID = -4962711640290319063L;
    private static Logger log = Logger.getLogger(LearningDesignRepositoryServlet.class);
    private static IntegrationService integrationService = null;
    private static IWorkspaceManagementService service = null;
    private static MessageService msgService = null;
    private static IExportToolContentService exportToolContentService = null;
    private static final String PARAM_LEARING_DESIGN_ID = "learningDesignID";
    private static final String PARAM_EXPORT_FORMAT = "format";
    private static final String IMS_XSLT_NAME = "learning-design-ims.xslt";
    private static final String IMS_XSLT_PATH = "/toolcontent";

    public void destroy() {
        super.destroy();
    }

    private ContentTreeNode buildContentTree(Integer userId, Integer mode) throws IOException, UserAccessDeniedException, RepositoryCheckedException {
        log.debug((Object)("User Id - " + userId));
        FolderContentDTO rootFolder = new FolderContentDTO(msgService.getMessage("label.workspace.root_folder"), msgService.getMessage("folder"), null, null, "Folder", Long.valueOf(WorkspaceAction.BOOTSTRAP_FOLDER_ID.longValue()), WorkspaceFolder.READ_ACCESS, null);
        ContentTreeNode root = new ContentTreeNode(rootFolder);
        FolderContentDTO userFolder = service.getUserWorkspaceFolder(userId);
        root.addChild(this.buildContentTreeNode(userFolder, userId, mode));
        FolderContentDTO dummyOrgFolder = new FolderContentDTO(msgService.getMessage("organisations"), msgService.getMessage("folder"), null, null, "Folder", new Long(WorkspaceAction.ORG_FOLDER_ID.longValue()), WorkspaceFolder.READ_ACCESS, null);
        ContentTreeNode dummyOrgNode = new ContentTreeNode(dummyOrgFolder);
        Vector orgFolders = service.getAccessibleOrganisationWorkspaceFolders(userId);
        for (int i = 0; i < orgFolders.size(); ++i) {
            FolderContentDTO orgFolder = (FolderContentDTO)orgFolders.get(i);
            dummyOrgNode.addChild(this.buildContentTreeNode(orgFolder, userId, mode));
        }
        root.addChild(dummyOrgNode);
        return root;
    }

    private ContentTreeNode buildContentTreeNode(FolderContentDTO folder, Integer userId, Integer mode) throws UserAccessDeniedException, RepositoryCheckedException {
        log.debug((Object)("build content tree node for folder - " + folder.getName()));
        ContentTreeNode node = new ContentTreeNode(folder);
        if (folder.getResourceType().equals("Folder")) {
            log.debug((Object)(folder.getName() + " is a folder"));
            WorkspaceFolder wsfolder = service.getWorkspaceFolder(folder.getResourceID().intValue());
            Vector<FolderContentDTO> items = service.getFolderContentsExcludeHome(userId, wsfolder, mode);
            for (int i = 0; i < items.size(); ++i) {
                FolderContentDTO content = items.get(i);
                node.addChild(this.buildContentTreeNode(content, userId, mode));
            }
        }
        return node;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String serverId = request.getParameter("serverId");
            String datetime = request.getParameter("datetime");
            String hashValue = request.getParameter("hashValue");
            String username = request.getParameter("username");
            String courseId = request.getParameter("courseId");
            String courseName = request.getParameter("courseName");
            String country = request.getParameter("country");
            String lang = request.getParameter("lang");
            String modeStr = request.getParameter("mode");
            String method = request.getParameter("method");
            String firstName = request.getParameter("firstName");
            String lastName = request.getParameter("lastName");
            String email = request.getParameter("email");
            if (serverId == null || datetime == null || hashValue == null || username == null || courseId == null || country == null || lang == null || modeStr == null) {
                String msg = "Parameters missing";
                log.error((Object)msg);
                response.sendError(400, "Parameters missing");
            }
            if (request.getCharacterEncoding() == null) {
                log.debug((Object)"request.getCharacterEncoding is empty, parsing username and courseName as 8859_1 to UTF-8...");
                username = new String(username.getBytes("8859_1"), "UTF-8");
                if (courseName != null) {
                    courseName = new String(courseName.getBytes("8859_1"), "UTF-8");
                }
            }
            Integer mode = new Integer(modeStr);
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            if (method != null && method.equals("exportLD")) {
                this.exportLD(request, response);
            } else {
                ExtUserUseridMap userMap = null;
                userMap = firstName == null && lastName == null ? integrationService.getExtUserUseridMap(serverMap, username) : integrationService.getImplicitExtUserUseridMap(serverMap, username, firstName, lastName, lang, country, email);
                integrationService.getExtCourseClassMap(serverMap, userMap, courseId, country, lang, courseName, method);
                String contentTree = this.buildContentTree(userMap.getUser().getUserId(), mode).toString();
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF8");
                PrintWriter out = response.getWriter();
                out.print(contentTree);
            }
        }
        catch (NumberFormatException nfe) {
            log.error((Object)"mode is not an integer", (Throwable)nfe);
            response.sendError(400, "mode is not an integer");
        }
        catch (AuthenticationException e) {
            log.error((Object)"can not authenticate", (Throwable)e);
            response.sendError(400, "can not authenticate");
        }
        catch (UserInfoFetchException e) {
            log.error((Object)"can not retreive user information", (Throwable)e);
            response.sendError(400, "can not retreive user information");
        }
        catch (UserAccessDeniedException e) {
            log.error((Object)"user access denied", (Throwable)e);
            response.sendError(400, "user access denied");
        }
        catch (RepositoryCheckedException e) {
            log.error((Object)"repository checked", (Throwable)e);
            response.sendError(400, "repository checked");
        }
        catch (Exception e) {
            log.error((Object)"Problem with LearningDesignRepositoryServlet request", (Throwable)e);
            response.sendError(400, "Problem with LearningDesignRepositoryServlet request");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void exportLD(HttpServletRequest request, HttpServletResponse response) {
        Long learningDesignId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LEARING_DESIGN_ID);
        int format = WebUtil.readIntParam((HttpServletRequest)request, (String)PARAM_EXPORT_FORMAT);
        ArrayList toolsErrorMsgs = new ArrayList();
        try {
            File xslt = new File(this.getServletContext().getRealPath(IMS_XSLT_PATH) + File.separator + IMS_XSLT_NAME);
            String zipFilename = exportToolContentService.exportLearningDesign(learningDesignId, toolsErrorMsgs, format, xslt);
            String zipfile = FileUtil.getFileName((String)zipFilename);
            zipfile = zipfile.replaceAll(" ", "_");
            String filename = FileUtil.encodeFilenameForDownload((HttpServletRequest)request, (String)zipfile);
            log.debug((Object)("Final filename to export: " + filename));
            response.setContentType("application/x-download");
            response.setHeader("Content-Disposition", "attachment;filename=" + filename);
            InputStream in = null;
            OutputStream out = null;
            try {
                int ch;
                in = new BufferedInputStream(new FileInputStream(zipFilename));
                out = response.getOutputStream();
                int count = 0;
                while ((ch = in.read()) != -1) {
                    out.write((char)ch);
                    ++count;
                }
                log.debug((Object)("Wrote out " + count + " bytes"));
                response.setContentLength(count);
                out.flush();
            }
            catch (Exception e) {
                log.error((Object)("Exception occured writing out file:" + e.getMessage()));
                throw new ExportToolContentException((Throwable)e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error Closing file. File already written out - no exception being thrown.", (Throwable)e);
                }
            }
        }
        catch (Exception e1) {
            log.error((Object)("Unable to export tool content to external integrated server: " + e1.toString()));
        }
    }

    public void init() throws ServletException {
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        service = (IWorkspaceManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("workspaceManagementService");
        msgService = service.getMessageService();
        exportToolContentService = (IExportToolContentService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("exportToolContentService");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContentTreeNode {
        FolderContentDTO content;
        List<ContentTreeNode> children;

        ContentTreeNode(FolderContentDTO content) {
            this.content = content;
            this.children = new LinkedList<ContentTreeNode>();
        }

        List<ContentTreeNode> getChildren() {
            return this.children;
        }

        void setChildren(List<ContentTreeNode> children) {
            this.children = children;
        }

        FolderContentDTO getContent() {
            return this.content;
        }

        void setContent(FolderContentDTO content) {
            this.content = content;
        }

        void addChild(FolderContentDTO content) {
            this.children.add(new ContentTreeNode(content));
        }

        void addChild(ContentTreeNode node) {
            this.children.add(node);
        }

        public String toString() {
            Document document = this.getDocument();
            try {
                DOMSource domSource = new DOMSource(document);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.transform(domSource, result);
                return writer.toString();
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        String convert() {
            StringBuilder sb = new StringBuilder();
            if (this.content.getResourceType().equals("Folder")) {
                sb.append("['");
                sb.append(this.content.getName()).append("',").append("null").append(',');
                if (this.children.size() == 0) {
                    sb.append("['',null]");
                } else {
                    sb.append(this.children.get(0).convert());
                    for (int i = 1; i < this.children.size(); ++i) {
                        sb.append(',').append(this.children.get(i).convert());
                    }
                }
                sb.append(']');
            } else if (this.content.getResourceType().equals("LearningDesign")) {
                sb.append('[');
                sb.append('\'').append(this.content.getName()).append('\'').append(',').append('\'').append(this.content.getResourceID()).append('\'');
                sb.append(']');
            }
            return sb.toString();
        }

        public Document getDocument() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element element = this.createXML(document);
                document.appendChild(element);
                return document;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public Element createXML(Document document) {
            Element elem = null;
            if (this.content.getResourceType().equals("Folder")) {
                elem = document.createElement("Folder");
                elem.setAttribute("name", this.content.getName());
                if (this.children.size() > 0) {
                    for (int i = 0; i < this.children.size(); ++i) {
                        elem.appendChild(this.children.get(i).createXML(document));
                    }
                }
            } else if (this.content.getResourceType().equals("LearningDesign")) {
                elem = document.createElement("LearningDesign");
                elem.setAttribute("name", this.content.getName());
                elem.setAttribute("resourceId", this.content.getResourceID().toString());
            }
            return elem;
        }
    }
}

