/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.webservice.xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.lamsfoundation.lams.integration.ExtCourseClassMap;
import org.lamsfoundation.lams.integration.ExtServerOrgMap;
import org.lamsfoundation.lams.integration.ExtUserUseridMap;
import org.lamsfoundation.lams.integration.UserInfoFetchException;
import org.lamsfoundation.lams.integration.security.AuthenticationException;
import org.lamsfoundation.lams.integration.security.Authenticator;
import org.lamsfoundation.lams.integration.service.IntegrationService;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityEvaluation;
import org.lamsfoundation.lams.learningdesign.ToolActivity;
import org.lamsfoundation.lams.learningdesign.service.IExportToolContentService;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.Lesson;
import org.lamsfoundation.lams.lesson.dto.LearnerProgressDTO;
import org.lamsfoundation.lams.lesson.service.ILessonService;
import org.lamsfoundation.lams.monitoring.service.IMonitoringService;
import org.lamsfoundation.lams.tool.OutputType;
import org.lamsfoundation.lams.tool.ToolOutput;
import org.lamsfoundation.lams.tool.ToolOutputDefinition;
import org.lamsfoundation.lams.tool.ToolSession;
import org.lamsfoundation.lams.tool.service.ILamsCoreToolService;
import org.lamsfoundation.lams.usermanagement.Organisation;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.DateUtil;
import org.lamsfoundation.lams.web.session.SessionManager;
import org.lamsfoundation.lams.workspace.service.IWorkspaceManagementService;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LessonManagerServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(LessonManagerServlet.class);
    private static IntegrationService integrationService = null;
    private static IWorkspaceManagementService service = null;
    private static IMonitoringService monitoringService = null;
    private static ILessonService lessonService = null;
    private static IExportToolContentService exportService = null;
    private static ILamsCoreToolService toolService = null;
    private static IUserManagementService userManagementService = null;

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        response.setContentType("text/xml");
        response.setCharacterEncoding("UTF8");
        String serverId = request.getParameter("serverId");
        String datetime = request.getParameter("datetime");
        String hashValue = request.getParameter("hashValue");
        String username = request.getParameter("username");
        String courseId = request.getParameter("courseId");
        String ldIdStr = request.getParameter("ldId");
        String lsIdStr = request.getParameter("lsId");
        String country = request.getParameter("country");
        String title = request.getParameter("title");
        String desc = request.getParameter("desc");
        String startDate = request.getParameter("startdate");
        String lang = request.getParameter("lang");
        String method = request.getParameter("method");
        String filePath = request.getParameter("filePath");
        String progressUser = request.getParameter("progressUser");
        String outputsUser = request.getParameter("outputsUser");
        String learnerIds = request.getParameter("learnerIds");
        String monitorIds = request.getParameter("monitorIds");
        String customCSV = request.getParameter("customCSV");
        Long ldId = null;
        Long lsId = null;
        try {
            Long lessonId;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = null;
            if (hashValue == null || hashValue.equals("")) {
                throw new NullPointerException("Hash value missing in parameters");
            }
            if (method.equals("start")) {
                ldId = new Long(ldIdStr);
                lessonId = this.startLesson(serverId, datetime, hashValue, username, ldId, courseId, title, desc, country, lang, customCSV);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lessonId.toString());
            } else if (method.equals("preview")) {
                ldId = new Long(ldIdStr);
                lessonId = this.startPreview(serverId, datetime, hashValue, username, ldId, courseId, title, desc, country, lang, customCSV);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lessonId.toString());
            } else if (method.equals("schedule")) {
                ldId = new Long(ldIdStr);
                lessonId = this.scheduleLesson(serverId, datetime, hashValue, username, ldId, courseId, title, desc, startDate, country, lang, customCSV);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lessonId.toString());
            } else if (method.equals("delete")) {
                lsId = new Long(lsIdStr);
                Boolean deleted = this.deleteLesson(serverId, datetime, hashValue, username, lsId);
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lsId.toString());
                element.setAttribute("deleted", deleted.toString());
            } else if (method.equals("studentProgress")) {
                lsId = new Long(lsIdStr);
                element = this.getAllStudentProgress(document, serverId, datetime, hashValue, username, lsId, courseId);
            } else if (method.equals("singleStudentProgress")) {
                lsId = new Long(lsIdStr);
                element = this.getSingleStudentProgress(document, serverId, datetime, hashValue, username, lsId, courseId, progressUser);
            } else if (method.equals("import")) {
                Long ldID = this.importLearningDesign(request, response, filePath, username, serverId, customCSV);
                element = document.createElement("Lesson");
                element.setAttribute("ldId", ldID.toString());
            } else if (method.equals("join")) {
                Thread t = new Thread(new AddUsersToLessonThread(serverId, datetime, username, hashValue, lsIdStr, courseId, country, lang, learnerIds, monitorIds, request));
                t.start();
                element = document.createElement("Lesson");
                element.setAttribute("lessonId", lsIdStr);
            } else if (method.equals("toolOutputsAllUsers")) {
                lsId = new Long(lsIdStr);
                element = this.getToolOutputs(document, serverId, datetime, hashValue, username, lsId, courseId, false);
            } else if (method.equals("authoredToolOutputsAllUsers")) {
                lsId = new Long(lsIdStr);
                element = this.getToolOutputs(document, serverId, datetime, hashValue, username, lsId, courseId, true);
            } else if (method.equals("toolOutputsUser")) {
                lsId = new Long(lsIdStr);
                element = this.getToolOutputsForUser(document, serverId, datetime, hashValue, username, lsId, courseId, false, outputsUser);
            } else if (method.equals("authoredToolOutputsUser")) {
                lsId = new Long(lsIdStr);
                element = this.getToolOutputsForUser(document, serverId, datetime, hashValue, username, lsId, courseId, true, outputsUser);
            } else {
                String msg = "Method :" + method + " is not recognised";
                log.error((Object)msg);
                response.sendError(400, msg);
            }
            document.appendChild(element);
            DOMSource domSource = new DOMSource(document);
            StringWriter writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            out.write(writer.toString());
        }
        catch (NumberFormatException nfe) {
            log.error((Object)("lsId or ldId is not an integer" + lsIdStr + ldIdStr), (Throwable)nfe);
            response.sendError(400, "lsId or ldId is not an integer");
        }
        catch (TransformerConfigurationException e) {
            log.error((Object)"Can not convert XML document to string", (Throwable)e);
            response.sendError(500);
        }
        catch (TransformerException e) {
            log.error((Object)"Can not convert XML document to string", (Throwable)e);
            response.sendError(500);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Can not build XML document", (Throwable)e);
            response.sendError(500);
        }
        catch (NullPointerException e) {
            log.error((Object)"Missing parameters", (Throwable)e);
            response.sendError(500);
        }
        catch (Exception e) {
            log.error((Object)"Problem loading learning manager servlet request", (Throwable)e);
            response.sendError(500);
        }
        out.flush();
        out.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public Long startLesson(String serverId, String datetime, String hashValue, String username, long ldId, String courseId, String title, String desc, String countryIsoCode, String langIsoCode, String customCSV) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, countryIsoCode, langIsoCode, null, "monitor");
            Lesson lesson = monitoringService.initializeLesson(title, desc, Boolean.TRUE, ldId, orgMap.getOrganisation().getOrganisationId(), userMap.getUser().getUserId(), customCSV, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
            this.createLessonClass(lesson, orgMap.getOrganisation(), userMap.getUser());
            monitoringService.startLesson(lesson.getLessonId().longValue(), userMap.getUser().getUserId());
            return lesson.getLessonId();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public Long scheduleLesson(String serverId, String datetime, String hashValue, String username, long ldId, String courseId, String title, String desc, String startDate, String countryIsoCode, String langIsoCode, String customCSV) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, countryIsoCode, langIsoCode, null, "monitor");
            Lesson lesson = monitoringService.initializeLesson(title, desc, Boolean.TRUE, ldId, orgMap.getOrganisation().getOrganisationId(), userMap.getUser().getUserId(), customCSV, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            this.createLessonClass(lesson, orgMap.getOrganisation(), userMap.getUser());
            Date date = DateUtil.convertFromLAMSFlashFormat((String)startDate);
            monitoringService.startLessonOnSchedule(lesson.getLessonId().longValue(), date, userMap.getUser().getUserId(), null);
            return lesson.getLessonId();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public Element getAllStudentProgress(Document document, String serverId, String datetime, String hashValue, String username, long lsId, String courseID) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            Lesson lesson = lessonService.getLesson(Long.valueOf(lsId));
            Element element = document.createElement("LessonProgress");
            element.setAttribute("lessonId", "" + lsId);
            String prefix = serverMap.getPrefix();
            if (lesson != null) {
                int activitiesTotal = lesson.getLearningDesign().getActivities().size();
                for (LearnerProgress learnProg : lesson.getLearnerProgresses()) {
                    LearnerProgressDTO learnerProgress = learnProg.getLearnerProgressData();
                    String userNoPrefixName = learnerProgress.getUserName().substring(prefix.length() + 1);
                    ExtUserUseridMap learnerMap = integrationService.getExtUserUseridMap(serverMap, userNoPrefixName);
                    Element learnerProgElem = document.createElement("LearnerProgress");
                    int completedActivities = learnerProgress.getCompletedActivities().length;
                    int attemptedActivities = learnerProgress.getAttemptedActivities().length;
                    if (learnerProgElem.getNodeType() == 1) {
                        learnerProgElem.setAttribute("lessonComplete", "" + learnerProgress.getLessonComplete());
                        learnerProgElem.setAttribute("activityCount", "" + activitiesTotal);
                        learnerProgElem.setAttribute("activitiesCompleted", "" + completedActivities);
                        learnerProgElem.setAttribute("attemptedActivities", "" + attemptedActivities);
                        learnerProgElem.setAttribute("studentId", "" + learnerMap.getSid());
                        learnerProgElem.setAttribute("courseId", courseID);
                        learnerProgElem.setAttribute("username", userNoPrefixName);
                        learnerProgElem.setAttribute("lessonId", "" + lsId);
                    }
                    element.appendChild(learnerProgElem);
                }
            } else {
                throw new Exception("Lesson with lessonID: " + lsId + " could not be found for learner progresses");
            }
            return element;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public Element getSingleStudentProgress(Document document, String serverId, String datetime, String hashValue, String username, long lsId, String courseID, String progressUser) throws RemoteException {
        try {
            Element learnerProgElem;
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            Lesson lesson = lessonService.getLesson(Long.valueOf(lsId));
            Element element = document.createElement("LessonProgress");
            element.setAttribute("lessonId", "" + lsId);
            String prefix = serverMap.getPrefix();
            if (lesson != null) {
                int activitiesTotal = lesson.getLearningDesign().getActivities().size();
                ExtUserUseridMap progressUserMap = integrationService.getExistingExtUserUseridMap(serverMap, progressUser);
                LearnerProgress learnProg = lessonService.getUserProgressForLesson(userMap.getUser().getUserId(), Long.valueOf(lsId));
                learnerProgElem = document.createElement("LearnerProgress");
                if (learnProg != null) {
                    LearnerProgressDTO learnerProgress = learnProg.getLearnerProgressData();
                    int completedActivities = learnerProgress.getCompletedActivities().length;
                    int attemptedActivities = learnerProgress.getAttemptedActivities().length;
                    if (learnerProgElem.getNodeType() == 1) {
                        learnerProgElem.setAttribute("lessonComplete", "" + learnerProgress.getLessonComplete());
                        learnerProgElem.setAttribute("activityCount", "" + activitiesTotal);
                        learnerProgElem.setAttribute("activitiesCompleted", "" + completedActivities);
                        learnerProgElem.setAttribute("attemptedActivities", "" + attemptedActivities);
                        learnerProgElem.setAttribute("studentId", "" + progressUserMap.getSid());
                        learnerProgElem.setAttribute("courseId", courseID);
                        learnerProgElem.setAttribute("username", progressUser);
                        learnerProgElem.setAttribute("lessonId", "" + lsId);
                    }
                } else if (learnerProgElem.getNodeType() == 1) {
                    learnerProgElem.setAttribute("lessonComplete", "false");
                    learnerProgElem.setAttribute("activityCount", "" + activitiesTotal);
                    learnerProgElem.setAttribute("activitiesCompleted", "0");
                    learnerProgElem.setAttribute("attemptedActivities", "0");
                    learnerProgElem.setAttribute("studentId", "" + progressUserMap.getSid());
                    learnerProgElem.setAttribute("courseId", courseID);
                    learnerProgElem.setAttribute("username", progressUser);
                    learnerProgElem.setAttribute("lessonId", "" + lsId);
                }
            } else {
                throw new Exception("Lesson with lessonID: " + lsId + " could not be found for learner progresses");
            }
            element.appendChild(learnerProgElem);
            return element;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public boolean deleteLesson(String serverId, String datetime, String hashValue, String username, long lsId) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            monitoringService.removeLesson(lsId, userMap.getUser().getUserId());
            return true;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public Long startPreview(String serverId, String datetime, String hashValue, String username, Long ldId, String courseId, String title, String desc, String countryIsoCode, String langIsoCode, String customCSV) throws RemoteException {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, countryIsoCode, langIsoCode, null, "monitor");
            Lesson lesson = monitoringService.initializeLessonForPreview(title, desc, ldId.longValue(), userMap.getUser().getUserId(), customCSV, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
            monitoringService.createPreviewClassForLesson(userMap.getUser().getUserId().intValue(), lesson.getLessonId().longValue());
            monitoringService.startLesson(lesson.getLessonId().longValue(), userMap.getUser().getUserId());
            return lesson.getLessonId();
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public Long importLearningDesign(HttpServletRequest request, HttpServletResponse response, String filePath, String username, String serverId, String customCSV) throws RemoteException {
        List ldErrorMsgs = new ArrayList();
        List toolsErrorMsgs = new ArrayList();
        Long ldId = null;
        Integer workspaceFolderUid = null;
        User user = null;
        ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
        try {
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            user = userMap.getUser();
            HttpSession ss = SessionManager.getSession();
            boolean createdTemporarySession = false;
            if (ss == null) {
                SessionManager.startSession((ServletRequest)request, (ServletResponse)response);
                ss = SessionManager.getSession();
                ss.setAttribute("user", (Object)user.getUserDTO());
                createdTemporarySession = true;
            }
            File designFile = new File(filePath);
            Object[] ldResults = exportService.importLearningDesign(designFile, user, workspaceFolderUid, toolsErrorMsgs, customCSV);
            ldId = (Long)ldResults[0];
            ldErrorMsgs = (List)ldResults[1];
            toolsErrorMsgs = (List)ldResults[2];
            if (createdTemporarySession) {
                SessionManager.endSession();
            }
            return ldId;
        }
        catch (Exception e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    private void createLessonClass(Lesson lesson, Organisation organisation, User creator) {
        LinkedList<User> staffList = new LinkedList<User>();
        staffList.add(creator);
        LinkedList learnerList = new LinkedList();
        Vector learnerVector = userManagementService.getUsersFromOrganisationByRole(organisation.getOrganisationId(), "LEARNER", false, true);
        learnerList.addAll(learnerVector);
        monitoringService.createLessonClassForLesson(lesson.getLessonId().longValue(), organisation, organisation.getName() + "Learners", learnerList, organisation.getName() + "Staff", staffList, creator.getUserId());
    }

    public void init() throws ServletException {
        service = (IWorkspaceManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("workspaceManagementService");
        integrationService = (IntegrationService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("integrationService");
        monitoringService = (IMonitoringService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("monitoringService");
        lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("lessonService");
        exportService = (IExportToolContentService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("exportToolContentService");
        toolService = (ILamsCoreToolService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("lamsCoreToolService");
        userManagementService = (IUserManagementService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext()).getBean("userManagementService");
    }

    public Element getToolOutputs(Document document, String serverId, String datetime, String hashValue, String username, Long lsId, String courseID, boolean isAuthoredToolOutputs) throws Exception {
        try {
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            Lesson lesson = lessonService.getLesson(lsId);
            Set activities = lesson.getLearningDesign().getActivities();
            Element toolOutputsElement = document.createElement("ToolOutputs");
            if (lesson != null) {
                log.debug((Object)("Getting tool ouputs report for: " + lsId + ". With learning design: " + lesson.getLearningDesign().getLearningDesignId()));
                toolOutputsElement.setAttribute("lessonId", "" + lsId);
                toolOutputsElement.setAttribute("name", lesson.getLessonName());
                for (User learner : lesson.getAllLearners()) {
                    String userNoPrefixName = learner.getLogin().substring(serverMap.getPrefix().length() + 1);
                    toolOutputsElement.appendChild(this.getLearnerOutputsElement(document, learner, lesson, activities, isAuthoredToolOutputs, userNoPrefixName));
                }
            } else {
                log.debug((Object)("No lesson exists for: " + lsId + ". Cannot get tool outputs report."));
                throw new Exception("Lesson with lessonID: " + lsId + " could not be found for learner progresses");
            }
            return toolOutputsElement;
        }
        catch (Exception e) {
            log.error((Object)("Problem creating tool output report for lesson: " + lsId.toString()), (Throwable)e);
            throw new Exception(e);
        }
    }

    public Element getToolOutputsForUser(Document document, String serverId, String datetime, String hashValue, String username, Long lsId, String courseID, boolean isAuthoredToolOutputs, String userStr) throws Exception {
        try {
            Element toolOutputsElement = document.createElement("ToolOutputs");
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)username, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExistingExtUserUseridMap(serverMap, userStr);
            if (userMap != null) {
                User learner = userMap.getUser();
                Lesson lesson = lessonService.getLesson(lsId);
                Set activities = lesson.getLearningDesign().getActivities();
                if (lesson != null) {
                    log.debug((Object)("Getting tool ouputs report for: " + lsId + ". With learning design: " + lesson.getLearningDesign().getLearningDesignId()));
                    toolOutputsElement.setAttribute("lessonId", "" + lsId);
                    toolOutputsElement.setAttribute("name", lesson.getLessonName());
                    String userNoPrefixName = learner.getLogin().substring(serverMap.getPrefix().length() + 1);
                    toolOutputsElement.appendChild(this.getLearnerOutputsElement(document, learner, lesson, activities, isAuthoredToolOutputs, userNoPrefixName));
                }
            } else {
                log.debug((Object)("No user exists for: " + userStr + ". Cannot get tool outputs report."));
                throw new Exception("No user exists for: " + userStr + ". Cannot get tool outputs report.");
            }
            return toolOutputsElement;
        }
        catch (Exception e) {
            log.error((Object)("Problem creating tool output report for lesson: " + lsId.toString()), (Throwable)e);
            throw new Exception(e);
        }
    }

    private Element getLearnerOutputsElement(Document document, User learner, Lesson lesson, Set<Activity> activities, boolean isAuthoredToolOutputs, String userNoPrefixName) {
        Element learnerElement = document.createElement("LearnerOutput");
        learnerElement.setAttribute("userName", userNoPrefixName);
        learnerElement.setAttribute("lamsUserName", learner.getLogin());
        learnerElement.setAttribute("lamsUserId", learner.getUserId().toString());
        learnerElement.setAttribute("firstName", learner.getFirstName());
        learnerElement.setAttribute("lastName", learner.getLastName());
        LearnerProgress learnerProgress = monitoringService.getLearnerProgress(learner.getUserId(), lesson.getLessonId());
        if (learnerProgress != null) {
            learnerElement.setAttribute("completedLesson", "" + learnerProgress.isComplete());
        }
        Activity firstActivity = monitoringService.getActivityById(lesson.getLearningDesign().getFirstActivity().getActivityId());
        log.debug((Object)("Getting tool ouputs for first activity: " + firstActivity.getActivityId() + ". For user: " + learner.getUserId()));
        if (firstActivity.isToolActivity() && firstActivity instanceof ToolActivity) {
            learnerElement.appendChild(this.getActivityOutputsElement(document, (ToolActivity)firstActivity, learner, learnerProgress, isAuthoredToolOutputs));
        }
        for (Activity activity : activities) {
            if (activity.getActivityId().longValue() == firstActivity.getActivityId().longValue()) continue;
            log.debug((Object)("Getting tool ouputs for activity: " + activity.getActivityId() + ". For user: " + learner.getUserId()));
            if (!activity.isToolActivity() || !(activity instanceof ToolActivity)) continue;
            learnerElement.appendChild(this.getActivityOutputsElement(document, (ToolActivity)activity, learner, learnerProgress, isAuthoredToolOutputs));
        }
        return learnerElement;
    }

    private Element getActivityOutputsElement(Document document, ToolActivity toolAct, User learner, LearnerProgress progress, boolean isAuthoredToolOutputs) {
        Element activityElement = document.createElement("Activity");
        activityElement.setAttribute("title", toolAct.getTitle());
        activityElement.setAttribute("activityId", toolAct.getActivityId().toString());
        if (toolAct.getOrderId() != null) {
            activityElement.setAttribute("orderId", toolAct.getOrderId().toString());
        }
        boolean activityAttempted = false;
        if (progress != null) {
            boolean completed = progress.getProgressState((Activity)toolAct) == 1;
            activityElement.setAttribute("completed", "" + completed);
            activityAttempted = completed || progress.getProgressState((Activity)toolAct) == 2;
            activityElement.setAttribute("attempted", "" + activityAttempted);
        } else {
            activityElement.setAttribute("attempted", "false");
            activityElement.setAttribute("completed", "false");
        }
        if (activityAttempted) {
            ToolSession toolSession = toolService.getToolSessionByLearner(learner, (Activity)toolAct);
            SortedMap map = toolService.getOutputDefinitionsFromTool(toolAct.getToolContentId());
            if (toolSession != null) {
                for (String outputName : map.keySet()) {
                    try {
                        ToolOutputDefinition definition = (ToolOutputDefinition)map.get(outputName);
                        if (isAuthoredToolOutputs) {
                            Set activityEvaluations = toolAct.getActivityEvaluations();
                            if (activityEvaluations == null) continue;
                            for (ActivityEvaluation evaluation : activityEvaluations) {
                                if (!outputName.equals(evaluation.getToolOutputDefinition())) continue;
                                ToolOutput toolOutput = toolService.getOutputFromTool(outputName, toolSession, learner.getUserId());
                                activityElement.appendChild(this.getOutputElement(document, toolOutput, definition));
                            }
                            continue;
                        }
                        ToolOutput toolOutput = toolService.getOutputFromTool(outputName, toolSession, learner.getUserId());
                        if (toolOutput == null) continue;
                        activityElement.appendChild(this.getOutputElement(document, toolOutput, definition));
                    }
                    catch (RuntimeException e) {
                        log.debug((Object)("Runtime exception when attempted to get outputs for activity: " + toolAct.getActivityId() + ", continuing for other activities"), (Throwable)e);
                    }
                }
            }
        }
        return activityElement;
    }

    private Element getOutputElement(Document document, ToolOutput toolOutput, ToolOutputDefinition definition) {
        Element toolOutputElement = document.createElement("ToolOutput");
        toolOutputElement.setAttribute("name", toolOutput.getName());
        toolOutputElement.setAttribute("description", toolOutput.getDescription());
        toolOutputElement.setAttribute("output", toolOutput.getValue().getString());
        Long marksPossible = this.getTotalMarksAvailable(definition);
        toolOutputElement.setAttribute("marksPossible", marksPossible != null ? marksPossible.toString() : "");
        OutputType outputType = toolOutput.getValue().getType();
        String type = outputType == OutputType.OUTPUT_BOOLEAN ? "boolean" : (outputType == OutputType.OUTPUT_COMPLEX ? "complex" : (outputType == OutputType.OUTPUT_DOUBLE ? "double" : (outputType == OutputType.OUTPUT_LONG ? "long" : (outputType == OutputType.OUTPUT_SET_BOOLEAN ? "set_boolean" : "string"))));
        toolOutputElement.setAttribute("type", type);
        return toolOutputElement;
    }

    private Long getTotalMarksAvailable(ToolOutputDefinition definition) {
        Object upperLimit = definition.getEndValue();
        if (upperLimit != null && upperLimit instanceof Long) {
            return (Long)upperLimit;
        }
        return null;
    }

    private class AddUsersToLessonThread
    implements Runnable {
        private String serverId;
        private String datetime;
        private String username;
        private String hashValue;
        private String lsIdStr;
        private String courseId;
        private String country;
        private String lang;
        private String learnerIds;
        private String monitorIds;
        private HttpServletRequest request;

        public AddUsersToLessonThread(String serverId, String datetime, String username, String hashValue, String lsIdStr, String courseId, String country, String lang, String learnerIds, String monitorIds, HttpServletRequest request) {
            this.serverId = serverId;
            this.datetime = datetime;
            this.username = username;
            this.hashValue = hashValue;
            this.lsIdStr = lsIdStr;
            this.courseId = courseId;
            this.country = country;
            this.lang = lang;
            this.learnerIds = learnerIds;
            this.monitorIds = monitorIds;
            this.request = request;
        }

        public void run() {
            this.addUsersToLesson(this.serverId, this.datetime, this.username, this.hashValue, this.lsIdStr, this.courseId, this.country, this.lang, this.learnerIds, this.monitorIds, this.request);
        }

        public Boolean addUsersToLesson(String serverId, String datetime, String requestorUsername, String hashValue, String lsIdStr, String courseId, String countryIsoCode, String langIsoCode, String learnerIds, String monitorIds, HttpServletRequest request) {
            try {
                if (learnerIds != null) {
                    String[] learnerIdArray;
                    for (String learnerId : learnerIdArray = learnerIds.split(",")) {
                        if (!StringUtils.isNotBlank((String)learnerId)) continue;
                        this.addUserToLesson(request, serverId, datetime, requestorUsername, hashValue, "learner", lsIdStr, learnerId, courseId, countryIsoCode, langIsoCode);
                    }
                }
                if (monitorIds != null) {
                    String[] monitorIdArray;
                    for (String monitorId : monitorIdArray = monitorIds.split(",")) {
                        if (!StringUtils.isNotBlank((String)monitorId)) continue;
                        this.addUserToLesson(request, serverId, datetime, requestorUsername, hashValue, "monitor", lsIdStr, monitorId, courseId, countryIsoCode, langIsoCode);
                    }
                }
                return true;
            }
            catch (UserInfoFetchException e) {
                log.error((Object)e, (Throwable)e);
                return false;
            }
            catch (AuthenticationException e) {
                log.error((Object)e, (Throwable)e);
                return false;
            }
        }

        private void addUserToLesson(HttpServletRequest request, String serverId, String datetime, String requestorUsername, String hashValue, String method, String lsIdStr, String username, String courseId, String countryIsoCode, String langIsoCode) throws AuthenticationException, UserInfoFetchException {
            User user;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding user '" + username + "' as " + method + " to lesson with id '" + lsIdStr + "'."));
            }
            ExtServerOrgMap serverMap = integrationService.getExtServerOrgMap(serverId);
            Authenticator.authenticate((ExtServerOrgMap)serverMap, (String)datetime, (String)requestorUsername, (String)hashValue);
            ExtUserUseridMap userMap = integrationService.getExtUserUseridMap(serverMap, username);
            ExtCourseClassMap orgMap = integrationService.getExtCourseClassMap(serverMap, userMap, courseId, countryIsoCode, langIsoCode, null, method);
            if (lessonService == null) {
                lessonService = (ILessonService)WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getSession().getServletContext()).getBean("lessonService");
            }
            if ((user = userMap.getUser()) == null) {
                String error = "Unable to add user to lesson class as user is missing from the user map";
                log.error((Object)error);
                throw new UserInfoFetchException(error);
            }
            if ("learner".equals(method)) {
                lessonService.addLearner(Long.valueOf(Long.parseLong(lsIdStr)), user.getUserId());
            } else if ("monitor".equals(method)) {
                lessonService.addStaffMember(Long.valueOf(Long.parseLong(lsIdStr)), user.getUserId());
            }
        }
    }
}

