/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.lamsfoundation.lams.tool.deploy.DeployConfig;
import org.lamsfoundation.lams.tool.deploy.DeployToolConfig;

public abstract class CreatePackageTask
extends Task
implements DynamicConfigurator {
    public static final String MODE = "mode";
    public static final String MODE_DEVELOPMENT = "development";
    public static final String MODE_PRODUCTION = "production";
    public static final String CONFIG_FILE = "configFile";
    public static final String OUTPUT_PATH = "outputPath";
    public static final String SCRIPT_PATH = "scriptPath";
    protected DeployConfig deployConfig = null;
    private Properties inputProperties = new Properties();
    private Properties deployProperties = null;
    private static String outputFilename = "deploy.xml";
    private static String templateFileName = "deploy_template.xml";
    public String mode = "production";
    public File outputPath = null;
    public File configFile = null;
    private File outputPathLib = null;
    private File outputPathSql = null;

    public void setDynamicAttribute(String name, String value) {
        this.inputProperties.setProperty(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        throw new BuildException("CreatePackage does not support elements");
    }

    public abstract void execute();

    protected void applyParameters() {
        this.log("Applying task properties");
        for (String string : this.inputProperties.keySet()) {
            this.deployConfig.setProperty(string, this.inputProperties.getProperty(string));
        }
    }

    protected void applyFilesets(String key, Vector<FileSet> filesets) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (FileSet fileset : filesets) {
            String[] files;
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            for (String filename : files = ds.getIncludedFiles()) {
                filenames.add(ds.getBasedir() + File.separator + filename);
            }
        }
        this.deployConfig.setFilenames(key, filenames);
    }

    protected void createDirectory(File dir) {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new BuildException("Unable to write out deploy.properties - path " + dir + " exists but is not a directory.");
            }
            if (!dir.canWrite()) {
                throw new BuildException("Unable to write out deploy.properties - path " + dir + " exists but is read only.");
            }
        } else {
            dir.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeConfigFile() throws IOException {
        String outputName = this.outputPath + File.separator + outputFilename;
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(outputName));
            this.deployConfig.writePropertiesToFile(out);
        }
        catch (Exception e) {
            throw new BuildException("Unable to write out " + outputName + ". Error " + e.getMessage(), (Throwable)e);
        }
        this.log("File " + outputName + " written.");
        out.close();
        BufferedWriter out2 = null;
        try {
            if (this.deployConfig instanceof DeployToolConfig) {
                DeployToolConfig deployToolConfig = (DeployToolConfig)this.deployConfig;
                deployToolConfig.setGenerateForInstallers(true);
                deployToolConfig.convertForInstallers();
                String outputName2 = this.outputPath + File.separator + templateFileName;
                out2 = new BufferedWriter(new FileWriter(outputName2));
                deployToolConfig.writePropertiesToFile(out2);
                this.log("File " + outputName2 + " written.");
            }
        }
        catch (Exception e) {
        }
        finally {
            out.close();
        }
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setOutputPath(File outputPath) {
        this.outputPath = outputPath;
        if (outputPath != null) {
            this.outputPathLib = new File(outputPath.getAbsoluteFile() + File.separator + "lib");
            this.outputPathSql = new File(outputPath.getAbsoluteFile() + File.separator + "sql");
        } else {
            this.outputPathLib = null;
            this.outputPathSql = null;
        }
    }
}

