/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.Task;

public abstract class FilesTask
implements Task {
    protected String lamsEarPath;
    protected List<String> deployFiles;

    public void setLamsEarPath(String lamsEarPath) {
        this.lamsEarPath = lamsEarPath;
    }

    public void setDeployFiles(List<String> deployFiles) {
        this.deployFiles = deployFiles;
    }

    protected void copyFile(String fileName, File directory) throws DeployException {
        try {
            File original = new File(fileName);
            FileUtils.copyFileToDirectory((File)original, (File)directory);
        }
        catch (IOException ioex) {
            throw new DeployException("Could not copy file " + fileName + " to " + directory.getAbsolutePath(), ioex);
        }
    }

    protected File getLamsEar() throws DeployException {
        File lamsEar = new File(this.lamsEarPath);
        if (!lamsEar.exists()) {
            throw new DeployException("Could not find " + this.lamsEarPath);
        }
        if (!lamsEar.isDirectory()) {
            throw new DeployException(this.lamsEarPath + " is not a directory");
        }
        if (!lamsEar.canWrite()) {
            throw new DeployException(this.lamsEarPath + " is not writable");
        }
        return lamsEar;
    }
}

