/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang.StringUtils;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.UpdateWarTask;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RemoveToolContextClasspathTask
extends UpdateWarTask {
    @Override
    protected void updateParamValue(Document doc, Node contextParamElement) {
        NodeList valueChildren = contextParamElement.getChildNodes();
        for (int i = 0; i < valueChildren.getLength(); ++i) {
            String value;
            String newValue;
            Node valueChild = valueChildren.item(i);
            if (!(valueChild instanceof Text) || (newValue = StringUtils.replace((String)(value = valueChild.getNodeValue()), (String)this.getApplicationContextPathWithClasspath(), (String)"")).length() >= value.length()) continue;
            valueChild.setTextContent(newValue);
            System.out.println("Removed context entry " + this.getApplicationContextPathWithClasspath() + " from document.");
        }
    }

    @Override
    protected void updateClasspath(Manifest manifest) throws DeployException {
        Attributes mainAttributes = manifest.getMainAttributes();
        String classpath = null;
        if (mainAttributes != null) {
            classpath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        }
        String newJar = this.getJarFileNameWithDotSlash();
        String newClasspath = null;
        if (classpath != null) {
            newClasspath = StringUtils.replace((String)classpath, (String)newJar, (String)"");
            mainAttributes.put(Attributes.Name.CLASS_PATH, newClasspath);
            if (classpath.length() < newClasspath.length()) {
                System.out.println("Removed " + newJar + " from classpath");
            }
        }
    }
}

