/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.lamsfoundation.lams.tool.deploy.DBTask;
import org.lamsfoundation.lams.tool.deploy.DeployException;

public class ToolDBActivateTask
extends DBTask {
    private long toolId;
    private long learningLibraryId;

    @Override
    public void execute() throws DeployException {
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
            this.activateTool(this.toolId, conn);
            this.activateLibrary(this.learningLibraryId, conn);
            conn.commit();
        }
        catch (SQLException sqlex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex2) {
                throw new DeployException("Attempted to rollback db activate because of " + sqlex + " but failed - cleanup maybe required (see root cause)", sqlex2);
            }
            throw new DeployException("Execute failed", sqlex);
        }
        catch (DeployException dex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex) {
                throw new DeployException("Attempted to rollback db activate because of " + dex + " but failed - cleanup maybe required (see root cause)", sqlex);
            }
            throw dex;
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    public void setToolId(long toolId) {
        this.toolId = toolId;
    }

    public void setLearningLibraryId(long learningLibraryId) {
        this.learningLibraryId = learningLibraryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateTool(long newToolId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPDATE lams_tool SET valid_flag = 1 WHERE tool_id  = ?");
            stmt.setLong(1, newToolId);
            stmt.execute();
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateLibrary(long libraryId, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPDATE lams_learning_library SET valid_flag = 1 WHERE learning_library_id  = ?");
            stmt.setLong(1, libraryId);
            stmt.execute();
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }
}

