/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.io.FileUtils;
import org.lamsfoundation.lams.tool.deploy.DeployException;

public class FileTokenReplacer {
    protected File file;
    protected Map replacementMap;
    public static final String TOKEN_PREFIX = "${";
    public static final String TOKEN_SUFFIX = "}";
    public static final String TOKEN_REGEX_PREFIX = "\\$\\{";
    public static final String TOKEN_REGEX_SUFFIX = "\\}";
    public static final Pattern TOKEN_PATTERN = Pattern.compile("\\$\\{\\w+\\}");

    protected static String makeToken(String tokenValue) {
        StringBuffer buf = new StringBuffer(TOKEN_PREFIX);
        buf.append(tokenValue);
        buf.append(TOKEN_SUFFIX);
        return buf.toString();
    }

    protected static boolean isValidToken(String token) {
        return TOKEN_PATTERN.matcher(token).matches();
    }

    public FileTokenReplacer(File file, Map<String, String> replacementMap) {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (replacementMap == null) {
            throw new IllegalArgumentException("Replacement map is null");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist");
        }
        this.file = file;
        this.replacementMap = replacementMap;
    }

    public String replace() throws DeployException {
        String fileString = this.readFile();
        Set keys = this.replacementMap.keySet();
        for (String key : keys) {
            String value = (String)this.replacementMap.get(key);
            String token = FileTokenReplacer.makeToken(key);
            if (!FileTokenReplacer.isValidToken(token)) {
                throw new DeployException(key + " does not make a valid token (" + token + ")");
            }
            fileString = fileString.replaceAll(this.makeTokenRegex(key), value);
        }
        return fileString;
    }

    protected String makeTokenRegex(String tokenValue) throws DeployException {
        StringBuffer buf = new StringBuffer(TOKEN_REGEX_PREFIX);
        buf.append(tokenValue);
        buf.append(TOKEN_REGEX_SUFFIX);
        String regex = buf.toString();
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException psynex) {
            throw new DeployException(tokenValue + " does not make a valid regex", psynex);
        }
        return regex;
    }

    protected String readFile() throws DeployException {
        try {
            return FileUtils.readFileToString((File)this.file, (String)"UTF8");
        }
        catch (IOException ioex) {
            throw new DeployException("Could not read file", ioex);
        }
    }
}

