/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy.libraryActivity;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbutils.DbUtils;
import org.lamsfoundation.lams.tool.deploy.DBTask;
import org.lamsfoundation.lams.tool.deploy.DeployException;

public class ActivityDBLanguageUpdateTask
extends DBTask {
    private long activityId;
    private String languageFilename;

    @Override
    public void execute() throws DeployException {
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
            this.updateActivity(conn);
            conn.commit();
        }
        catch (SQLException sqlex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex2) {
                throw new DeployException("Attempted to rollback db update because of " + sqlex + " but failed - cleanup maybe required (see root cause)", sqlex2);
            }
            throw new DeployException("Execute failed", sqlex);
        }
        catch (DeployException dex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex) {
                throw new DeployException("Attempted to rollback db update because of " + dex + " but failed - cleanup maybe required (see root cause)", sqlex);
            }
            throw dex;
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActivity(Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("UPDATE lams_learning_activity SET language_file = ? WHERE learning_library_id  = ?");
            stmt.setString(1, this.languageFilename);
            stmt.setLong(2, this.activityId);
            stmt.execute();
        }
        finally {
            DbUtils.closeQuietly((Statement)stmt);
        }
    }

    public long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public String getLanguageFilename() {
        return this.languageFilename;
    }

    public void setLanguageFilename(String languageFilename) {
        this.languageFilename = languageFilename;
    }
}

