/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.UpdateWarTask;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class InsertToolContextClasspathTask
extends UpdateWarTask {
    @Override
    protected void updateParamValue(Document doc, Node contextParamElement) {
        NodeList valueChildren = contextParamElement.getChildNodes();
        boolean foundEntry = false;
        for (int i = 0; i < valueChildren.getLength() && !foundEntry; ++i) {
            String value;
            int index;
            Node valueChild = valueChildren.item(i);
            if (!(valueChild instanceof Text) || (index = (value = valueChild.getNodeValue()).indexOf(this.applicationContextPath)) < 0) continue;
            System.out.println("Application context entry " + this.getApplicationContextPathWithClasspath() + " already in document.");
            foundEntry = true;
        }
        if (!foundEntry) {
            System.out.println("Adding " + this.getApplicationContextPathWithClasspath() + " to context");
            contextParamElement.appendChild(doc.createTextNode(" " + this.getApplicationContextPathWithClasspath() + "\n"));
        }
    }

    @Override
    protected void updateClasspath(Manifest manifest) throws DeployException {
        Attributes mainAttributes = manifest.getMainAttributes();
        String classpath = null;
        if (mainAttributes != null) {
            classpath = mainAttributes.getValue(Attributes.Name.CLASS_PATH);
        }
        String newJar = this.getJarFileNameWithDotSlash();
        if (classpath == null) {
            mainAttributes.put(Attributes.Name.CLASS_PATH, newJar);
            System.out.println("Added " + newJar + " to classpath");
        } else if (classpath.indexOf(newJar) < 0) {
            mainAttributes.put(Attributes.Name.CLASS_PATH, classpath + " " + newJar);
            System.out.println("Added " + newJar + " to classpath");
        } else {
            System.out.println(newJar + " already on the classpath.");
        }
    }
}

