/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class UpdateWarTask
implements Task {
    protected static final String WEBXML_PATH = "WEB-INF/web.xml";
    protected static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    protected static final int BUFFER_SIZE = 8192;
    protected String lamsEarPath;
    protected List<String> archivesToUpdate;
    protected Map<File, File> filesToRename;
    protected String applicationContextPath;
    protected String jarFileName;

    public void setLamsEarPath(String lamsEarPath) {
        this.lamsEarPath = lamsEarPath;
    }

    public List<String> getArchivesToUpdate() {
        return this.archivesToUpdate;
    }

    public void setArchivesToUpdate(List<String> warsToUpdate) {
        this.archivesToUpdate = warsToUpdate;
    }

    public String getApplicationContextPath() {
        return this.applicationContextPath;
    }

    protected String getApplicationContextPathWithClasspath() {
        return "classpath:" + this.applicationContextPath;
    }

    public void setApplicationContextPath(String applicationContextPath) {
        this.applicationContextPath = applicationContextPath;
    }

    public String getJarFileName() {
        return this.jarFileName;
    }

    protected String getJarFileNameWithDotSlash() {
        return "./" + this.jarFileName;
    }

    public void setJarFileName(String jarFileName) {
        this.jarFileName = jarFileName;
    }

    @Override
    public void execute() throws DeployException {
        if (this.applicationContextPath == null) {
            throw new DeployException("UpdateWebXmTask: Unable to update web.xml as the application content path is missing (applicationContextPath).");
        }
        if (this.archivesToUpdate != null) {
            this.filesToRename = new HashMap<File, File>(this.archivesToUpdate.size());
            for (String warFileName : this.archivesToUpdate) {
                File warFile = new File(this.lamsEarPath + File.separator + warFileName);
                if (!warFile.canRead()) {
                    throw new DeployException("Unable to access war file " + warFile.getAbsolutePath() + ". May be missing or not readable");
                }
                if (warFile.isDirectory()) {
                    this.updateExpandedWar(warFileName, warFile);
                    continue;
                }
                this.updateZippedWar(warFileName, warFile);
            }
            this.copyNewFilesToOldNames();
        }
    }

    protected void updateExpandedWar(String warFileName, File warFileDirectory) {
        System.out.println("Updating expanded war " + warFileName);
        String webXMLFilename = this.lamsEarPath + File.separator + warFileName + File.separator + WEBXML_PATH;
        File webXMLFile = new File(webXMLFilename);
        File newWebXMLFile = new File(webXMLFilename + ".new");
        String manifestFilename = this.lamsEarPath + File.separator + warFileName + File.separator + MANIFEST_PATH;
        File manifestFile = new File(manifestFilename);
        File newManifestFilename = new File(manifestFilename + ".new");
        FileInputStream webXMLFileis = null;
        FileOutputStream webXMLFileos = null;
        FileInputStream manifestFileis = null;
        FileOutputStream manifestFileos = null;
        try {
            webXMLFileis = new FileInputStream(webXMLFile);
            webXMLFileos = new FileOutputStream(newWebXMLFile);
            manifestFileis = new FileInputStream(manifestFile);
            manifestFileos = new FileOutputStream(newManifestFilename);
            Document doc = this.parseWebXml(webXMLFileis);
            this.updateWebXml(doc);
            this.writeWebXml(doc, webXMLFileos);
            Manifest manifest = new Manifest(manifestFileis);
            this.updateClasspath(manifest);
            manifest.write(manifestFileos);
        }
        catch (IOException e) {
            throw new DeployException("Unable to process war file " + warFileName, e);
        }
        finally {
            try {
                if (webXMLFileis != null) {
                    webXMLFileis.close();
                }
                if (webXMLFileos != null) {
                    webXMLFileos.close();
                }
                if (manifestFileis != null) {
                    manifestFileis.close();
                }
                if (manifestFileos != null) {
                    manifestFileos.close();
                }
            }
            catch (IOException e2) {}
        }
        this.filesToRename.put(webXMLFile, newWebXMLFile);
        this.filesToRename.put(manifestFile, newManifestFilename);
    }

    protected void updateZippedWar(String warFileName, File warFile) {
        System.out.println("Updating zipped war " + warFileName);
        String newFilename = this.lamsEarPath + File.separator + warFileName + ".new";
        File outputFile = new File(newFilename);
        ZipOutputStream newWarOutputStream = null;
        ZipInputStream warInputStream = null;
        try {
            newWarOutputStream = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            newWarOutputStream.setMethod(8);
            newWarOutputStream.setLevel(-1);
            warInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(warFile)));
            ZipEntry entry = null;
            while ((entry = warInputStream.getNextEntry()) != null) {
                if (WEBXML_PATH.equals(entry.getName())) {
                    this.updateWebXML((JarOutputStream)newWarOutputStream, warInputStream, entry);
                    continue;
                }
                if (MANIFEST_PATH.equals(entry.getName())) {
                    this.updateManifest((JarOutputStream)newWarOutputStream, warInputStream, entry);
                    continue;
                }
                this.copyEntryToWar((JarOutputStream)newWarOutputStream, warInputStream, entry);
            }
            warInputStream.close();
            newWarOutputStream.close();
        }
        catch (IOException e) {
            throw new DeployException("Unable to process war file " + warFileName, e);
        }
        finally {
            try {
                if (warInputStream != null) {
                    warInputStream.close();
                }
                if (newWarOutputStream != null) {
                    newWarOutputStream.close();
                }
            }
            catch (IOException e2) {}
        }
        this.filesToRename.put(warFile, outputFile);
    }

    protected void copyEntryToWar(JarOutputStream newWarOutputStream, ZipInputStream warInputStream, ZipEntry entry) throws IOException {
        ZipEntry newEntry = new ZipEntry(entry.getName());
        newWarOutputStream.putNextEntry(newEntry);
        byte[] data = new byte[8192];
        int count = -1;
        while ((count = warInputStream.read(data, 0, 8192)) != -1) {
            newWarOutputStream.write(data, 0, count);
        }
        newWarOutputStream.closeEntry();
    }

    protected void copyNewFilesToOldNames() throws DeployException {
        for (Map.Entry<File, File> mapEntry : this.filesToRename.entrySet()) {
            File origFile = mapEntry.getKey();
            File backup = new File(origFile.getAbsoluteFile() + ".bak");
            if (backup.exists()) {
                backup.delete();
            }
            if (!backup.exists()) continue;
            throw new DeployException("Error occured removing an old backup file. Please remove the file " + backup.getAbsolutePath() + " and run the installation again.");
        }
        for (Map.Entry<File, File> mapEntry : this.filesToRename.entrySet()) {
            File backup;
            HashMap<File, File> renamed = new HashMap<File, File>(this.archivesToUpdate.size());
            File origFile = mapEntry.getKey();
            boolean successful = origFile.renameTo(backup = new File(origFile.getAbsoluteFile() + ".bak"));
            if (successful) {
                renamed.put(origFile, backup);
                successful = mapEntry.getValue().renameTo(origFile);
            }
            if (successful) {
                System.out.println("Updated file " + origFile.getName());
                continue;
            }
            for (Map.Entry renamedMapEntry : renamed.entrySet()) {
                File updatedFile = (File)renamedMapEntry.getKey();
                File backupFile = (File)renamedMapEntry.getValue();
                backupFile.renameTo(updatedFile);
            }
            String message = "Error occured renaming the war/web.xml/manifest files. Tried to go back to old files but may or may not have succeeded. Check files:";
            for (String warFileName : this.archivesToUpdate) {
                message = message + " " + warFileName;
            }
            throw new DeployException(message);
        }
    }

    protected ByteArrayInputStream copyToByteArrayInputStream(ZipInputStream warInputStream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        int count = -1;
        while ((count = warInputStream.read(data, 0, 8192)) != -1) {
            os.write(data, 0, count);
        }
        os.close();
        return new ByteArrayInputStream(os.toByteArray());
    }

    protected abstract void updateParamValue(Document var1, Node var2) throws DeployException;

    protected void updateWebXML(JarOutputStream newWarOutputStream, ZipInputStream warInputStream, ZipEntry entry) throws IOException {
        ZipEntry newEntry = new ZipEntry(WEBXML_PATH);
        newWarOutputStream.putNextEntry(newEntry);
        ByteArrayInputStream copyInputStream = this.copyToByteArrayInputStream(warInputStream);
        Document doc = this.parseWebXml(copyInputStream);
        this.updateWebXml(doc);
        this.writeWebXml(doc, newWarOutputStream);
        newWarOutputStream.closeEntry();
    }

    protected void updateWebXml(Document doc) throws DeployException {
        NodeList contextParamNodeList = doc.getElementsByTagName("context-param");
        Element matchingContextParamElement = this.findContextParamWithMatchingParamName("contextConfigLocation", contextParamNodeList);
        if (matchingContextParamElement == null) {
            throw new DeployException("No contextConfigLocation can be found in the web.xml in the war");
        }
        NodeList contextParamElements = matchingContextParamElement.getChildNodes();
        for (int c = 0; c < contextParamElements.getLength(); ++c) {
            Node contextParamElement = contextParamElements.item(c);
            if (!(contextParamElement instanceof Element) || !"param-value".equals(contextParamElement.getNodeName())) continue;
            this.updateParamValue(doc, contextParamElement);
        }
    }

    protected void writeWebXml(Document doc, OutputStream outputStream) throws DeployException {
        try {
            doc.normalize();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outputStream);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (TransformerException tex) {
            throw new DeployException("Error writing out modified web xml ", tex);
        }
    }

    protected Document parseWebXml(InputStream webXmlPath) throws DeployException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(webXmlPath);
        }
        catch (ParserConfigurationException pex) {
            throw new DeployException("Could not configure parser", pex);
        }
        catch (SAXException saxex) {
            throw new DeployException("Error parsing web xml" + webXmlPath, saxex);
        }
        catch (IOException ioex) {
            throw new DeployException("Error reading web xml" + webXmlPath, ioex);
        }
    }

    protected Element findContextParamWithMatchingParamName(String searchParamName, NodeList nodeList) throws DeployException {
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            NodeList children = node.getChildNodes();
            String paramName = null;
            for (int c = 0; c < children.getLength(); ++c) {
                NodeList nameChildren;
                Node childNode = children.item(c);
                if (!(childNode instanceof Element) || !"param-name".equals(childNode.getNodeName()) || (nameChildren = childNode.getChildNodes()) == null || nameChildren.getLength() <= 0 || !(nameChildren.item(0) instanceof Text) || (paramName = nameChildren.item(0).getNodeValue()) == null || !paramName.equals(searchParamName)) continue;
                return (Element)node;
            }
        }
        return null;
    }

    protected abstract void updateClasspath(Manifest var1) throws DeployException;

    protected void updateManifest(JarOutputStream newWarOutputStream, ZipInputStream warInputStream, ZipEntry entry) throws IOException {
        ZipEntry newEntry = new ZipEntry(MANIFEST_PATH);
        newWarOutputStream.putNextEntry(newEntry);
        Manifest manifest = new Manifest(warInputStream);
        this.updateClasspath(manifest);
        manifest.write(newWarOutputStream);
        newWarOutputStream.closeEntry();
    }
}

