/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.tool.deploy.libraryActivity;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.dbutils.DbUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.lamsfoundation.lams.tool.deploy.DBTask;
import org.lamsfoundation.lams.tool.deploy.DeployException;
import org.lamsfoundation.lams.tool.deploy.FileTokenReplacer;
import org.lamsfoundation.lams.tool.deploy.ScriptRunner;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.DeployLibraryConfig;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.LearningLibrary;
import org.lamsfoundation.lams.tool.deploy.libraryActivity.ToolActivity;

public class LibraryDBDeployTask
extends DBTask {
    private static Log log = LogFactory.getLog(LibraryDBDeployTask.class);
    private ArrayList learningLibraries;
    public static final String LEARNING_LIBRARY_ID = "learningLibraryId";

    public LibraryDBDeployTask() {
    }

    public LibraryDBDeployTask(DeployLibraryConfig config) {
        this.setDbDriverClass(config.getDbDriverClass());
        this.setDbDriverUrl(config.getDbDriverUrl());
        this.setDbPassword(config.getDbPassword());
        this.setDbUsername(config.getDbUsername());
        this.learningLibraries = config.getLearningLibraryList();
    }

    public void execute() throws DeployException {
        Connection conn = this.getConnection();
        try {
            conn.setAutoCommit(false);
            for (LearningLibrary learningLibrary : this.learningLibraries) {
                String libraryInsertScriptPath = learningLibrary.getLibraryInsertScriptPath();
                File libraryInsertScript = new File(libraryInsertScriptPath);
                long learningLibraryId = this.runLibraryScript(this.readFile(libraryInsertScript), conn, "lams_learning_library");
                log.debug((Object)"The learning_library_id is learningLibraryId");
                HashMap<String, String> replacementMap = new HashMap<String, String>(1);
                replacementMap.put("learning_library_id", Long.toString(learningLibraryId));
                FileTokenReplacer activityScriptReplacer = new FileTokenReplacer(new File(learningLibrary.getTemplateActivityInsertScriptPath()), replacementMap);
                String libraryActivityScriptSQL = activityScriptReplacer.replace();
                long parentActivityId = this.runLibraryScript(libraryActivityScriptSQL, conn, "lams_learning_activity");
                log.debug((Object)("Parent Learning Activity ID is: " + parentActivityId));
                learningLibrary.setLearningLibraryId(learningLibraryId);
                learningLibrary.setParentActivityId(learningLibraryId);
                ArrayList toolActivities = learningLibrary.getToolActivityList();
                for (ToolActivity toolActivity : toolActivities) {
                    long toolId = this.getToolId(toolActivity.getToolSignature(), conn);
                    replacementMap = new HashMap(1);
                    replacementMap.put("tool_id", Long.toString(toolId));
                    replacementMap.put("parent_activity_id", Long.toString(parentActivityId));
                    FileTokenReplacer toolTablesScriptReplacer = new FileTokenReplacer(new File(toolActivity.getToolActivityInsertScriptPath()), replacementMap);
                    String toolTablesScriptSQL = toolTablesScriptReplacer.replace();
                    this.runScript(toolTablesScriptSQL, conn);
                }
            }
            conn.commit();
        }
        catch (SQLException sqlex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex2) {
                throw new DeployException("Attempted to rollback because of " + sqlex + " but failed - cleanup maybe required (see root cause)", sqlex2);
            }
            throw new DeployException("Execute failed", sqlex);
        }
        catch (DeployException dex) {
            try {
                DbUtils.rollback((Connection)conn);
            }
            catch (SQLException sqlex) {
                throw new DeployException("Attempted to rollback because of " + dex + " but failed - cleanup maybe required (see root cause)", sqlex);
            }
            throw dex;
        }
        finally {
            DbUtils.closeQuietly((Connection)conn);
        }
    }

    public long getToolId(String toolSignature, Connection conn) {
        ResultSet results;
        PreparedStatement stmt;
        block5: {
            stmt = null;
            results = null;
            stmt = conn.prepareStatement("SELECT tool_id FROM lams_tool WHERE tool_signature=?");
            stmt.setString(1, toolSignature);
            stmt.execute();
            results = stmt.executeQuery();
            if (!results.next()) break block5;
            long l = results.getLong("tool_id");
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)results);
            return l;
        }
        try {
            try {
                throw new DeployException("Tool id for tool signature " + toolSignature + " not found.");
            }
            catch (SQLException sqlex) {
                throw new DeployException("Tool id for tool signature " + toolSignature + " not found.", sqlex);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly(results);
            throw throwable;
        }
    }

    private long runLibraryScript(String scriptSQL, Connection conn, String tablename) throws DeployException {
        ResultSet results;
        PreparedStatement stmt;
        block5: {
            this.runScript(scriptSQL, conn);
            stmt = null;
            results = null;
            stmt = conn.prepareStatement("SELECT LAST_INSERT_ID() FROM " + tablename);
            results = stmt.executeQuery();
            if (!results.next()) break block5;
            long l = results.getLong("LAST_INSERT_ID()");
            DbUtils.closeQuietly((Statement)stmt);
            DbUtils.closeQuietly((ResultSet)results);
            return l;
        }
        try {
            try {
                throw new DeployException("Could not get the last inserted id from table " + tablename);
            }
            catch (SQLException sqlex) {
                throw new DeployException("Failed to run learning library script", sqlex);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(stmt);
            DbUtils.closeQuietly(results);
            throw throwable;
        }
    }

    private void runScript(String scriptSQL, Connection conn) throws DeployException {
        ScriptRunner runner = new ScriptRunner(scriptSQL, conn);
        runner.run();
    }

    public ArrayList getLearningLibraries() {
        return this.learningLibraries;
    }

    public void setLearningLibraries(ArrayList learningLibraries) {
        this.learningLibraries = learningLibraries;
    }
}

