/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.GroupBranchActivityEntry;
import org.lamsfoundation.lams.learningdesign.Grouping;
import org.lamsfoundation.lams.learningdesign.dto.GroupDTO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.util.Nullable;

public class Group
implements Serializable,
Nullable,
Comparable {
    public static final int STAFF_GROUP_ORDER_ID = 1;
    public static final String NAME_OF_STAFF_GROUP = "Staff Group";
    private Long groupId;
    private String groupName;
    private int orderId;
    private Integer groupUIID;
    private Grouping grouping;
    private Set users;
    private Set toolSessions;
    private Set branchActivities;

    public Group(Long groupId, String groupName, int orderId, Integer groupUIID, Grouping grouping, Set users, Set toolSessions, Set branchActivities) {
        this.groupId = groupId;
        this.groupName = groupName;
        this.orderId = orderId;
        this.groupUIID = groupUIID;
        this.grouping = grouping;
        this.users = users;
        this.toolSessions = toolSessions;
        this.branchActivities = branchActivities;
    }

    public static Group createLearnerGroup(Grouping grouping, String groupName, Set users) {
        int nextOrderId = grouping.getNextGroupOrderIdCheckName(groupName);
        if (nextOrderId > -1) {
            return new Group(null, groupName, nextOrderId, null, grouping, users, new HashSet(), null);
        }
        return null;
    }

    public static Group createLearnerGroupWithToolSession(Grouping grouping, String groupName, Set users, Set toolSessions) {
        int nextOrderId = grouping.getNextGroupOrderIdCheckName(groupName);
        if (nextOrderId > -1) {
            return new Group(null, groupName, nextOrderId, null, grouping, users, toolSessions, null);
        }
        return null;
    }

    public static Group createStaffGroup(Grouping grouping, String groupName, Set staffs) {
        return new Group(null, groupName, 1, null, grouping, staffs, new HashSet(), null);
    }

    public Group() {
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public int getOrderId() {
        return this.orderId;
    }

    public void setOrderId(int orderId) {
        this.orderId = orderId;
    }

    public Integer getGroupUIID() {
        return this.groupUIID;
    }

    public void setGroupUIID(Integer uiId) {
        this.groupUIID = uiId;
    }

    public Grouping getGrouping() {
        return this.grouping;
    }

    public void setGrouping(Grouping grouping) {
        this.grouping = grouping;
    }

    public Set getUsers() {
        return this.users;
    }

    public void setUsers(Set userGroups) {
        this.users = userGroups;
    }

    public Set getToolSessions() {
        return this.toolSessions;
    }

    public void setToolSessions(Set toolSessions) {
        this.toolSessions = toolSessions;
    }

    public Set getBranchActivities() {
        return this.branchActivities;
    }

    public void setBranchActivities(Set branchActivities) {
        this.branchActivities = branchActivities;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("groupId", (Object)this.getGroupId()).append("groupName", (Object)this.getGroupName()).append("groupUIID", (Object)this.getGroupUIID()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Group)) {
            return false;
        }
        Group castOther = (Group)other;
        return new EqualsBuilder().append((Object)this.getGroupId(), (Object)castOther.getGroupId()).append((Object)this.getGroupName(), (Object)castOther.getGroupName()).append(this.getOrderId(), castOther.getOrderId()).append((Object)this.getGroupUIID(), (Object)castOther.getGroupUIID()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getGroupId()).append((Object)this.getGroupName()).append(this.getOrderId()).append((Object)this.getGroupUIID()).toHashCode();
    }

    public int compareTo(Object o) {
        Group group = (Group)o;
        return this.orderId - group.orderId;
    }

    public boolean hasLearner(User learner) {
        return this.getUsers().contains(learner);
    }

    public boolean isNull() {
        return false;
    }

    public GroupDTO getGroupDTO() {
        return new GroupDTO(this);
    }

    public boolean mayBeDeleted() {
        return this.getToolSessions().size() == 0;
    }

    public Group createCopy(Grouping newGrouping) {
        Group newGroup = new Group(null, this.getGroupName(), this.getOrderId(), this.getGroupUIID(), newGrouping, null, null, null);
        if (this.getBranchActivities() != null && this.getBranchActivities().size() > 0) {
            for (GroupBranchActivityEntry oldEntry : this.getBranchActivities()) {
                GroupBranchActivityEntry newEntry = new GroupBranchActivityEntry(null, oldEntry.getEntryUIID(), newGroup, oldEntry.getBranchSequenceActivity());
                newGroup.getBranchActivities().add(newEntry);
            }
        }
        return newGroup;
    }
}

