/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.License;
import org.lamsfoundation.lams.learningdesign.dto.DesignDetailDTO;
import org.lamsfoundation.lams.usermanagement.User;
import org.lamsfoundation.lams.usermanagement.WorkspaceFolder;
import org.lamsfoundation.lams.workspace.dto.FolderContentDTO;

public class LearningDesign
implements Serializable {
    private static final long serialVersionUID = -5695987114641062118L;
    public static final String DESIGN_OBJECT = "LearningDesign";
    public static final String DESIGN_LIST_OBJECT = "LearningDesignList";
    public static final int COPY_TYPE_NONE = 1;
    public static final int COPY_TYPE_LESSON = 2;
    public static final int COPY_TYPE_PREVIEW = 3;
    private Long learningDesignId;
    private Integer learningDesignUIID;
    private String description;
    private String title;
    private Activity firstActivity;
    private Integer maxID;
    private Boolean validDesign;
    private Boolean readOnly;
    private Date dateReadOnly;
    private Boolean editOverrideLock;
    private User editOverrideUser;
    private Integer designVersion;
    private String helpText;
    private Integer copyTypeID;
    private Date createDateTime;
    private String version;
    private User user;
    private LearningDesign originalLearningDesign;
    private Set childLearningDesigns;
    private Set lessons;
    private Set transitions;
    private Set activities;
    private WorkspaceFolder workspaceFolder;
    private Long duration;
    private String contentFolderID;
    private String licenseText;
    private License license;
    private Date lastModifiedDateTime;
    private String offlineInstructions;
    private String onlineInstructions;

    public LearningDesign(Long learningDesignId, Integer ui_id, String description, String title, Activity firstActivity, Integer maxID, Boolean validDesign, Boolean readOnly, Date dateReadOnly, String helpText, Integer copyTypeID, Date createDateTime, String version, User user, LearningDesign originalLearningDesign, Set childLearningDesigns, Set lessons, Set transitions, SortedSet activities, Long duration, String licenseText, License license, String offlineInstructions, String onlineInstructions, String contentFolderID, Boolean editOverrideLock, User editOverrideUser, Integer designVersion) {
        this.learningDesignId = learningDesignId;
        this.learningDesignUIID = ui_id;
        this.description = description;
        this.title = title;
        this.firstActivity = firstActivity;
        this.maxID = maxID;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.dateReadOnly = dateReadOnly;
        this.helpText = helpText;
        this.copyTypeID = copyTypeID;
        this.createDateTime = createDateTime != null ? createDateTime : new Date();
        this.version = version;
        this.user = user;
        this.originalLearningDesign = originalLearningDesign;
        this.childLearningDesigns = childLearningDesigns;
        this.lessons = lessons;
        this.transitions = transitions;
        this.activities = activities;
        this.duration = duration;
        this.licenseText = licenseText;
        this.license = license;
        this.offlineInstructions = offlineInstructions;
        this.onlineInstructions = onlineInstructions;
        this.contentFolderID = contentFolderID;
        this.lastModifiedDateTime = new Date();
        this.editOverrideLock = editOverrideLock;
        this.editOverrideUser = editOverrideUser;
        this.designVersion = designVersion;
    }

    public LearningDesign() {
        this.createDateTime = new Date();
        this.lastModifiedDateTime = new Date();
        this.editOverrideLock = false;
        this.designVersion = new Integer(1);
    }

    public LearningDesign(Long learningDesignId, Boolean validDesign, Boolean readOnly, Integer copyTypeID, Date createDateTime, String version, User user, LearningDesign originalLearningDesign, Set childLearningDesigns, Set lessons, Set transitions, SortedSet activities) {
        this.learningDesignId = learningDesignId;
        this.validDesign = validDesign;
        this.readOnly = readOnly;
        this.copyTypeID = copyTypeID;
        this.createDateTime = createDateTime != null ? createDateTime : new Date();
        this.version = version;
        this.user = user;
        this.originalLearningDesign = originalLearningDesign;
        this.childLearningDesigns = childLearningDesigns;
        this.lessons = lessons;
        this.transitions = transitions;
        this.activities = activities;
        this.lastModifiedDateTime = new Date();
        this.editOverrideLock = false;
        this.designVersion = new Integer(1);
    }

    public static LearningDesign createLearningDesignCopy(LearningDesign design, Integer designCopyType, boolean setOriginalDesign) {
        LearningDesign newDesign = new LearningDesign();
        newDesign.setDescription(design.getDescription());
        newDesign.setTitle(design.getTitle());
        newDesign.setMaxID(design.getMaxID());
        newDesign.setValidDesign(design.getValidDesign());
        newDesign.setDesignVersion(design.getDesignVersion());
        newDesign.setDateReadOnly(design.getDateReadOnly());
        newDesign.setHelpText(design.getHelpText());
        newDesign.setVersion(design.getVersion());
        newDesign.setCreateDateTime(new Date());
        newDesign.setDuration(design.getDuration());
        newDesign.setLicense(design.getLicense());
        newDesign.setLicenseText(design.getLicenseText());
        newDesign.setLastModifiedDateTime(new Date());
        if (designCopyType != 1) {
            newDesign.setReadOnly(new Boolean(true));
        } else {
            newDesign.setReadOnly(new Boolean(false));
        }
        if (setOriginalDesign) {
            newDesign.setOriginalLearningDesign(design);
        }
        newDesign.setCopyTypeID(designCopyType);
        newDesign.setContentFolderID(design.getContentFolderID());
        newDesign.setEditOverrideLock(design.getEditOverrideLock());
        newDesign.setEditOverrideUser(design.getEditOverrideUser());
        return newDesign;
    }

    public Long getLearningDesignId() {
        return this.learningDesignId;
    }

    public void setLearningDesignId(Long learningDesignId) {
        this.learningDesignId = learningDesignId;
    }

    public Integer getLearningDesignUIID() {
        return this.learningDesignUIID;
    }

    public void setLearningDesignUIID(Integer id) {
        this.learningDesignUIID = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Activity getFirstActivity() {
        return this.firstActivity;
    }

    public void setFirstActivity(Activity firstActivity) {
        this.firstActivity = firstActivity;
    }

    public Integer getMaxID() {
        return this.maxID;
    }

    public void setMaxID(Integer maxID) {
        this.maxID = maxID;
    }

    public Boolean getValidDesign() {
        return this.validDesign;
    }

    public void setValidDesign(Boolean validDesign) {
        this.validDesign = validDesign;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Date getDateReadOnly() {
        return this.dateReadOnly;
    }

    public void setDateReadOnly(Date dateReadOnly) {
        this.dateReadOnly = dateReadOnly;
    }

    public Boolean getEditOverrideLock() {
        return this.editOverrideLock;
    }

    public void setEditOverrideLock(Boolean editOverrideLock) {
        this.editOverrideLock = editOverrideLock;
    }

    public User getEditOverrideUser() {
        return this.editOverrideUser;
    }

    public void setEditOverrideUser(User editOverrideUser) {
        this.editOverrideUser = editOverrideUser;
    }

    public void setDesignVersion(Integer designVersion) {
        this.designVersion = designVersion;
    }

    public Integer getDesignVersion() {
        return this.designVersion;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public Date getCreateDateTime() {
        return this.createDateTime;
    }

    public void setCreateDateTime(Date createDateTime) {
        this.createDateTime = createDateTime != null ? createDateTime : new Date();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public LearningDesign getOriginalLearningDesign() {
        return this.originalLearningDesign;
    }

    public void setOriginalLearningDesign(LearningDesign originalLearningDesign) {
        this.originalLearningDesign = originalLearningDesign;
    }

    public Set getChildLearningDesigns() {
        return this.childLearningDesigns;
    }

    public void setChildLearningDesigns(Set childLearningDesigns) {
        this.childLearningDesigns = childLearningDesigns;
    }

    public Set getLessons() {
        return this.lessons;
    }

    public void setLessons(Set lessons) {
        this.lessons = lessons;
    }

    public Set getTransitions() {
        if (this.transitions == null) {
            this.setTransitions(new HashSet());
        }
        return this.transitions;
    }

    public void setTransitions(Set transitions) {
        this.transitions = transitions;
    }

    public Set getActivities() {
        if (this.activities == null) {
            this.setActivities(new TreeSet(new ActivityOrderComparator()));
        }
        return this.activities;
    }

    public void setActivities(Set activities) {
        this.activities = activities;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("learningDesignId", (Object)this.getLearningDesignId()).toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LearningDesign)) {
            return false;
        }
        LearningDesign castOther = (LearningDesign)other;
        return new EqualsBuilder().append((Object)this.getReadOnly(), (Object)castOther.getReadOnly()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getReadOnly()).toHashCode();
    }

    public HashMap getActivityTree() {
        HashMap<Long, Set> parentActivities = new HashMap<Long, Set>();
        for (Activity act : this.getActivities()) {
            if (act.isComplexActivity()) {
                ComplexActivity complexActivity = (ComplexActivity)act;
                parentActivities.put(complexActivity.getActivityId(), complexActivity.getActivities());
                continue;
            }
            if (act.getParentActivity() != null) continue;
            parentActivities.put(act.getActivityId(), new HashSet());
        }
        return parentActivities;
    }

    public HashSet getParentActivities() {
        HashSet<Activity> parentActivities = new HashSet<Activity>();
        for (Activity activity : this.getActivities()) {
            if (activity.getParentActivity() != null) continue;
            parentActivities.add(activity);
        }
        return parentActivities;
    }

    public Activity calculateFirstActivity() {
        Activity newFirstActivity = null;
        HashSet parentActivities = this.getParentActivities();
        for (Activity activity : parentActivities) {
            if (activity.getTransitionTo() != null) continue;
            newFirstActivity = activity;
            break;
        }
        return newFirstActivity;
    }

    public WorkspaceFolder getWorkspaceFolder() {
        return this.workspaceFolder;
    }

    public void setWorkspaceFolder(WorkspaceFolder workspaceFolder) {
        this.workspaceFolder = workspaceFolder;
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public String getLicenseText() {
        return this.licenseText;
    }

    public void setLicenseText(String licenseText) {
        this.licenseText = licenseText;
    }

    public Integer getCopyTypeID() {
        return this.copyTypeID;
    }

    public void setCopyTypeID(Integer copyTypeID) {
        this.copyTypeID = copyTypeID;
    }

    public License getLicense() {
        return this.license;
    }

    public void setLicense(License license) {
        this.license = license;
    }

    public Date getLastModifiedDateTime() {
        return this.lastModifiedDateTime;
    }

    public void setLastModifiedDateTime(Date lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime != null ? lastModifiedDateTime : new Date();
    }

    public String getOfflineInstructions() {
        return this.offlineInstructions;
    }

    public void setOfflineInstructions(String offlineInstructions) {
        this.offlineInstructions = offlineInstructions;
    }

    public String getOnlineInstructions() {
        return this.onlineInstructions;
    }

    public void setOnlineInstructions(String onlineInstructions) {
        this.onlineInstructions = onlineInstructions;
    }

    public String getContentFolderID() {
        return this.contentFolderID;
    }

    public void setContentFolderID(String contentFolderID) {
        this.contentFolderID = contentFolderID;
    }

    public DesignDetailDTO getDesignDetailDTO() {
        return new DesignDetailDTO(this);
    }

    public FolderContentDTO getFolderContentDTO() {
        return new FolderContentDTO();
    }
}

