/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.learningdesign.strategy;

import java.util.TreeSet;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.learningdesign.ActivityOrderComparator;
import org.lamsfoundation.lams.learningdesign.ComplexActivity;
import org.lamsfoundation.lams.learningdesign.NullActivity;
import org.lamsfoundation.lams.learningdesign.SequenceActivity;
import org.lamsfoundation.lams.learningdesign.strategy.ComplexActivityStrategy;

public class SequenceActivityStrategy
extends ComplexActivityStrategy {
    protected SequenceActivity sequenceActivity = null;

    public SequenceActivityStrategy(SequenceActivity sequenceActivity) {
        this.sequenceActivity = sequenceActivity;
    }

    public Activity getNextActivityByParent(ComplexActivity parent, Activity currentChild) {
        TreeSet children = new TreeSet(new ActivityOrderComparator());
        children.addAll(parent.getActivities());
        Activity inputChild = currentChild;
        if (inputChild != null) {
            if (inputChild.isNull()) {
                inputChild = null;
            } else if (inputChild.getOrderId() == null) {
                inputChild = null;
            }
        }
        for (Activity curChild : children) {
            if (inputChild != null && curChild.getOrderId().longValue() <= currentChild.getOrderId().longValue() || curChild.getTransitionTo() != null) continue;
            return curChild;
        }
        return new NullActivity();
    }

    protected boolean isComplete(int numOfCompletedActivities) {
        if (this.sequenceActivity != null) {
            return numOfCompletedActivities == this.sequenceActivity.getActivities().size();
        }
        return true;
    }

    protected ComplexActivity getComplexActivity() {
        return this.sequenceActivity;
    }
}

