/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.lesson.dao.hibernate;

import java.io.Serializable;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.lamsfoundation.lams.learningdesign.Activity;
import org.lamsfoundation.lams.lesson.LearnerProgress;
import org.lamsfoundation.lams.lesson.dao.ILearnerProgressDAO;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class LearnerProgressDAO
extends HibernateDaoSupport
implements ILearnerProgressDAO {
    protected Logger log = Logger.getLogger(LearnerProgressDAO.class);
    private static final String LOAD_PROGRESS_BY_LEARNER = "from LearnerProgress p where p.user.id = :learnerId and p.lesson.id = :lessonId";
    private static final String LOAD_PROGRESS_BY_ACTIVITY = "from LearnerProgress p where p.previousActivity = :activity or p.currentActivity = :activity or p.nextActivity = :activity ";
    private static final String LOAD_COMPLETED_PROGRESS_BY_LESSON = "from LearnerProgress p where p.lessonComplete = true and p.lesson.id = :lessonId";

    public LearnerProgress getLearnerProgress(Long learnerProgressId) {
        return (LearnerProgress)this.getHibernateTemplate().get(LearnerProgress.class, (Serializable)learnerProgressId);
    }

    public void saveLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().save((Object)learnerProgress);
    }

    public void deleteLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().delete((Object)learnerProgress);
    }

    public LearnerProgress getLearnerProgressByLearner(final Integer learnerId, final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (LearnerProgress)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_LEARNER).setInteger("learnerId", learnerId.intValue()).setLong("lessonId", lessonId.longValue()).uniqueResult();
            }
        });
    }

    public void updateLearnerProgress(LearnerProgress learnerProgress) {
        this.getHibernateTemplate().update((Object)learnerProgress);
    }

    public List getLearnerProgressReferringToActivity(final Activity activity) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_PROGRESS_BY_ACTIVITY).setEntity("activity", (Object)activity).list();
            }
        });
    }

    public List getCompletedLearnerProgressForLesson(final Long lessonId) {
        HibernateTemplate hibernateTemplate = new HibernateTemplate(this.getSessionFactory());
        this.log.debug((Object)("Hibernate template is " + hibernateTemplate));
        return (List)hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                return session.createQuery(LearnerProgressDAO.LOAD_COMPLETED_PROGRESS_BY_LESSON).setLong("lessonId", lessonId.longValue()).list();
            }
        });
    }
}

