/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.integration.dao;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.lamsfoundation.integration.dao.ILamsLessonDao;
import org.lamsfoundation.integration.webct.LamsLesson;

public class LamsLessonDaoMySqlJDBC
implements ILamsLessonDao {
    private Map settings;
    private String dbUrl;
    private String dbUser;
    private String dbPass;
    private String dbDriver;
    private String dbTable;
    private static final Logger log = Logger.getLogger((Class)LamsLessonDaoMySqlJDBC.class);

    public LamsLessonDaoMySqlJDBC() {
    }

    public LamsLessonDaoMySqlJDBC(Map settings) {
        this.settings = settings;
        this.dbUrl = (String)settings.get("dbUrl");
        this.dbUser = (String)settings.get("dbUser");
        this.dbPass = (String)settings.get("dbPass");
        this.dbDriver = (String)settings.get("dbDriver");
        this.dbTable = (String)settings.get("dbTable");
    }

    public LamsLessonDaoMySqlJDBC(String dbUrl, String dbDriver, String dbUser, String dbPass, String dbTable) {
        this.dbDriver = dbDriver;
        this.dbUser = dbUser;
        this.dbPass = dbPass;
        this.dbUrl = dbUrl;
        this.dbTable = dbTable;
    }

    public Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName(this.dbDriver).newInstance();
            conn = DriverManager.getConnection(this.dbUrl, this.dbUser, this.dbPass);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Problem getting database connection.", (Throwable)e);
        }
        return conn;
    }

    public ArrayList getDBLessons(long learningContextId, long ptId) throws Exception {
        ArrayList<LamsLesson> lessons = new ArrayList<LamsLesson>();
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            String query = "SELECT lesson_id,learning_context_id,sequence_id,owner_id,owner_first_name,owner_last_name,title,description,hidden,schedule,start_date_time,end_date_time FROM " + this.dbTable + " WHERE (learning_context_id=" + learningContextId + ") " + "AND   (pt_id=" + ptId + ")";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                LamsLesson lesson = new LamsLesson();
                lesson.setLessonId(rs.getLong("lesson_id"));
                lesson.setLearningContextId(rs.getLong("learning_context_id"));
                lesson.setSequenceId(rs.getLong("sequence_id"));
                lesson.setTitle(rs.getString("title"));
                lesson.setDescription(rs.getString("description"));
                lesson.setOwnerId(rs.getString("owner_id"));
                lesson.setOwnerFirstName(rs.getString("owner_first_name"));
                lesson.setOwnerLastName(rs.getString("owner_last_name"));
                lesson.setHidden(rs.getBoolean("hidden"));
                lesson.setSchedule(rs.getBoolean("schedule"));
                lesson.setStartTimestamp(rs.getTimestamp("start_date_time"));
                lesson.setEndTimestamp(rs.getTimestamp("end_date_time"));
                lessons.add(lesson);
            }
            stmt.close();
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)"Failed to get a list of LAMS lessons.", (Throwable)e);
            throw new Exception("Failed to get a list of LAMS lessons.");
        }
        return lessons;
    }

    public ArrayList getDBLessonsForLearner(long learningContextId, long ptId, Timestamp now) throws Exception {
        ArrayList<LamsLesson> lessons = new ArrayList<LamsLesson>();
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            String query = "SELECT lesson_id,learning_context_id,sequence_id,owner_id,owner_first_name,owner_last_name,title,description,hidden,schedule,start_date_time,end_date_time FROM " + this.dbTable + " WHERE " + "(" + "(learning_context_id=" + learningContextId + ") " + "AND (pt_id=" + ptId + ") " + "AND (hidden='false') " + "AND (" + "(schedule='false') " + "OR (" + "(start_date_time <= '" + now.toString() + "') " + "AND (end_date_time >='" + now.toString() + "')" + ")" + "OR (" + "(start_date_time <= '" + now.toString() + "') " + "AND (end_date_time IS null)" + ")" + ")" + ")";
            ResultSet rs = stmt.executeQuery(query);
            while (rs.next()) {
                LamsLesson lesson = new LamsLesson();
                lesson.setLessonId(rs.getLong("lesson_id"));
                lesson.setLearningContextId(rs.getLong("learning_context_id"));
                lesson.setSequenceId(rs.getLong("sequence_id"));
                lesson.setTitle(rs.getString("title"));
                lesson.setDescription(rs.getString("description"));
                lesson.setOwnerId(rs.getString("owner_id"));
                lesson.setOwnerFirstName(rs.getString("owner_first_name"));
                lesson.setOwnerLastName(rs.getString("owner_last_name"));
                lesson.setHidden(rs.getBoolean("hidden"));
                lesson.setSchedule(rs.getBoolean("schedule"));
                lesson.setStartTimestamp(rs.getTimestamp("start_date_time"));
                lesson.setEndTimestamp(rs.getTimestamp("end_date_time"));
                lessons.add(lesson);
            }
            stmt.close();
            connection.close();
        }
        catch (SQLException e) {
            log.error((Object)"Failed to get a list of LAMS lessons.", (Throwable)e);
            throw new Exception("Failed to get a list of LAMS lessons.");
        }
        return lessons;
    }

    public boolean createDbLesson(LamsLesson lesson) throws Exception {
        int hidden = 0;
        int schedule = 0;
        if (lesson.getHidden()) {
            hidden = 1;
        }
        if (lesson.getSchedule()) {
            schedule = 1;
        }
        String startTimeStamp = this.convertTimestamp(lesson.getStartTimestamp());
        String endTimeStamp = this.convertTimestamp(lesson.getEndTimestamp());
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            String insert = "INSERT INTO " + this.dbTable + " (lesson_id," + "pt_id," + "learning_context_id," + "sequence_id," + "owner_id," + "owner_first_name," + "owner_last_name," + "title," + "description," + "hidden," + "schedule," + "start_date_time," + "end_date_time)" + "VALUES" + "(" + lesson.getLessonId() + "," + "" + lesson.getPtId() + "," + "" + lesson.getLearningContextId() + "," + "" + lesson.getSequenceId() + "," + "'" + lesson.getOwnerId() + "'," + "'" + lesson.getOwnerFirstName() + "'," + "'" + lesson.getOwnerLastName() + "'," + "'" + lesson.getTitle() + "'," + "'" + lesson.getDescription() + "'," + "" + hidden + "," + "" + schedule + "," + "" + startTimeStamp + "," + "" + endTimeStamp + ")";
            int rows = stmt.executeUpdate(insert);
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            stmt.close();
            connection.close();
            return rows > 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)"Error inserting LAMS lesson into database.", (Throwable)e);
            throw new Exception("Error inserting LAMS lesson into database. " + e);
        }
    }

    public boolean updateLesson(LamsLesson lesson) {
        int rows = 0;
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            int hidden = 0;
            int schedule = 0;
            if (lesson.getHidden()) {
                hidden = 1;
            }
            if (lesson.getSchedule()) {
                schedule = 1;
            }
            String startTimeStamp = this.convertTimestamp(lesson.getStartTimestamp());
            String endTimeStamp = this.convertTimestamp(lesson.getEndTimestamp());
            String update = "UPDATE " + this.dbTable + " SET pt_id = " + lesson.getPtId() + ",learning_context_id = " + lesson.getLearningContextId() + ",sequence_id = " + lesson.getSequenceId() + ",owner_id = '" + lesson.getOwnerId() + "'" + ",owner_first_name = '" + lesson.getOwnerFirstName() + "'" + ",owner_last_name = '" + lesson.getOwnerLastName() + "'" + ",title = '" + lesson.getTitle() + "'" + ",description = '" + lesson.getDescription() + "'" + ",hidden = " + hidden + ",schedule = " + schedule + ",start_date_time = " + startTimeStamp + ",end_date_time = " + endTimeStamp + " " + "WHERE lesson_id = " + lesson.getLessonId();
            rows = stmt.executeUpdate(update);
            stmt.close();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)"Error updating LAMS lesson to database.", (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Error updating LAMS lesson to database.", (Throwable)e);
        }
        return rows > 0;
    }

    public boolean deleteDbLesson(long lsId) {
        int rows = 0;
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            String delete = "DELETE FROM " + this.dbTable + " WHERE lesson_id=" + lsId;
            rows = stmt.executeUpdate(delete);
            stmt.close();
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)"Error deleting LAMS lesson from database.", (Throwable)e);
        }
        return rows > 0;
    }

    public LamsLesson getDBLesson(String lsId) throws Exception {
        LamsLesson lesson = new LamsLesson();
        try {
            Connection connection = this.getConnection();
            Statement stmt = connection.createStatement();
            String query = "SELECT lesson_id,pt_id,learning_context_id,sequence_id,owner_id,owner_first_name,owner_last_name,title,description,hidden,schedule,start_date_time,end_date_time FROM " + this.dbTable + " WHERE (lesson_id=" + lsId + ")";
            ResultSet rs = stmt.executeQuery(query);
            rs.next();
            lesson.setLessonId(rs.getLong("lesson_id"));
            lesson.setPtId(rs.getLong("pt_id"));
            lesson.setLearningContextId(rs.getLong("learning_context_id"));
            lesson.setSequenceId(rs.getLong("sequence_id"));
            lesson.setTitle(rs.getString("title"));
            lesson.setDescription(rs.getString("description"));
            lesson.setOwnerId(rs.getString("owner_id"));
            lesson.setOwnerFirstName(rs.getString("owner_first_name"));
            lesson.setOwnerLastName(rs.getString("owner_last_name"));
            lesson.setHidden(rs.getBoolean("hidden"));
            lesson.setSchedule(rs.getBoolean("schedule"));
            lesson.setStartTimestamp(rs.getTimestamp("start_date_time"));
            lesson.setEndTimestamp(rs.getTimestamp("end_date_time"));
            stmt.close();
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            log.error((Object)"Failed to get LAMS lesson.", (Throwable)e);
            throw new Exception("Failed to get LAMS lesson.");
        }
        catch (Exception e) {
            throw new Exception("Failed to get LAMS lesson.");
        }
        return lesson;
    }

    public String convertTimestamp(Timestamp t) {
        String timestampStr = "null";
        if (t != null) {
            timestampStr = "'" + t + "'";
        }
        return timestampStr;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public String getDbPass() {
        return this.dbPass;
    }

    public void setDbPass(String dbPass) {
        this.dbPass = dbPass;
    }

    public Map getSettings() {
        return this.settings;
    }

    public void setSettings(Map settings) {
        this.settings = settings;
    }
}

