/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.integration.webct;

import com.webct.platform.sdk.context.client.ContextSDK;
import com.webct.platform.sdk.context.gen.LearningCtxtVO;
import com.webct.platform.sdk.context.gen.SessionVO;
import com.webct.platform.sdk.security.authentication.module.AuthenticationModule;
import com.webct.platform.sdkext.authmoduledata.UserService;
import com.webct.platform.sdkext.authmoduledata.UserVO;
import com.webct.platform.sdkext.authmoduledata.VistaDataException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.lamsfoundation.integration.dao.LamsLessonDaoMySqlJDBC;
import org.lamsfoundation.integration.webct.LamsLesson;
import org.lamsfoundation.integration.webct.LamsSecurityUtil;

public class LamsModule
extends AuthenticationModule {
    public static final String VERSION = "1.0.0";
    public static final String JARSTR = "lams2-webct-integration-1.0.0.jar";
    private HttpServletRequest request = null;
    private SessionVO _sessionVO;
    private LearningCtxtVO _currentLearningContext;
    private ContextSDK _contextSDK;
    private Map settings = null;
    private String lamsServerUrl;
    private String lamsServerId;
    private String lamsServerSecretKey;
    private String webctRequestSource;
    private Long lcID;
    UserVO user;
    private static final Logger log = Logger.getLogger((Class)LamsModule.class);

    public LamsModule() {
    }

    public LamsModule(Hashtable hashtable) {
        super(hashtable);
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    public boolean validate() {
        return true;
    }

    public boolean login() throws LoginException {
        try {
            this._contextSDK = new ContextSDK();
            this._sessionVO = this._contextSDK.getCurrentSession();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException("Problem getting context sdk object: " + e.getMessage());
        }
        return true;
    }

    public boolean abort() throws LoginException {
        return super.abort();
    }

    public boolean commit() throws LoginException {
        boolean canLearner;
        if (!super.getCurrentMode().equals("Outgoing")) {
            return false;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String html = null;
        String authorUrl = null;
        String learningDesigns = null;
        String learnerUrl = "";
        String monitorUrl = "";
        this.request = super.getRequest();
        String ptid = this.request.getParameter("id");
        if (ptid == null) {
            ptid = this.request.getParameter("tid");
            params.put("id_param_name", "tid");
        } else {
            params.put("id_param_name", "id");
        }
        params.put("pt_id", ptid);
        params.put("page_id", this.request.getParameter("page_id"));
        try {
            this.lcID = super.getCurrentLearningContextId();
            this.user = UserService.getInstance().getUser(super.getUserId(), this.lcID);
        }
        catch (VistaDataException e) {
            e.printStackTrace();
            throw new LoginException("Problem getting user details from WebCt: " + e.getMessage());
        }
        this.settings = super.getSettings(new Long(this.user.getInstitutionLCId()));
        this.lamsServerUrl = (String)this.settings.get("lamsServerUrl");
        this.lamsServerId = (String)this.settings.get("serverId");
        this.lamsServerSecretKey = (String)this.settings.get("secretKey");
        this.webctRequestSource = (String)this.settings.get("webctRequestSource");
        boolean canAuthor = this.hasLamsRole("authorRoles");
        boolean canMonitor = this.hasLamsRole("monitorRoles");
        boolean bl = canLearner = this.hasLamsRole("learnerRoles") || canMonitor;
        if (!(canAuthor || canLearner || canMonitor)) {
            throw new LoginException("User's role does not have access to these pages.");
        }
        params.put("canAuthor", new Boolean(canAuthor));
        params.put("canMonitor", new Boolean(canMonitor));
        params.put("canLearner", new Boolean(canLearner));
        boolean isTeacher = canAuthor || canMonitor;
        String action = this.request.getParameter("form_action");
        authorUrl = this.generateRequestURL(this.user, this.lcID, "author");
        if (action == null || action.trim().length() == 0) {
            try {
                learnerUrl = this.generateRequestURL(this.user, this.lcID, "learner");
            }
            catch (Exception e) {
                throw new LoginException("Bad learner request: " + e.getMessage());
            }
            if (isTeacher) {
                try {
                    LamsLessonDaoMySqlJDBC lessonDao = new LamsLessonDaoMySqlJDBC(this.settings);
                    ArrayList lessons = lessonDao.getDBLessons(this.lcID, Long.parseLong(ptid));
                    monitorUrl = this.generateRequestURL(this.user, this.lcID, "monitor");
                    params.put("lessons", lessons);
                    params.put("learnerUrl", learnerUrl);
                    params.put("monitorUrl", monitorUrl);
                    params.put("liveEditUrl", authorUrl);
                    params.put("authorUrl", authorUrl);
                    html = this.generatePage("web/teach.vm", params);
                }
                catch (Exception e) {
                    log.error((Object)"Error creating LAMS teach page", (Throwable)e);
                    throw new LoginException("Error creating LAMS teach page");
                }
            } else {
                try {
                    LamsLessonDaoMySqlJDBC lessonDao = new LamsLessonDaoMySqlJDBC(this.settings);
                    Date today = new Date();
                    Timestamp now = new Timestamp(today.getTime());
                    ArrayList lessons = lessonDao.getDBLessonsForLearner(this.lcID, Long.parseLong(ptid), now);
                    params.put("lessons", lessons);
                    params.put("learnerUrl", learnerUrl);
                    html = this.generatePage("web/learner.vm", params);
                }
                catch (Exception e) {
                    throw new LoginException("Error creating LAMS learner page");
                }
            }
        } else if (action.equalsIgnoreCase("create_lesson")) {
            try {
                params.put("imgUrl", (String)this.settings.get("imagesUrl"));
                Calendar cal = Calendar.getInstance();
                int mins = cal.get(12);
                if (mins > 55) {
                    mins = 55;
                }
                mins = mins / 5 * 5;
                String ampm = null;
                ampm = cal.get(9) == 1 ? "PM" : "AM";
                params.put("date", this.calendarToString(cal));
                params.put("sth" + cal.get(10), "selected");
                params.put("stm" + mins, "selected");
                params.put("st" + ampm, "selected");
                Calendar calend = Calendar.getInstance();
                calend.add(12, 5);
                int endmins = calend.get(12);
                if (endmins > 55) {
                    endmins = 55;
                }
                endmins = endmins / 5 * 5;
                String endampm = null;
                endampm = calend.get(9) == 1 ? "PM" : "AM";
                params.put("dateEnd", this.calendarToString(calend));
                params.put("eh" + calend.get(10), "selected");
                params.put("em" + endmins, "selected");
                params.put("e" + endampm, "selected");
                params.put("authorUrl", authorUrl);
                learningDesigns = this.getLearningDesigns(this.user, this.lcID);
                if (learningDesigns == null || learningDesigns.equals("") || learningDesigns.equals("error")) {
                    params.put("successMessage", "Could not connect to LAMS server, LAMS server may be down.<br><br>Please contact your system administrator.");
                    html = this.generatePage("web/success.vm", params);
                }
                params.put("learningDesigns", learningDesigns);
                html = this.generatePage("web/create.vm", params);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error((Object)"Error creating LAMS create lesson page: ", (Throwable)e);
                throw new LoginException("Error creating LAMS create lesson page: " + e.getMessage());
            }
        } else {
            if (action.equals("delete_lesson")) {
                String successMessage = "LAMS lesson deleted.";
                LamsLessonDaoMySqlJDBC lessonDao = new LamsLessonDaoMySqlJDBC(this.settings);
                String lsID = this.request.getParameter("lsID");
                boolean success = lessonDao.deleteDbLesson(Long.parseLong(lsID));
                if (!success) {
                    successMessage = "Failed to delete LAMS lesson.";
                }
                params.put("successMessage", successMessage);
                try {
                    html = this.generatePage("web/success.vm", params);
                }
                catch (Exception e) {
                    throw new LoginException("Error creating LAMSpage: " + e.getMessage());
                }
            }
            if (action.equalsIgnoreCase("start_lesson")) {
                String seqID = this.request.getParameter("sequence_id");
                String title = this.request.getParameter("title");
                String description = this.request.getParameter("description");
                String successMessage = "";
                long lsID = LamsSecurityUtil.startLesson(this.lamsServerUrl, this.lamsServerId, this.lamsServerSecretKey, this.webctRequestSource, this.user.getUserId(), "" + this.lcID, "en", "US", this.user.getFirstname(), this.user.getLastname(), this.user.getEmail(), seqID, title, description, "start");
                if (lsID == -1L) {
                    successMessage = "Failed to create LAMS lesson.";
                } else {
                    Timestamp start = null;
                    Timestamp end = null;
                    if (this.request.getParameter("dateStart") != null && !this.request.getParameter("dateStart").equals("")) {
                        start = this.getTimeStamp(this.request.getParameter("dateStart"), this.request.getParameter("startHour"), this.request.getParameter("startMin"), this.request.getParameter("startAMPM"));
                    }
                    if (this.request.getParameter("dateEnd") != null && !this.request.getParameter("dateEnd").equals("") && this.request.getParameter("schedule").equals("true")) {
                        end = this.getTimeStamp(this.request.getParameter("dateEnd"), this.request.getParameter("endHour"), this.request.getParameter("endMin"), this.request.getParameter("endAMPM"));
                    }
                    LamsLessonDaoMySqlJDBC lessonDao = new LamsLessonDaoMySqlJDBC(this.settings);
                    LamsLesson lesson = new LamsLesson(lsID, Long.parseLong(ptid), this.lcID, Long.parseLong(seqID), LamsSecurityUtil.replace(title, '\'', "\\'"), LamsSecurityUtil.replace(description, '\'', "\\'"), this.user.getUserId(), this.user.getFirstname(), this.user.getLastname(), this.request.getParameter("isAvailable").equals("false"), true, start, end);
                    try {
                        lessonDao.createDbLesson(lesson);
                    }
                    catch (Exception e) {
                        log.error((Object)"Could not create LAMS lesson", (Throwable)e);
                        throw new LoginException("Could not create LAMS lesson");
                    }
                    successMessage = "LAMS lesson started.";
                }
                params.put("successMessage", successMessage);
                try {
                    html = this.generatePage("web/success.vm", params);
                }
                catch (Exception e) {
                    log.error((Object)"Error creating LAMS lesson created page: ", (Throwable)e);
                    throw new LoginException("Error creating LAMS lesson created page: " + e.getMessage());
                }
            }
            if (action.equals("preview")) {
                String title = this.request.getParameter("title");
                String description = this.request.getParameter("description");
                String ldID = this.request.getParameter("sequence_id");
                if (ldID == null || ldID.equals("")) {
                    throw new LoginException("Bad preview request.");
                }
                if (title == null) {
                    title = "";
                }
                if (description == null) {
                    description = "";
                }
                try {
                    long pvID = LamsSecurityUtil.startLesson(this.lamsServerUrl, this.lamsServerId, this.lamsServerSecretKey, this.webctRequestSource, this.user.getUserId(), "" + this.lcID, "en", "US", this.user.getFirstname(), this.user.getLastname(), this.user.getEmail(), ldID, title, description, "preview");
                    String previewUrl = this.generateRequestURL(this.user, this.lcID, "learner") + "&lsid=" + pvID;
                    super.setRedirectUrl(previewUrl);
                }
                catch (Exception e) {
                    log.error((Object)"Error generating LAMS preview", (Throwable)e);
                    throw new LoginException("Error generating LAMS preview");
                }
                return true;
            }
            if (action.equals("modify_lesson")) {
                try {
                    String monthStr;
                    LamsLessonDaoMySqlJDBC lessonDao = new LamsLessonDaoMySqlJDBC(this.settings);
                    LamsLesson modLesson = lessonDao.getDBLesson(this.request.getParameter("lsID"));
                    params.put("lsID", this.request.getParameter("lsID"));
                    params.put("title", modLesson.getTitle());
                    params.put("description", modLesson.getDescription());
                    if (modLesson.getStartTimestamp() != null) {
                        Calendar calendarStart = Calendar.getInstance();
                        calendarStart.setTime(modLesson.getStartTimestamp());
                        String dayStr = "" + calendarStart.get(5);
                        if (dayStr.length() <= 1) {
                            dayStr = "0" + dayStr;
                        }
                        if ((monthStr = "" + (calendarStart.get(2) + 1)).length() <= 1) {
                            monthStr = "0" + monthStr;
                        }
                        params.put("startStr", dayStr + "/" + monthStr + "/" + calendarStart.get(1));
                        params.put("stHrCk" + calendarStart.get(10), "selected");
                        params.put("stMnCk" + calendarStart.get(12), "selected");
                        params.put("stAmCk" + calendarStart.get(9), "selected");
                    } else {
                        Calendar cal = Calendar.getInstance();
                        int mins = cal.get(12);
                        if (mins > 55) {
                            mins = 55;
                        }
                        mins = mins / 5 * 5;
                        params.put("startStr", this.calendarToString(cal));
                        params.put("stHrCk" + cal.get(10), "selected");
                        params.put("stMnCk" + mins, "selected");
                        params.put("stAmCk" + cal.get(9), "selected");
                    }
                    if (modLesson.getEndTimestamp() != null) {
                        params.put("endDisabled", "");
                        params.put("schedule", "checked");
                        Calendar calendarEnd = Calendar.getInstance();
                        calendarEnd.setTime(modLesson.getEndTimestamp());
                        String dayStr = "" + calendarEnd.get(5);
                        if (dayStr.length() <= 1) {
                            dayStr = "0" + dayStr;
                        }
                        if ((monthStr = "" + (calendarEnd.get(2) + 1)).length() <= 1) {
                            monthStr = "0" + monthStr;
                        }
                        params.put("endStr", dayStr + "/" + monthStr + "/" + calendarEnd.get(1));
                        params.put("endStrGenerated", dayStr + "/" + monthStr + "/" + calendarEnd.get(1));
                        params.put("edHrCk" + calendarEnd.get(10), "selected");
                        params.put("edMnCk" + calendarEnd.get(12), "selected");
                        params.put("edAmCk" + calendarEnd.get(9), "selected");
                    } else {
                        Calendar calend;
                        if (modLesson.getStartTimestamp() != null) {
                            calend = Calendar.getInstance();
                            calend.setTime(modLesson.getStartTimestamp());
                            calend.add(12, 5);
                            int endmins = calend.get(12);
                            if (endmins > 55) {
                                endmins = 55;
                            }
                            endmins = endmins / 5 * 5;
                            params.put("endStr", "");
                            params.put("endStrGenerated", this.calendarToString(calend));
                            params.put("edHrCk" + calend.get(10), "selected");
                            params.put("edMnCk" + endmins, "selected");
                            params.put("edAmCk" + calend.get(9), "selected");
                        } else {
                            calend = Calendar.getInstance();
                            calend.add(12, 5);
                            int endmins = calend.get(12);
                            if (endmins > 55) {
                                endmins = 55;
                            }
                            endmins = endmins / 5 * 5;
                            params.put("edHrCk" + calend.get(10), "selected");
                            params.put("edMnCk" + endmins, "selected");
                            params.put("edAmCk" + calend.get(9), "selected");
                            params.put("endStr", this.calendarToString(calend));
                            params.put("endStrGenerated", this.calendarToString(calend));
                        }
                        params.put("endDisabled", "disabled");
                        params.put("notschedule", "checked");
                    }
                    if (modLesson.getHidden()) {
                        params.put("hidden", "checked");
                    } else {
                        params.put("nothidden", "checked");
                    }
                    html = this.generatePage("web/modify.vm", params);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error((Object)"Error creating LAMS lesson modify page: ", (Throwable)e);
                    throw new LoginException("Error creating LAMS lesson modify page: " + e.getMessage());
                }
            }
            if (action.equals("modify_proc")) {
                LamsLessonDaoMySqlJDBC lessonDao = new LamsLessonDaoMySqlJDBC(this.settings);
                try {
                    LamsLesson modLesson = lessonDao.getDBLesson(this.request.getParameter("lsID"));
                    modLesson.setTitle(LamsSecurityUtil.replace(this.request.getParameter("title"), '\'', "\\'"));
                    modLesson.setDescription(LamsSecurityUtil.replace(this.request.getParameter("description"), '\'', "\\'"));
                    modLesson.setHidden(this.request.getParameter("isAvailable").equals("false"));
                    modLesson.setSchedule(true);
                    Timestamp start = null;
                    Timestamp end = null;
                    if (this.request.getParameter("dateStart") != null && !this.request.getParameter("dateStart").equals("")) {
                        start = this.getTimeStamp(this.request.getParameter("dateStart"), this.request.getParameter("startHour"), this.request.getParameter("startMin"), this.request.getParameter("startAMPM"));
                    }
                    if (this.request.getParameter("dateEnd") != null && !this.request.getParameter("dateEnd").equals("")) {
                        end = this.getTimeStamp(this.request.getParameter("dateEnd"), this.request.getParameter("endHour"), this.request.getParameter("endMin"), this.request.getParameter("endAMPM"));
                    }
                    modLesson.setStartTimestamp(start);
                    modLesson.setEndTimestamp(end);
                    boolean success = lessonDao.updateLesson(modLesson);
                    if (success) {
                        params.put("successMessage", "LAMS lesson updated successfully.");
                    } else {
                        params.put("successMessage", "Unable to update LAMS lesson.");
                    }
                    html = this.generatePage("web/success.vm", params);
                }
                catch (Exception e) {
                    log.error((Object)"Error creating LAMS lesson created page: ", (Throwable)e);
                    throw new LoginException("Error creating LAMS lesson created page: " + e.getMessage());
                }
            }
        }
        super.setResponseContent(html);
        return true;
    }

    private String generatePage(String htmlTemplate, Map contextObjects) throws Exception {
        String jar_base = "./deployablecomponents/lams2/";
        VelocityEngine ve = new VelocityEngine();
        Properties props = new Properties();
        props.setProperty("resource.loader", "file, jar");
        props.setProperty("file.resource.loader.path", jar_base);
        props.setProperty("jar.resource.loader.class", "org.apache.velocity.runtime.resource.loader.JarResourceLoader");
        props.setProperty("jar.resource.loader.path", "jar:file:" + jar_base + JARSTR);
        ve.init(props);
        VelocityContext context = new VelocityContext();
        Iterator it = contextObjects.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            context.put(key, contextObjects.get(key));
        }
        context.put("request", (Object)this.request);
        context.put("settings", (Object)this.settings);
        context.put("authmod", (Object)this);
        Template template = null;
        template = ve.getTemplate(htmlTemplate);
        StringWriter html = new StringWriter();
        template.merge((Context)context, (Writer)html);
        return html.toString();
    }

    public String generateRequestURL(UserVO user, Long lcID, String method) throws LoginException {
        String authorUrl = "";
        try {
            authorUrl = LamsSecurityUtil.generateRequestURL(this.lamsServerUrl, this.lamsServerId, this.lamsServerSecretKey, this.webctRequestSource, user.getUserId(), "" + lcID, "en", "US", user.getFirstname(), user.getLastname(), user.getEmail(), method);
            log.info((Object)("LAMS AUTHOR REQUEST: " + authorUrl));
            return authorUrl;
        }
        catch (Exception e) {
            log.error((Object)"Problem generating request url:", (Throwable)e);
            e.printStackTrace();
            throw new LoginException("Problem getting author url:" + e.getMessage());
        }
    }

    public String getLearningDesigns(UserVO user, Long lcID) throws LoginException {
        String learningDesigns = "";
        try {
            learningDesigns = LamsSecurityUtil.getLearningDesigns(this.lamsServerUrl, this.lamsServerId, this.lamsServerSecretKey, user.getUserId(), "" + lcID, "en", "US", user.getFirstname(), user.getLastname(), user.getEmail(), "1");
            log.info((Object)("LAMS LEARNING DESIGNS: " + learningDesigns));
            return learningDesigns;
        }
        catch (Exception e) {
            log.error((Object)"Problem getting learning desings:", (Throwable)e);
            e.printStackTrace();
            throw new LoginException("Problem getting learning desings: " + e.getMessage());
        }
    }

    public Timestamp getTimeStamp(String date, String hours, String minutes, String ampm) {
        String[] dateSplit = date.split("/");
        date = dateSplit[2] + "-" + dateSplit[1] + "-" + dateSplit[0];
        if (ampm.equals("PM")) {
            int hoursInt = Integer.parseInt(hours);
            hours = "" + (hoursInt += 12);
        }
        String timestampStr = date + " " + hours + ":" + minutes + ":" + "00";
        Timestamp t = Timestamp.valueOf(timestampStr);
        return t;
    }

    public boolean hasLamsRole(String lamsRoleType) {
        boolean hasLameRole = false;
        String[] learnerRoles = (String[])this.settings.get(lamsRoleType);
        for (int i = 0; i < learnerRoles.length; ++i) {
            String role = learnerRoles[i];
            if (!this.hasSpecificRole(role)) continue;
            hasLameRole = true;
        }
        return hasLameRole;
    }

    public boolean hasSpecificRole(String roleParam) {
        UserVO user = null;
        try {
            user = UserService.getInstance().getUser(super.getUserId(), this.lcID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List roles = user.getUserRoles();
        Iterator it = roles.iterator();
        boolean hasRole = false;
        while (it.hasNext()) {
            String role = it.next().toString().trim();
            if (!role.equals(roleParam)) continue;
            hasRole = true;
        }
        return hasRole;
    }

    public boolean logout() throws LoginException {
        return super.logout();
    }

    public String calendarToString(Calendar cal) {
        int day = cal.get(5);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        String dayStr = "" + day;
        String monthStr = "" + month;
        if (day < 10) {
            dayStr = "0" + day;
        }
        if (month < 10) {
            monthStr = "0" + month;
        }
        return dayStr + "/" + monthStr + "/" + year;
    }
}

