/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.integration.webct;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LamsSecurityUtil {
    static Logger logger = Logger.getLogger((Class)LamsSecurityUtil.class);

    public static String generateRequestURL(String serverAddr, String serverId, String secretKey, String reqSrc, String username, String courseId, String lang, String country, String firstName, String lastName, String email, String method) throws Exception {
        String url;
        if (serverAddr == null || serverId == null || reqSrc == null) {
            throw new Exception("Configuration Exception " + serverAddr + ", " + serverId);
        }
        String timestamp = new Long(System.currentTimeMillis()).toString();
        String hash = LamsSecurityUtil.generateAuthenticationHash(timestamp, username, method, serverId, secretKey);
        try {
            url = serverAddr + "/LoginRequest?" + "&uid=" + URLEncoder.encode(username, "UTF8") + "&method=" + method + "&ts=" + timestamp + "&sid=" + serverId + "&hash=" + hash + "&courseid=" + URLEncoder.encode(courseId, "UTF8") + "&country=" + country + "&lang=" + lang + "&requestSrc=" + URLEncoder.encode(reqSrc, "UTF8") + "&firstName=" + firstName + "&lastName=" + lastName + "&email=" + email;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
        logger.info((Object)("LAMS Req: " + url));
        return url;
    }

    public static String getLearningDesigns(String serverAddr, String serverId, String secretKey, String username, String courseId, String lang, String country, String firstName, String lastName, String email, String mode) throws Exception {
        String timestamp = new Long(System.currentTimeMillis()).toString();
        String hash = LamsSecurityUtil.generateAuthenticationHash(timestamp, username, serverId, secretKey);
        String learningDesigns = "[]";
        try {
            HttpURLConnection httpConn;
            String serviceURL = serverAddr + "/services/xml/LearningDesignRepository?" + "datetime=" + timestamp + "&username=" + URLEncoder.encode(username, "UTF8") + "&serverId=" + URLEncoder.encode(serverId, "UTF8") + "&hashValue=" + hash + "&courseId=" + URLEncoder.encode(courseId, "UTF8") + "&country=" + country + "&lang=" + lang + "&mode=" + mode + "&firstName=" + firstName + "&lastName=" + lastName + "&email=" + email;
            URL url = new URL(serviceURL);
            URLConnection conn = url.openConnection();
            if (!(conn instanceof HttpURLConnection)) {
                logger.error((Object)("Unable to open connection to: " + serviceURL));
            }
            if ((httpConn = (HttpURLConnection)conn).getResponseCode() != 200) {
                logger.error((Object)("HTTP Response Code: " + httpConn.getResponseCode() + ", HTTP Response Message: " + httpConn.getResponseMessage()));
                return "error";
            }
            InputStream is = conn.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(is);
            learningDesigns = "[" + LamsSecurityUtil.convertToTigraFormat(document.getDocumentElement()) + "]";
            String pattern = "'(\\d+)'";
            String replacement = "'javascript:selectSequence($1)'";
            learningDesigns = learningDesigns.replaceAll(pattern, replacement);
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Unable to get LAMS learning designs, bad URL: '" + serverAddr + "', please check lams.properties"), (Throwable)e);
            e.printStackTrace();
            return "error";
        }
        catch (IllegalStateException e) {
            logger.error((Object)"LAMS Server timeout, did not get a response from the LAMS server. Please contact your systems administrator", (Throwable)e);
            e.printStackTrace();
            return "error";
        }
        catch (ConnectException e) {
            logger.error((Object)"LAMS Server timeout, did not get a response from the LAMS server. Please contact your systems administrator", (Throwable)e);
            e.printStackTrace();
            return "error";
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e);
            e.printStackTrace();
            return "error";
        }
        catch (IOException e) {
            logger.error((Object)e);
            e.printStackTrace();
            return "error";
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)e);
            e.printStackTrace();
            return "error";
        }
        catch (SAXException e) {
            logger.error((Object)e);
            e.printStackTrace();
            return "error";
        }
        return learningDesigns;
    }

    public static long startLesson(String serverAddr, String serverId, String secretKey, String reqSrc, String username, String courseId, String lang, String country, String firstName, String lastName, String email, String ldId, String title, String desc, String method) {
        long error = -1L;
        if (serverId == null || serverAddr == null || secretKey == null) {
            logger.error((Object)"Unable to retrieve learning designs from LAMS, one or more lams configuration properties is null");
            return error;
        }
        try {
            HttpURLConnection httpConn;
            String timestamp = new Long(System.currentTimeMillis()).toString();
            String hash = LamsSecurityUtil.generateAuthenticationHash(timestamp, username, serverId, secretKey);
            String serviceURL = serverAddr + "/services/xml/LessonManager?" + "&serverId=" + URLEncoder.encode(serverId, "UTF8") + "&datetime=" + timestamp + "&username=" + URLEncoder.encode(username, "UTF8") + "&hashValue=" + hash + "&courseId=" + URLEncoder.encode(courseId, "UTF8") + "&ldId=" + ldId + "&country=" + country + "&lang=" + lang + "&method=" + method + "&title=" + URLEncoder.encode(title, "UTF8") + "&desc=" + URLEncoder.encode(desc, "UTF8");
            logger.info((Object)("LAMS START LESSON Req: " + serviceURL));
            URL url = new URL(serviceURL);
            URLConnection conn = url.openConnection();
            if (!(conn instanceof HttpURLConnection)) {
                logger.error((Object)("Unable to open connection to: " + serviceURL));
            }
            if ((httpConn = (HttpURLConnection)conn).getResponseCode() != 200) {
                logger.error((Object)("HTTP Response Code: " + httpConn.getResponseCode() + ", HTTP Response Message: " + httpConn.getResponseMessage()));
                return error;
            }
            InputStream is = conn.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(is);
            return Long.parseLong(document.getElementsByTagName("Lesson").item(0).getAttributes().getNamedItem("lessonId").getNodeValue());
        }
        catch (MalformedURLException e) {
            logger.error((Object)("Unable to start LAMS lesson, bad URL: '" + serverAddr + "', please check lams.properties"), (Throwable)e);
            e.printStackTrace();
            return error;
        }
        catch (IllegalStateException e) {
            logger.error((Object)"LAMS Server timeout, did not get a response from the LAMS server. Please contact your systems administrator", (Throwable)e);
            e.printStackTrace();
            return error;
        }
        catch (RemoteException e) {
            logger.error((Object)"Unable to start LAMS lesson, RMI Remote Exception", (Throwable)e);
            e.printStackTrace();
            return error;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"Unable to start LAMS lesson, Unsupported Encoding Exception", (Throwable)e);
            e.printStackTrace();
            return error;
        }
        catch (ConnectException e) {
            logger.error((Object)"LAMS Server timeout, did not get a response from the LAMS server. Please contact your systems administrator", (Throwable)e);
            e.printStackTrace();
            return error;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to start LAMS lesson. Please contact your system administrator.", (Throwable)e);
            e.printStackTrace();
            return error;
        }
    }

    public static String convertToTigraFormat(Node node) {
        StringBuffer sb = new StringBuffer();
        if (node.getNodeName().equals("Folder")) {
            sb.append("['");
            String attributeStr = node.getAttributes().getNamedItem("name").getNodeValue();
            attributeStr = LamsSecurityUtil.replace(attributeStr, '\'', "\\'");
            attributeStr = LamsSecurityUtil.replace(attributeStr, '\"', "\\\"");
            StringBuffer attribute = new StringBuffer(attributeStr);
            sb.append(attribute.append("',").append("null").append(','));
            NodeList children = node.getChildNodes();
            if (children.getLength() == 0) {
                sb.append("['',null]");
            } else {
                sb.append(LamsSecurityUtil.convertToTigraFormat(children.item(0)));
                for (int i = 1; i < children.getLength(); ++i) {
                    sb.append(',').append(LamsSecurityUtil.convertToTigraFormat(children.item(i)));
                }
            }
            sb.append(']');
        } else if (node.getNodeName().equals("LearningDesign")) {
            sb.append('[');
            String attributeStr = node.getAttributes().getNamedItem("name").getNodeValue();
            attributeStr = LamsSecurityUtil.replace(attributeStr, '\'', "\\'");
            attributeStr = LamsSecurityUtil.replace(attributeStr, '\"', "\\\"");
            StringBuffer attrName = new StringBuffer(attributeStr);
            String attrResIdStr = node.getAttributes().getNamedItem("resourceId").getNodeValue();
            attrResIdStr = LamsSecurityUtil.replace(attrResIdStr, '\'', "\\'");
            attrResIdStr = LamsSecurityUtil.replace(attrResIdStr, '\"', "\\\"");
            StringBuffer attrResId = new StringBuffer(attrResIdStr);
            sb.append('\'').append(attrName.append('\'').append(',').append('\'').append(attrResId.append('\'')));
            sb.append(']');
        }
        return sb.toString();
    }

    public static String replace(String line, char oldChar, String newStr) {
        String result = "";
        if (line != null) {
            for (int j = 0; j < line.length(); ++j) {
                result = line.charAt(j) == oldChar ? result + newStr : result + line.charAt(j);
            }
        }
        return result;
    }

    public static String generateAuthenticationHash(String datetime, String login, String method, String serverId, String secretkey) {
        String plaintext = datetime.toLowerCase().trim() + login.toLowerCase().trim() + method.toLowerCase().trim() + serverId.toLowerCase().trim() + secretkey.toLowerCase().trim();
        String hash = LamsSecurityUtil.sha1(plaintext);
        return hash;
    }

    public static String generateAuthenticationHash(String datetime, String login, String serverId, String secretkey) {
        String plaintext = datetime.toLowerCase().trim() + login.toLowerCase().trim() + serverId.toLowerCase().trim() + secretkey.toLowerCase().trim();
        String hash = LamsSecurityUtil.sha1(plaintext);
        return hash;
    }

    public static String generateAuthenticationHash(String datetime, String serverId, String secretkey) throws NoSuchAlgorithmException {
        String plaintext = datetime.toLowerCase().trim() + serverId.toLowerCase().trim() + secretkey.toLowerCase().trim();
        return LamsSecurityUtil.sha1(plaintext);
    }

    public static String sha1(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return new String(Hex.encodeHex((byte[])md.digest(str.getBytes())));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

