/*
 * Decompiled with CFR 0.152.
 */
package org.lamsfoundation.lams.admin.web;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.lamsfoundation.lams.learningdesign.dto.LearningLibraryDTO;
import org.lamsfoundation.lams.learningdesign.dto.LibraryActivityDTO;
import org.lamsfoundation.lams.learningdesign.service.ILearningDesignService;
import org.lamsfoundation.lams.usermanagement.service.IUserManagementService;
import org.lamsfoundation.lams.util.WebUtil;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LibraryManageAction
extends Action {
    public static final String LEARNING_DESIGN_SERVICE_BEAN_NAME = "learningDesignService";
    private static final String USER_MANAGEMENT_SERVICE_BEAN_NAME = "userManagementService";
    public static final String REQUEST_LIBRARIES = "libraries";
    public static final String PARAM_LIBRARY_ID = "libraryID";
    public static final String PARAM_ACTION = "action";
    public static final String ERROR_MSG_NO_PRIVILEDGE = "error.no.sysadmin.priviledge";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String param = request.getParameter(PARAM_ACTION);
        if (StringUtils.equals((String)param, (String)"enable") && this.checkPriviledge(request)) {
            this.enableLibray(mapping, form, request, response);
        }
        if (StringUtils.equals((String)param, (String)"disable") && this.checkPriviledge(request)) {
            this.disableLibray(mapping, form, request, response);
        }
        ILearningDesignService ldService = this.getLearningDesignService();
        ArrayList lds = ldService.getAllLearningLibraryDetails(false);
        for (LearningLibraryDTO libraryDTO : lds) {
            Vector activities = libraryDTO.getTemplateActivities();
            if (activities == null) continue;
            Iterator actIter = activities.iterator();
            while (actIter.hasNext()) {
                LibraryActivityDTO act = (LibraryActivityDTO)actIter.next();
                if (act.getLearningLibraryID() != null) continue;
                actIter.remove();
            }
        }
        request.setAttribute(REQUEST_LIBRARIES, (Object)lds);
        return mapping.findForward("success");
    }

    private void disableLibray(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long learningLibraryId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LIBRARY_ID, (boolean)false);
        ILearningDesignService ldService = this.getLearningDesignService();
        ldService.setValid(learningLibraryId, false);
    }

    private void enableLibray(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long learningLibraryId = WebUtil.readLongParam((HttpServletRequest)request, (String)PARAM_LIBRARY_ID, (boolean)false);
        ILearningDesignService ldService = this.getLearningDesignService();
        ldService.setValid(learningLibraryId, true);
    }

    private ILearningDesignService getLearningDesignService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (ILearningDesignService)wac.getBean(LEARNING_DESIGN_SERVICE_BEAN_NAME);
    }

    private IUserManagementService getUserManagementService() {
        WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServlet().getServletContext());
        return (IUserManagementService)wac.getBean(USER_MANAGEMENT_SERVICE_BEAN_NAME);
    }

    private boolean checkPriviledge(HttpServletRequest request) {
        if (!this.getUserManagementService().isUserSysAdmin()) {
            ActionMessages errors = new ActionMessages();
            errors.add("org.apache.struts.action.GLOBAL_MESSAGE", new ActionMessage(ERROR_MSG_NO_PRIVILEDGE));
            this.saveErrors(request, errors);
            return false;
        }
        return true;
    }
}

